/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.debug;

import com.ca.intertest.common.Messages;
import com.ca.intertest.debug.Debug;
import com.ca.intertest.debug.IDebug;
import com.ca.intertest.debug.debugFile;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.tools.ITException;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;

public class RequestBreakpointMessage
extends com.ca.intertest.tools.RequestBreakpointMessage {
    static String cacopyright = "Copyright \u00a9 2016 CA";

    public RequestBreakpointMessage(IMarker marker) throws ITException {
        this();
        short commandID = (short)marker.getAttribute("cmd", 0);
        if (commandID == 0) {
            throw new ITException(Messages.RequestBreakpointMessage_0);
        }
        IResource res = marker.getResource();
        IDebug debugitem = Debug.getInstance().getResource(res);
        debugSession session = debugitem.getSession();
        if (session.isCICS()) {
            byte type = (byte)(marker.getAttribute("rbp_type", 0) & 0x88);
            debugFile file = session.getFile(res);
            switch (file.getFiletype()) {
                case TERMID: {
                    type = (byte)(type | 0x40);
                    break;
                }
                case TRANID: {
                    type = (byte)(type | 0x20);
                }
            }
            this.setRbp_type(type);
        } else {
            this.setRbp_type(8);
        }
        this.setRbp_codes(new short[]{commandID});
        this.enabled = marker.getAttribute("BREAKPOINT_ENABLED", false);
        if (!debugitem.equals(session)) {
            this.setProgram(debugitem.getName());
        }
    }

    public RequestBreakpointMessage() {
    }

    public RequestBreakpointMessage(long ID) {
        super(ID);
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }
}

