/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.debug;

import com.ca.intertest.common.Logger;
import com.ca.intertest.common.Messages;
import com.ca.intertest.debug.BreakpointMarker;
import com.ca.intertest.debug.BreakpointMessageFactory;
import com.ca.intertest.debug.CVMI;
import com.ca.intertest.debug.CVMO;
import com.ca.intertest.debug.DebugTalker;
import com.ca.intertest.debug.ExecutionCountsMessage;
import com.ca.intertest.debug.IDebug;
import com.ca.intertest.debug.MonitorMessage;
import com.ca.intertest.debug.QueueBreakpoints;
import com.ca.intertest.debug.RequestBreakpointMessage;
import com.ca.intertest.debug.SetBacktraceMessage;
import com.ca.intertest.debug.UnsetBreakpointMessage;
import com.ca.intertest.debug.debugFile;
import com.ca.intertest.debug.debugSession;
import com.ca.intertest.tools.BreakpointMessage;
import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.ITException;
import com.ca.intertest.tools.StepSetMessage;
import java.util.Iterator;

public class BatchQueueBreakpoints
extends QueueBreakpoints {
    String cacopyright = "Copyright \u00a9 2016 CA";
    DebugTalker talker;

    BatchQueueBreakpoints(debugSession session) {
        super(session);
    }

    @Override
    protected synchronized void post() throws Exception {
        if (!this.session.isAtBreakpoint()) {
            return;
        }
        this.talker = this.session.getTalker();
        debugFile debugfile = this.talker.getDebugfile();
        CVMO cvmo = null;
        CVMI cvmi = new CVMI();
        for (debugFile item : this.monitors) {
            if (!item.equals(debugfile)) {
                this.processMonitored(item, cvmi);
            }
            this.buildMessages(cvmi);
            if (cvmi.size() <= 0) continue;
            try {
                cvmo = this.talker.process(cvmi);
                this.postbreakpoints(cvmi, cvmo);
            }
            catch (Exception exception) {}
        }
        this.monitors.clear();
        this.buildMessages(cvmi);
        if (cvmi.size() == 0) {
            return;
        }
        try {
            cvmo = this.talker.process(cvmi);
        }
        catch (Exception exception) {}
        this.postbreakpoints(cvmi, cvmo);
    }

    private void processMonitored(debugFile file, CVMI cvmi) throws ITException, Exception {
        CVMO cvmo = null;
        if (file.isMonitor()) {
            if (file.isEntered()) {
                cvmo = new CVMO();
            } else {
                cvmi.addMessage((DebugMessage)new MonitorMessage(file));
            }
        } else {
            cvmi.addMessage((DebugMessage)new MonitorMessage(file));
        }
        if (cvmo == null) {
            cvmo = this.talker.process(cvmi);
        }
        if (cvmo.getErrorLevel() >= 8) {
            file.setMonitor(false, false);
        }
        this.clearBreakpoints(file);
    }

    @Override
    protected void buildMessages(CVMI cvmi) {
        if (this.isSetStepAfter()) {
            StepSetMessage stepmsg = new StepSetMessage();
            stepmsg.setAfter(this.session.isStepAfter());
            cvmi.addMessage((DebugMessage)stepmsg);
            this.setSetStepAfter(false);
        }
        Iterator rbpit = this.rbpmap.iterator();
        while (rbpit.hasNext()) {
            BreakpointMarker item = (BreakpointMarker)rbpit.next();
            try {
                RequestBreakpointMessage message;
                BreakpointMessage[] messages = BreakpointMessageFactory.getInstance(item);
                RequestBreakpointMessage requestBreakpointMessage = message = messages.length == 0 ? null : (RequestBreakpointMessage)messages[0];
                if (message == null) continue;
                cvmi.addMessage((DebugMessage)message);
                rbpit.remove();
            }
            catch (Exception e) {
                Logger.loggit(e);
            }
        }
        Iterator markerit = this.bkpts.iterator();
        while (markerit.hasNext()) {
            BreakpointMarker item = (BreakpointMarker)markerit.next();
            if (item != null && item.isValid()) {
                debugFile debugfile = this.session.getFile(item.getResource());
                if (debugfile == null || !debugfile.isEntered()) continue;
                try {
                    BreakpointMessage[] postits = BreakpointMessageFactory.getInstance(item);
                    BreakpointMessage postit = postits[0];
                    if (postit instanceof UnsetBreakpointMessage) {
                        if (postit.getBreakpointID() == 0L) {
                            postits = null;
                        } else {
                            item.setBreakpointID(0L);
                        }
                        debugfile.removeBreakpointMarker(item.getMarker());
                    } else if (postit.getBreakpointID() != 0L) {
                        postits = null;
                    }
                    if (postits != null) {
                        BreakpointMessage[] breakpointMessageArray = postits;
                        int n = postits.length;
                        int n2 = 0;
                        while (n2 < n) {
                            BreakpointMessage msg = breakpointMessageArray[n2];
                            cvmi.addMessage((DebugMessage)msg);
                            ++n2;
                        }
                    }
                }
                catch (Exception e) {
                    Logger.loggit(e);
                }
            }
            markerit.remove();
        }
        Iterator countit = this.counts.iterator();
        while (countit.hasNext()) {
            ExecutionCountsMessage item = (ExecutionCountsMessage)((Object)countit.next());
            cvmi.addMessage((DebugMessage)item);
            countit.remove();
        }
        Iterator traceit = this.traces.iterator();
        while (traceit.hasNext()) {
            SetBacktraceMessage item = (SetBacktraceMessage)((Object)traceit.next());
            cvmi.addMessage((DebugMessage)item);
            traceit.remove();
        }
        Iterator datait = this.datamonitor.iterator();
        while (datait.hasNext()) {
            SetBacktraceMessage item = (SetBacktraceMessage)((Object)datait.next());
            cvmi.addMessage((DebugMessage)item);
            datait.remove();
        }
    }

    @Override
    public void addExecutionCount(IDebug resource, boolean force, short subId) throws Exception {
        if (!(resource instanceof debugSession)) {
            return;
        }
        if (!this.session.isDebugging()) {
            return;
        }
        if (force || resource.isExecutionCount()) {
            ExecutionCountsMessage msg = new ExecutionCountsMessage(resource);
            if (subId < 0) {
                msg.setSubmessageID((short)1);
            } else {
                msg.setSubmessageID(subId);
            }
            this.counts.add(msg);
        }
    }

    @Override
    public void addStatementTrace(IDebug resource, boolean force) throws Exception {
        if (resource instanceof debugFile) {
            return;
        }
        if (!this.session.isDebugging()) {
            return;
        }
        if (force || resource.isStatementTrace()) {
            this.traces.add(new SetBacktraceMessage(resource, "back_trace"));
        }
    }

    @Override
    public void addDataMonitor(IDebug resource, boolean force) throws Exception {
        if (!(resource instanceof debugFile) && !(resource instanceof debugSession)) {
            return;
        }
        if (!this.session.isDebugging()) {
            return;
        }
        if (force || resource.isDataMonitor()) {
            if (resource.isDataMonitor() && !this.session.isDataMonitorOK()) {
                Logger.loggit(4, Messages.BatchQueueBreakpoints_1);
                return;
            }
            this.datamonitor.add(new SetBacktraceMessage(resource, "data_monitor"));
        }
    }

    @Override
    public void buildMonitoredList(CVMI cvmi) {
        for (debugFile file : this.monitors) {
            try {
                cvmi.addMessage((DebugMessage)new MonitorMessage(file));
            }
            catch (Exception e) {
                Logger.loggit(e);
            }
        }
        this.monitors.clear();
    }

    @Override
    protected void addBreakpoints(debugFile file) {
        super.addBreakpoints(file);
        if (file.isDataMonitor()) {
            try {
                this.addDataMonitor(file, true);
            }
            catch (Exception e) {
                Logger.loggit(e);
            }
        }
    }
}

