/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.common;

import com.ca.intertest.IntertestPlugin;
import com.ca.intertest.common.IConstants;
import com.ca.intertest.common.Logger;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;

public class DumpMarker {
    private static final boolean dump = IntertestPlugin.isTracing() && Boolean.parseBoolean(Platform.getDebugOption((String)"com.ca.intertest/debug/markers"));
    static String cacopyright = "Copyright \u00a9 2016 CA";
    private static final String format = "[%s:%s]";
    private static final String format2 = "Marker:%s:ID:%d";

    private DumpMarker() {
    }

    public static void dump(IMarker marker) {
        if (dump) {
            try {
                String type = marker.getType();
                Map map = marker.getAttributes();
                StringBuilder string = new StringBuilder(1000);
                string.append(String.format(format2, type, marker.getId()));
                string.append(IConstants.LINEFEED);
                string.append("Resource:");
                IResource res = marker.getResource();
                if (res.getType() != 4) {
                    string.append(res.getProject().getName());
                    string.append("/");
                }
                string.append(res.getName());
                string.append(IConstants.LINEFEED);
                if (map != null) {
                    Set attrs = map.entrySet();
                    for (Map.Entry item : attrs) {
                        Object value = item.getValue();
                        if (value == null) {
                            value = "[null]";
                        }
                        string.append(String.format(format, item.getKey(), value.toString()));
                        string.append(IConstants.LINEFEED);
                    }
                }
                Logger.loggit(0, string.toString());
            }
            catch (CoreException e) {
                Logger.loggit(e);
            }
        }
    }

    public static void dump(IMarker[] markers) {
        if (dump) {
            IMarker[] iMarkerArray = markers;
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                DumpMarker.dump(marker);
                ++n2;
            }
        }
    }
}

