/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest;

import com.ca.intertest.common.IConstants;
import com.ca.intertest.common.Keywords;
import com.ca.intertest.common.Logger;
import com.ca.intertest.common.Messages;
import com.ca.intertest.debug.Debug;
import com.ca.intertest.debug.DebugServer;
import com.ca.intertest.server.ServerList;
import com.ca.intertest.tools.ITException;
import com.ca.intertest.ui.lister.util.ColorProvider;
import com.ca.intertest.ui.lister.util.IWordProvider;
import com.ca.intertest.ui.lister.util.ReservedWordProvider;
import java.io.File;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.UUID;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.cheatsheets.OpenCheatSheetAction;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class IntertestPlugin
extends AbstractUIPlugin {
    private static final String CHEATSHEET = "com.ca.intertest.cheatsheet.overview";
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    private final ArrayList<Bundle> bundles = new ArrayList(3);
    private static ScopedPreferenceStore defaultPreferences = null;
    private static ScopedPreferenceStore configurationPreferences = null;
    private static ScopedPreferenceStore instancePreferences = null;
    private Dictionary<?, ?> headers;
    private static boolean errorviewloaded = true;
    private final UUID PluginUUID = UUID.randomUUID();
    private static IPath location;
    private static IntertestPlugin plugin;
    private static boolean tracing;
    private ColorProvider colorProvider = null;
    private DebugServer debugserver = null;
    private ReservedWordProvider reservedWords = null;
    private boolean admin = false;
    private boolean oldAdmin = false;

    static {
        tracing = false;
    }

    public IntertestPlugin() {
        plugin = this;
    }

    public ColorProvider getColorProvider() {
        return this.colorProvider;
    }

    public IWordProvider getReservedWordProvider() {
        return this.reservedWords;
    }

    public void initializeImageRegistry(ImageRegistry registry) {
        super.initializeImageRegistry(registry);
        Bundle bundle = Platform.getBundle((String)"com.ca.intertest");
        Path path = new Path("icons/collapseall.png");
        URL url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("COLLAPSE_ICON", desc);
        path = new Path("icons/expandall.png");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("EXPAND_ICON", desc);
        path = new Path("icons/png/edit_configuration_16.png");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("UPDATE_ICON", desc);
        registry.put("DEBUG_STEP_ICON", desc);
        path = new Path("icons/debug_exc.gif");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("DEBUG_ICON", desc);
        path = new Path("icons/stoplight_enabled.gif");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("STARTSTOP_ICON", desc);
        path = new Path("icons/suspend.gif");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("SUSPEND_ICON", desc);
        path = new Path("icons/start.gif");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("DEBUG_RESUME_ICON", desc);
        path = new Path("icons/stop.gif");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("DEBUG_KILL_ICON", desc);
        path = new Path("icons/png/batch_project_16.png");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("BATCH_ICON", desc);
        path = new Path("icons/png/batch_project_32.png");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("BATCH_ICON_32", desc);
        path = new Path("icons/png/cics_project_16.png");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("CICS_ICON", desc);
        path = new Path("icons/png/cics_project_32.png");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("CICS_ICON_32", desc);
        path = new Path("icons/png/cobol_dec_16.png");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("COB_ICON", desc);
        path = new Path("icons/png/assembler_dec_16.png");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("ASM_ICON", desc);
        path = new Path("icons/png/PL-I_dec_16.png");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("PLI_ICON", desc);
        path = new Path("icons/png/terminal_16.png");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("TERM_ICON", desc);
        path = new Path("icons/png/transaction_16.png");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("TRAN_ICON", desc);
        path = new Path("icons/png/generic_dec_16.png");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("GENERIC_ICON", desc);
        path = new Path("icons/CA_logo 16x16.gif");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("CA_LOGO_ICON", desc);
        path = new Path("icons/refresh.gif");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("REFRESH_ICON", desc);
        path = new Path("icons/memory_view.gif");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("CORE_ICON", desc);
        path = new Path("icons/warning.gif");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("WARNING_ICON", desc);
        path = new Path("icons/png/monitored_16_.png");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("MONITORED_ICON", desc);
        path = new Path("icons/png/unmonitored_16_.png");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("UNMONITORED_ICON", desc);
        path = new Path("icons/png/monitor_off_16.png");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("MONITOR_OFF_ICON", desc);
        path = new Path("icons/png/monitor_on_16.png");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("MONITOR_ON_ICON", desc);
        path = new Path("icons/png/breakpoint.png");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("BANNER_ICON_BREAKPOINT", desc);
        path = new Path("icons/png/channel_48.png");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("BANNER_ICON_CHANNEL", desc);
        path = new Path("icons/png/set_composite_48.png");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("BANNER_ICON_COMPOSITE", desc);
        path = new Path("icons/png/stop_48.png");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("BANNER_ICON_DISCONNECT", desc);
        path = new Path("icons/png/download_list_48.png");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("BANNER_ICON_IMPORT_LIST", desc);
        path = new Path("icons/png/import_list_48.png");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("BANNER_ICON_LOAD_PROTSYM", desc);
        path = new Path("icons/png/core_dialog_48.png");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("BANNER_ICON_MEMORY", desc);
        path = new Path("icons/png/add_48.png");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("BANNER_ICON_NEW_ITEM", desc);
        path = new Path("icons/png/add_batch_project_48.png");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("BANNER_ICON_PROJECT_BATCH", desc);
        path = new Path("icons/png/add_cics_project_48.png");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("BANNER_ICON_PROJECT_CICS", desc);
        path = new Path("icons/png/schedule_jobs_48.png");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("BANNER_ICON_SCHEDULING", desc);
        path = new Path("icons/png/batch_link_queue_48.png");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("BANNER_ICON_SELECT_JOB", desc);
        path = new Path("icons/png/synchronization_48.png");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("BANNER_ICON_SELECT_SYMBOLIC", desc);
        path = new Path("icons/png/add_mframe_server_48.png");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("BANNER_ICON_SERVER", desc);
        path = new Path("icons/png/export_server_48.png");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("BANNER_ICON_SERVER_EXPORT", desc);
        path = new Path("icons/png/import_server_48.png");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("BANNER_ICON_SERVER_IMPORT", desc);
        path = new Path("icons/png/list_storage_48.png");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("BANNER_ICON_STORAGE", desc);
    }

    private void setReservedWords() {
        try {
            this.reservedWords = new ReservedWordProvider();
        }
        catch (ITException e) {
            Logger.loggit(e);
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        IntertestPlugin.getDefaultPreferences();
        IntertestPlugin.getConfigurationPreferences();
        IntertestPlugin.getInstancePreferences();
        this.headers = context.getBundle().getHeaders();
        try {
            location = this.getStateLocation();
        }
        catch (IllegalStateException e) {
            Logger.loggit(e);
        }
        tracing = this.isDebugging() && Boolean.parseBoolean(Platform.getDebugOption((String)"com.ca.intertest/debug/trace"));
        Logger.loggit(0, "com.ca.intertest" + Messages.IntertestPlugin_26);
        String UID = instancePreferences.getString("uid");
        if (UID.length() == 0 || UID.startsWith("-")) {
            instancePreferences.setValue("uid", 1);
        }
        this.colorProvider = new ColorProvider();
        this.setReservedWords();
        Keywords.getInstance();
        if (!Charset.isSupported("IBM1047")) {
            final String msg = String.valueOf(Messages.IntertestPlugin_28) + IConstants.LINEFEED + Messages.IntertestPlugin_29 + IConstants.LINEFEED + Messages.IntertestPlugin_30;
            Logger.loggit(16, msg);
            final Display display = Display.getDefault();
            if (display != null) {
                display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openError((Shell)display.getActiveShell(), (String)"CA InterTest", (String)msg);
                    }
                });
            }
            plugin.getWorkbench().close();
        }
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        boolean foundipv6 = false;
        block7: while (interfaces.hasMoreElements()) {
            NetworkInterface item = interfaces.nextElement();
            Enumeration<InetAddress> addresses = item.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress address = addresses.nextElement();
                if (!(address instanceof Inet6Address)) continue;
                foundipv6 = true;
                break block7;
            }
        }
        String result = System.getProperty("java.net.preferIPv6Addresses");
        boolean ipv6 = result == null ? true : Boolean.parseBoolean(result);
        result = System.getProperty("java.net.preferIPv4Addresses");
        boolean ipv4 = result == null ? !foundipv6 : Boolean.parseBoolean(result);
        ipv6 = !ipv4;
        System.setProperty("java.net.preferIPv6Addresses", Boolean.toString(ipv6));
        System.setProperty("java.net.preferIPv4Addresses", Boolean.toString(ipv4));
        boolean first = true;
        int port = configurationPreferences.getInt("LISTENER_PORT");
        while (this.debugserver == null) {
            try {
                this.debugserver = new DebugServer(port);
            }
            catch (IOException iOException) {
                Display display;
                String msg;
                if (first) {
                    msg = String.valueOf(Messages.IntertestPlugin_35) + port + IConstants.LINEFEED + Messages.IntertestPlugin_36 + IConstants.LINEFEED + Messages.IntertestPlugin_37 + IConstants.LINEFEED + Messages.IntertestPlugin_38;
                    display = Display.getDefault();
                    if (display == null) continue;
                    display.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            boolean yes = MessageDialog.openQuestion((Shell)display.getActiveShell(), (String)"CA InterTest", (String)msg);
                            if (!yes) {
                                Logger.loggit(16, msg);
                                plugin.getWorkbench().close();
                            }
                        }
                    });
                    port = 0;
                    first = false;
                    continue;
                }
                msg = String.valueOf(Messages.IntertestPlugin_39) + port + IConstants.LINEFEED + Messages.IntertestPlugin_40 + IConstants.LINEFEED + Messages.IntertestPlugin_41;
                Logger.loggit(16, msg);
                display = Display.getDefault();
                if (display == null) continue;
                display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openError((Shell)display.getActiveShell(), (String)"CA InterTest", (String)msg);
                        plugin.getWorkbench().close();
                    }
                });
            }
        }
        String format = Messages.IntertestPlugin_42;
        Logger.loggit(0, String.format(format, this.debugserver.getPort(), ipv6 ? "IPv6" : "IPv4"));
        String[] stringArray = new String[]{"com.ca.intertest.admin", "com.ca.intertest.batch", "com.ca.intertest.cics"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            try {
                this.bundles.add(this.startBundle(item));
            }
            catch (ITException iTException) {
            }
            catch (BundleException e) {
                Logger.loggit(e);
            }
            ++n2;
        }
        this.debugserver.start();
        if (port == 0) {
            port = this.debugserver.getPort();
            configurationPreferences.setValue("LISTENER_PORT", this.debugserver.getPort());
            configurationPreferences.save();
        }
        defaultPreferences.setDefault("LISTENER_PORT", port);
        defaultPreferences.save();
        String cheatsheet = instancePreferences.getString("initial_cheatsheet");
        if (!CHEATSHEET.equals(cheatsheet)) {
            Display display = Display.getDefault();
            if (display != null) {
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        OpenCheatSheetAction action = new OpenCheatSheetAction(IntertestPlugin.CHEATSHEET);
                        action.run();
                    }
                });
            }
            instancePreferences.setValue("initial_cheatsheet", CHEATSHEET);
        }
    }

    private Bundle startBundle(String pluginId) throws ITException, BundleException {
        Bundle bundle = Platform.getBundle((String)pluginId);
        if (bundle == null) {
            throw new ITException(String.format(Messages.IntertestPlugin_45, pluginId));
        }
        int originalState = bundle.getState();
        if ((originalState & 0x20) == 0) {
            try {
                bundle.start(1);
                if (pluginId.equals("com.ca.intertest.admin")) {
                    this.admin = true;
                    Location install = Platform.getInstallLocation();
                    String path = install.getURL().getPath();
                    File testfile = new File(path, "com.ca.intertest.oldadmin.ini");
                    boolean useOld = Boolean.getBoolean("com.ca.intertest.oldadmin");
                    this.oldAdmin = testfile.exists() || useOld;
                }
            }
            catch (BundleException e) {
                if ((originalState & 8) != 0 && (bundle.getState() & 8) != 0) {
                    return bundle;
                }
                throw e;
            }
        }
        return bundle;
    }

    public void stop(BundleContext context) throws Exception {
        Debug.dispose();
        ServerList.save();
        Logger.loggit(0, "com.ca.intertest" + Messages.IntertestPlugin_46);
        for (Bundle bundle : this.bundles) {
            if (bundle == null) continue;
            bundle.stop(1);
        }
        super.stop(context);
    }

    public int getServerPort() {
        return this.debugserver.getPort();
    }

    public Dictionary<?, ?> getBundleHeaders() {
        return this.headers;
    }

    public static synchronized int generateUID() {
        int UID = instancePreferences.getInt("uid");
        instancePreferences.setValue("uid", UID + 1);
        return UID;
    }

    public static IPreferenceStore getDefaultPreferences() {
        if (defaultPreferences == null) {
            defaultPreferences = new ScopedPreferenceStore((IScopeContext)new DefaultScope(), "com.ca.intertest");
        }
        return defaultPreferences;
    }

    public static IPreferenceStore getConfigurationPreferences() {
        if (configurationPreferences == null) {
            configurationPreferences = new ScopedPreferenceStore((IScopeContext)new ConfigurationScope(), "com.ca.intertest");
        }
        return configurationPreferences;
    }

    public static IntertestPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.ca.intertest", (String)path);
    }

    public static IPreferenceStore getInstancePreferences() {
        if (instancePreferences == null) {
            instancePreferences = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), "com.ca.intertest");
        }
        return instancePreferences;
    }

    public static IPath getLocation() {
        return location;
    }

    public static boolean isTracing() {
        return tracing;
    }

    public static void setTracing(boolean tracing) {
        IntertestPlugin.tracing = tracing;
    }

    public static synchronized void startErrorLog() {
        if (errorviewloaded) {
            return;
        }
        Display display = Display.getDefault();
        try {
            final IWorkbench workbench = PlatformUI.getWorkbench();
            if (display != null) {
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                        IWorkbenchPage page = window.getActivePage();
                        window.getShell().forceActive();
                        window.getShell().forceFocus();
                        try {
                            page.showView("org.eclipse.pde.runtime.LogView");
                            errorviewloaded = true;
                        }
                        catch (PartInitException partInitException) {}
                    }
                });
            }
        }
        catch (IllegalStateException illegalStateException) {}
    }

    public UUID getPluginUUID() {
        return this.PluginUUID;
    }

    public boolean isAdmin() {
        return this.admin;
    }

    public boolean isOldAdmin() {
        return this.oldAdmin;
    }
}

