/*
 * Decompiled with CFR 0.152.
 */
package com.ca.testingtools.core;

import com.ca.testingtools.common.HexUtil;
import com.ca.testingtools.core.TTServer;
import com.ca.testingtools.core.TT_TreeItem;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class ServerStatusJob
extends Job {
    static String cacopyright = "Copyright (c) 2016 CA";
    protected final TTServer server;
    protected TT_TreeItem serverItem;
    private static final String REFRESHING = "Refreshing Status %1$s:";

    public ServerStatusJob(TT_TreeItem item) {
        super(String.format(REFRESHING, item.getText()));
        this.serverItem = item.getParent(TTServer.class);
        this.server = (TTServer)this.serverItem.getValue();
    }

    public ServerStatusJob(TTServer server) {
        super(String.format(REFRESHING, server.getText()));
        this.server = server;
    }

    protected IStatus run(IProgressMonitor monitor) {
        if (this.server.getPort() < 1) {
            this.server.setStatusText(12, "Invalid port");
        } else {
            try {
                InetSocketAddress socketaddress = new InetSocketAddress(this.server.getHostname(), this.server.getPort());
                Socket socket = new Socket();
                socket.connect(socketaddress);
                socket.close();
                if (!this.server.isActive()) {
                    this.server.setStatusText(3, "Active");
                } else {
                    this.server.notifyStatusObservers();
                }
            }
            catch (UnknownHostException unknownHostException) {
                this.server.setStatusText(12, "Unknown host");
            }
            catch (IOException e) {
                String text = HexUtil.getErrorText((Throwable)e);
                int ix = text.lastIndexOf(58);
                this.server.setStatusText(12, text.substring(0, ix > 0 ? ix : text.length()));
            }
        }
        return Status.OK_STATUS;
    }

    public boolean belongsTo(Object family) {
        if (family != null && family.toString().equals("com.ca.testingtools")) {
            return true;
        }
        return super.belongsTo(family);
    }
}

