/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.editor.virtualtableviews;

import com.ca.filemaster.common.FileMasterRecord;
import com.ca.filemaster.common.FileMasterRecordField;
import com.ca.filemaster.editor.virtualtableviews.TraverseListenerBase;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.TraverseEvent;

public class TraverseListenerTable
extends TraverseListenerBase {
    protected TableViewer tableViewer;
    private Logger log = Logger.getLogger(TraverseListenerTable.class.getName());

    public TraverseListenerTable(TextCellEditor textCellEditor, TableViewer tableViewer, FileMasterRecord fileMasterRecord, FileMasterRecordField fileMasterRecordField) {
        super(textCellEditor, fileMasterRecord, fileMasterRecordField);
        this.tableViewer = tableViewer;
    }

    @Override
    protected void moveToNext(TraverseEvent traverseEvent) {
        int selectedElement;
        int nextPosition = selectedElement = this.tableViewer.getTable().getSelectionIndex();
        Object data = this.tableViewer.getTable().getItem(selectedElement).getData();
        if (data instanceof FileMasterRecord) {
            FileMasterRecord fileMasterRecord = (FileMasterRecord)data;
            if (!fileMasterRecord.isLastRecord()) {
                ++nextPosition;
            }
        } else {
            ++nextPosition;
        }
        this.log.log(Level.INFO, "next record: " + nextPosition);
        this.textCellEditor.deactivate();
        if (!this.tableViewer.getTable().isDisposed()) {
            this.tableViewer.getTable().setSelection(nextPosition);
        }
    }

    @Override
    protected void moveToPrevious(TraverseEvent traverseEvent) {
        int selectedElement = this.tableViewer.getTable().getSelectionIndex();
        int previousPosition = selectedElement - 1;
        this.log.log(Level.INFO, "previous record: " + previousPosition);
        this.textCellEditor.deactivate();
        this.tableViewer.getTable().setSelection(previousPosition);
    }
}

