/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.editor.virtualtableviews;

import com.ca.filemaster.common.FileMasterRecord;
import com.ca.filemaster.common.FileMasterRecordField;
import java.util.logging.Logger;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class MultiRecordLineNumberEditingSupport
extends EditingSupport {
    private Logger log = Logger.getLogger(MultiRecordLineNumberEditingSupport.class.getName());
    private TableViewer viewer;
    private ColumnViewer columnViewer;
    private int count;

    public MultiRecordLineNumberEditingSupport(TableViewer tableViewer, ColumnViewer columnViewer, int count) {
        super(columnViewer);
        this.viewer = tableViewer;
        this.columnViewer = columnViewer;
        this.count = count;
    }

    protected void setValue(Object element, Object newName) {
        if (element instanceof FileMasterRecord) {
            FileMasterRecord m = (FileMasterRecord)element;
            if (newName != null && !newName.toString().isEmpty() && newName.toString().startsWith(".", 0)) {
                if (newName.toString().length() > 7) {
                    newName = newName.toString().subSequence(0, 6);
                }
                m.setLabelForRecord((String)newName);
            }
            this.viewer.refresh();
        }
    }

    protected Object getValue(Object element) {
        if (element instanceof FileMasterRecord) {
            FileMasterRecord m = (FileMasterRecord)element;
            return Integer.toString(m.getNumber());
        }
        return element;
    }

    protected CellEditor getCellEditor(Object element) {
        FileMasterRecord m;
        int limit = 6;
        final TextCellEditor textEditor = new TextCellEditor((Composite)this.viewer.getTable());
        if (element instanceof FileMasterRecord && (m = (FileMasterRecord)element).getRecordFields().size() > this.count && (limit = ((FileMasterRecordField)m.getRecordFields().get(this.count)).getMaxLengthP()) == 0) {
            limit = 6;
        }
        ((Text)textEditor.getControl()).setTextLimit(limit);
        textEditor.getControl().addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 16) {
                    textEditor.getControl().traverse(8);
                    int selectedElement = MultiRecordLineNumberEditingSupport.this.viewer.getTable().getSelectionIndex();
                    if (selectedElement + 1 < MultiRecordLineNumberEditingSupport.this.viewer.getTable().getItemCount()) {
                        MultiRecordLineNumberEditingSupport.this.viewer.getTable().setSelection(selectedElement + 1);
                        e.doit = false;
                        return;
                    }
                    MultiRecordLineNumberEditingSupport.this.viewer.getTable().setSelection(-1);
                } else if (e.detail == 8) {
                    textEditor.getControl().traverse(4);
                }
            }
        });
        return textEditor;
    }

    protected boolean canEdit(Object element) {
        return false;
    }
}

