/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.editor.virtualtableviews;

import com.ca.filemaster.common.FMPRange;
import com.ca.filemaster.common.FileMasterRecord;
import com.ca.filemaster.common.FileMasterRecordField;
import com.ca.filemaster.editor.virtualtableviews.EditingSupportFileMaster;
import com.ca.filemaster.editor.virtualtableviews.MultiRecordFormatMode;
import com.ca.filemaster.runners.RunSetODOChange;
import com.ca.testingtools.common.XMLRequest;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Element;

public class MultiRecordDataCharEditingSupport
extends EditingSupportFileMaster {
    private Logger log = Logger.getLogger(MultiRecordDataCharEditingSupport.class.getName());

    public MultiRecordDataCharEditingSupport(MultiRecordFormatMode multiRecordFormatMode, TableViewer tableViewer, int columnIndex, int columnIndexOnTable, boolean isSubString, int subStringBeginIndex, int subStringEndIndex) {
        super(tableViewer, multiRecordFormatMode, columnIndex, columnIndexOnTable, isSubString, subStringBeginIndex, subStringEndIndex);
    }

    @Override
    public void updateView(XMLRequest xmlResponse) {
        Element root;
        if (xmlResponse != null && (root = xmlResponse.getRoot()).getTagName().equalsIgnoreCase("MFRequest")) {
            XMLRequest updatedXMLResponse = this.getFormatMode().getEditorView().ParsingMFRequest(xmlResponse);
            if (updatedXMLResponse != null) {
                if (this.getFormatMode().getEditorView().isContinueToEdit()) {
                    xmlResponse = updatedXMLResponse;
                } else {
                    IViewPart view;
                    this.getFormatMode().getEditorView().setEditEnd("Y");
                    IViewReference viewRef = this.getFormatMode().getWorkbenchPage().findViewReference("com.ca.filemaster.editor.virtualtableviews.EditorView", this.getFormatMode().getSecondaryId());
                    if (viewRef != null && (view = viewRef.getView(false)) != null) {
                        this.getFormatMode().getWorkbenchPage().hideView(view);
                    }
                }
            } else {
                Element firstChild = (Element)root.getFirstChild();
                if (firstChild.getTagName().equalsIgnoreCase("EditODOChange")) {
                    int newODOValue = this.getNewODOValue(firstChild);
                    int newRecordLength = this.getNewRecordLength(firstChild);
                    int maxODOValue = this.getMaxODOValue(firstChild);
                    int maxRecordLength = this.getMaxRecordLength(firstChild);
                    if (newODOValue > maxODOValue) {
                        MessageDialog.openError((Shell)this.getTableViewer().getControl().getShell(), (String)"Edit Length Modification", (String)("The new value in an occurs depending on field is out of range.\n\nNew ODO value: " + newODOValue + "\n\nMaximum ODO value: " + maxODOValue));
                        RunSetODOChange runner = new RunSetODOChange(this.getFormatMode().getFileMasterServer(), this.getFormatMode().getUUID(), false);
                        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), (Runnable)runner);
                        xmlResponse = runner.getXml();
                    } else if (newRecordLength > maxRecordLength) {
                        MessageDialog.openError((Shell)this.getTableViewer().getControl().getShell(), (String)"Edit Length Modification", (String)("The recalculated record length exceeds the maximum due to a change in an occurs\ndepending on field.\n\nRequired record length: " + newRecordLength + "\n\nMaximum record length: " + maxRecordLength));
                        RunSetODOChange runner = new RunSetODOChange(this.getFormatMode().getFileMasterServer(), this.getFormatMode().getUUID(), false);
                        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), (Runnable)runner);
                        xmlResponse = runner.getXml();
                    } else {
                        boolean ODOChangeConfirm = MessageDialog.openConfirm((Shell)this.getTableViewer().getControl().getShell(), (String)"Edit Length Modification", (String)("The length of the record changes due to a change in an occurs depending on field.\n\nNew record length: " + newRecordLength + "\n\nNew ODO value: " + newODOValue));
                        RunSetODOChange runner = new RunSetODOChange(this.getFormatMode().getFileMasterServer(), this.getFormatMode().getUUID(), ODOChangeConfirm);
                        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), (Runnable)runner);
                        xmlResponse = runner.getXml();
                    }
                }
            }
        }
        this.getFormatMode().getEditorView().updateMRFEditViewer(xmlResponse);
        this.getFormatMode().getEditorView().setDirty(true);
        this.getFormatMode().disableGetChunkInvocationBecauseWeHaveAlreadyLoadedTheTable = true;
    }

    @Override
    protected boolean canEdit(Object element) {
        if (!(element instanceof FileMasterRecord) || element == null) {
            return true;
        }
        if (((FileMasterRecord)element).isExcluded()) {
            return false;
        }
        FileMasterRecord fileMasterRecord = (FileMasterRecord)element;
        int indexOfRecordField = this.columnIndex - 1;
        int sizeOfRecordFields = fileMasterRecord.getRecordFields().size();
        if (indexOfRecordField < 0 || indexOfRecordField > sizeOfRecordFields) {
            this.log.log(Level.INFO, "indexOfRecordField: " + indexOfRecordField + " size of record fields: " + sizeOfRecordFields);
            return true;
        }
        if (indexOfRecordField > sizeOfRecordFields - 1) {
            return false;
        }
        FileMasterRecordField fileMasterRecordField = (FileMasterRecordField)fileMasterRecord.getRecordFields().get(indexOfRecordField);
        if (fileMasterRecordField == null) {
            return true;
        }
        if (fileMasterRecordField.getCharData() == null) {
            return false;
        }
        int lenghtOfFileMasterRecordField = fileMasterRecordField.getMaxLengthP();
        ArrayList fmpRanges = fileMasterRecordField.getProtectedList();
        if (fmpRanges == null || fmpRanges.size() == 0) {
            return true;
        }
        for (FMPRange fmpRange : fmpRanges) {
            int start = Integer.parseInt(fmpRange.getStart());
            int end = Integer.parseInt(fmpRange.getEnd());
            int numberOfCharactersProtected = end - start + 1;
            if (numberOfCharactersProtected != lenghtOfFileMasterRecordField) continue;
            return false;
        }
        return true;
    }

    private int getNewODOValue(Element odo) {
        if (odo.hasAttribute("newValue")) {
            String newValue = odo.getAttribute("newValue");
            if (newValue.isEmpty()) {
                return -1;
            }
            return Integer.parseInt(newValue);
        }
        return -1;
    }

    private int getMaxODOValue(Element odo) {
        if (odo.hasAttribute("maxValue")) {
            String maxValue = odo.getAttribute("maxValue");
            if (maxValue.isEmpty()) {
                return -1;
            }
            return Integer.parseInt(maxValue);
        }
        return -1;
    }

    private int getNewRecordLength(Element odo) {
        if (odo.hasAttribute("newRecLen")) {
            String newRecLen = odo.getAttribute("newRecLen");
            if (newRecLen.isEmpty()) {
                return -1;
            }
            return Integer.parseInt(newRecLen);
        }
        return -1;
    }

    private int getMaxRecordLength(Element odo) {
        if (odo.hasAttribute("maxRecLen")) {
            String maxRecLen = odo.getAttribute("maxRecLen");
            if (maxRecLen.isEmpty()) {
                return -1;
            }
            return Integer.parseInt(maxRecLen);
        }
        return -1;
    }
}

