/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.editor.pricommands.wizards;

import com.ca.filemaster.common.CommonMFCalls;
import com.ca.filemaster.common.FMHistory;
import com.ca.filemaster.common.FileMasterDataset;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.common.Validator;
import com.ca.filemaster.editor.virtualtableviews.EditorView;
import com.ca.filemaster.runners.RunGetLocateRecords;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.ui.verifyDigit;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LocateCommandWizardPage
extends WizardPage
implements SelectionListener {
    protected static final String LINE_NUMBER_ERROR_MESSAGE = "Please insert a line number";
    protected static final String LINE_NUMBER_VALUE_TOO_HIGH = "Line number value is too high";
    protected static final String LABEL_ERROR_MESSAGE = "Please insert a label";
    protected static final String KEY_VALUE_ERROR_MESSAGE = "Please insert a key value";
    protected static final String KEYWORD_ERROR_MESSAGE = "Please choose a keyword";
    public static final String CONTEXT_HELP_ID = "com.ca.filemaster.help.locate";
    private Combo lineNumberCombo;
    private Combo keyValueCombo;
    protected FileMasterServer server;
    private FileMasterDataset dataset;
    protected String uuid;
    protected String displayMode;
    protected String hexMode;
    private String errorMessage;
    private String keyworkType;
    private String optionsType;
    private Combo text;
    private Button lineNumberRadioButton;
    private Button keyValueRadioButton;
    private Button keywordRadioButton;
    private Composite keywordsGroup;
    private Composite composite;
    private Group optionsGroup;
    private String locateType;
    protected static String[] types = new String[]{"Character", "Hexadecimal"};
    private Combo cmbLocateType;
    private Button errorCheckButton;
    private Button changeCheckButton;
    private Button commandCheckButton;
    private Button nextRadioButton;
    private Button previousRadioButton;
    private Button firstRadioButton;
    private Button lastRadioButton;

    public LocateCommandWizardPage(String pageName, FileMasterServer server, FileMasterDataset dataset, String uuid, String displayMode, String hexMode) {
        super(pageName);
        this.setTitle("Locate");
        this.server = server;
        this.dataset = dataset;
        this.uuid = uuid;
        this.displayMode = displayMode;
        this.hexMode = hexMode;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, CONTEXT_HELP_ID);
        this.composite = new Composite(container, 0);
        this.composite.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.composite.setLayout((Layout)new GridLayout(3, false));
        this.lineNumberRadioButton = new Button(this.composite, 16);
        this.lineNumberRadioButton.setText("&Line number:");
        this.lineNumberRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LocateCommandWizardPage.this.lineNumberCombo.setEnabled(true);
                LocateCommandWizardPage.this.lineNumberCombo.setFocus();
                LocateCommandWizardPage.this.keyValueCombo.setEnabled(false);
                LocateCommandWizardPage.this.text = LocateCommandWizardPage.this.lineNumberCombo;
                LocateCommandWizardPage.this.locateType = "LineNumber";
                if (LocateCommandWizardPage.this.lineNumberCombo.getText().isEmpty()) {
                    LocateCommandWizardPage.this.errorMessage = LocateCommandWizardPage.LINE_NUMBER_ERROR_MESSAGE;
                } else {
                    LocateCommandWizardPage.this.errorMessage = "";
                }
                LocateCommandWizardPage.this.setPageComplete(LocateCommandWizardPage.this.isPageComplete());
            }
        });
        this.lineNumberCombo = new Combo(this.composite, 2048);
        this.lineNumberCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.lineNumberCombo.addVerifyListener((VerifyListener)new verifyDigit(true));
        this.lineNumberCombo.setTextLimit(10);
        this.lineNumberCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Long maxLineNumberValue = new Long(Integer.MAX_VALUE);
                if (LocateCommandWizardPage.this.lineNumberCombo.getText().isEmpty()) {
                    LocateCommandWizardPage.this.errorMessage = LocateCommandWizardPage.LINE_NUMBER_ERROR_MESSAGE;
                } else if (maxLineNumberValue.compareTo(new Long(LocateCommandWizardPage.this.lineNumberCombo.getText())) < 0) {
                    LocateCommandWizardPage.this.errorMessage = LocateCommandWizardPage.LINE_NUMBER_VALUE_TOO_HIGH;
                } else {
                    LocateCommandWizardPage.this.errorMessage = "";
                }
                LocateCommandWizardPage.this.setPageComplete(LocateCommandWizardPage.this.isPageComplete());
            }
        });
        FMHistory.intializeComboBoxes((Combo)this.lineNumberCombo, (String)"lineNumberComboLocateCommandWizardPage");
        new Label(this.composite, 0);
        this.keyValueRadioButton = new Button(this.composite, 16);
        this.keyValueRadioButton.setText("Key &value:");
        if (!this.dataset.getDsOrg().equalsIgnoreCase("VSAM")) {
            this.keyValueRadioButton.setEnabled(false);
        }
        this.keyValueRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LocateCommandWizardPage.this.keyValueCombo.setEnabled(true);
                LocateCommandWizardPage.this.keyValueCombo.setFocus();
                LocateCommandWizardPage.this.lineNumberCombo.setEnabled(false);
                LocateCommandWizardPage.this.text = LocateCommandWizardPage.this.keyValueCombo;
                LocateCommandWizardPage.this.locateType = "KeyValue";
                if (LocateCommandWizardPage.this.keyValueCombo.getText().isEmpty()) {
                    LocateCommandWizardPage.this.errorMessage = LocateCommandWizardPage.KEY_VALUE_ERROR_MESSAGE;
                } else {
                    LocateCommandWizardPage.this.errorMessage = "";
                }
                LocateCommandWizardPage.this.setPageComplete(LocateCommandWizardPage.this.isPageComplete());
            }
        });
        this.keyValueCombo = new Combo(this.composite, 2048);
        this.keyValueCombo.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.keyValueCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (LocateCommandWizardPage.this.keyValueCombo.getText().isEmpty()) {
                    LocateCommandWizardPage.this.errorMessage = LocateCommandWizardPage.KEY_VALUE_ERROR_MESSAGE;
                } else {
                    LocateCommandWizardPage.this.errorMessage = "";
                }
                LocateCommandWizardPage.this.setPageComplete(LocateCommandWizardPage.this.isPageComplete());
            }
        });
        FMHistory.intializeComboBoxes((Combo)this.keyValueCombo, (String)"keyValueComboLocateCommandWizardPage");
        this.cmbLocateType = new Combo(this.composite, 8);
        this.cmbLocateType.setItems(types);
        this.cmbLocateType.setText(types[0]);
        this.cmbLocateType.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                LocateCommandWizardPage.this.isPageComplete();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.keywordRadioButton = new Button(this.composite, 16);
        this.keywordRadioButton.setText("&Keyword:");
        this.keywordRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (LocateCommandWizardPage.this.keywordRadioButton.getSelection()) {
                    LocateCommandWizardPage.this.errorMessage = LocateCommandWizardPage.KEYWORD_ERROR_MESSAGE;
                    LocateCommandWizardPage.this.lineNumberCombo.setEnabled(false);
                    LocateCommandWizardPage.this.keyValueCombo.setEnabled(false);
                    boolean keywordSelected = false;
                    int x = 0;
                    while (x < LocateCommandWizardPage.this.keywordsGroup.getChildren().length) {
                        LocateCommandWizardPage.this.keywordsGroup.getChildren()[x].setEnabled(true);
                        if (LocateCommandWizardPage.this.keywordsGroup.getChildren()[x] instanceof Button && !keywordSelected && ((Button)LocateCommandWizardPage.this.keywordsGroup.getChildren()[x]).getSelection()) {
                            LocateCommandWizardPage.this.setErrorMessage(null);
                            keywordSelected = true;
                        }
                        ++x;
                    }
                    x = 0;
                    while (x < LocateCommandWizardPage.this.optionsGroup.getChildren().length) {
                        LocateCommandWizardPage.this.optionsGroup.getChildren()[x].setEnabled(true);
                        ++x;
                    }
                    LocateCommandWizardPage.this.locateType = "Keyword";
                } else {
                    int x = 0;
                    while (x < LocateCommandWizardPage.this.keywordsGroup.getChildren().length) {
                        LocateCommandWizardPage.this.keywordsGroup.getChildren()[x].setEnabled(false);
                        ++x;
                    }
                    x = 0;
                    while (x < LocateCommandWizardPage.this.optionsGroup.getChildren().length) {
                        LocateCommandWizardPage.this.optionsGroup.getChildren()[x].setEnabled(false);
                        ++x;
                    }
                }
                LocateCommandWizardPage.this.setPageComplete(LocateCommandWizardPage.this.isPageComplete());
            }
        });
        this.keywordsGroup = new Composite(this.composite, 0);
        GridLayout keywordsGroupLayout = new GridLayout(4, true);
        this.keywordsGroup.setLayout((Layout)keywordsGroupLayout);
        this.keywordsGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.changeCheckButton = new Button(this.keywordsGroup, 32);
        this.changeCheckButton.setText("&Change");
        this.changeCheckButton.addSelectionListener((SelectionListener)this);
        this.commandCheckButton = new Button(this.keywordsGroup, 32);
        this.commandCheckButton.setText("C&ommand");
        this.commandCheckButton.addSelectionListener((SelectionListener)this);
        this.errorCheckButton = new Button(this.keywordsGroup, 32);
        this.errorCheckButton.setText("&Error");
        this.errorCheckButton.addSelectionListener((SelectionListener)this);
        new Label(this.composite, 0);
        new Label(this.composite, 0);
        this.optionsGroup = new Group(this.composite, 0);
        this.optionsGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.optionsGroup.setText("Options");
        GridLayout optionsGroupLayout = new GridLayout(4, true);
        this.optionsGroup.setLayout((Layout)optionsGroupLayout);
        this.nextRadioButton = new Button((Composite)this.optionsGroup, 16);
        this.nextRadioButton.setText("&Next");
        this.nextRadioButton.setSelection(true);
        this.nextRadioButton.addSelectionListener((SelectionListener)this);
        this.optionsType = "NEXT";
        this.previousRadioButton = new Button((Composite)this.optionsGroup, 16);
        GridData gd_previousRadioButton = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_previousRadioButton.widthHint = 78;
        this.previousRadioButton.setLayoutData((Object)gd_previousRadioButton);
        this.previousRadioButton.setText("&Previous");
        this.previousRadioButton.addSelectionListener((SelectionListener)this);
        this.firstRadioButton = new Button((Composite)this.optionsGroup, 16);
        this.firstRadioButton.setText("&First");
        this.firstRadioButton.addSelectionListener((SelectionListener)this);
        this.lastRadioButton = new Button((Composite)this.optionsGroup, 16);
        GridData gd_lastRadioButton = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lastRadioButton.widthHint = 78;
        this.previousRadioButton.setLayoutData((Object)gd_lastRadioButton);
        this.lastRadioButton.setText("Las&t");
        this.lastRadioButton.addSelectionListener((SelectionListener)this);
        int x = 0;
        while (x < this.keywordsGroup.getChildren().length) {
            this.keywordsGroup.getChildren()[x].setEnabled(false);
            ++x;
        }
        x = 0;
        while (x < this.optionsGroup.getChildren().length) {
            this.optionsGroup.getChildren()[x].setEnabled(false);
            ++x;
        }
        this.getShell().getDefaultButton().setText("OK");
        this.setControl((Control)container);
    }

    public void widgetSelected(SelectionEvent e) {
        Widget source = e.widget;
        if (source instanceof Button) {
            if (((Button)source).getText().equals(this.changeCheckButton.getText())) {
                this.keyworkType = "CHANGE";
            } else if (((Button)source).getText().equals(this.commandCheckButton.getText())) {
                this.keyworkType = "COMMAND";
            } else if (((Button)source).getText().equals(this.errorCheckButton.getText())) {
                this.keyworkType = "ERROR";
            } else if (((Button)source).getText().equals(this.nextRadioButton.getText())) {
                this.optionsType = "NEXT";
            } else if (((Button)source).getText().equals(this.previousRadioButton.getText())) {
                this.optionsType = "PREV";
            } else if (((Button)source).getText().equals(this.firstRadioButton.getText())) {
                this.optionsType = "FIRST";
            } else if (((Button)source).getText().equals(this.lastRadioButton.getText())) {
                this.optionsType = "LAST";
            }
        }
        this.setPageComplete(this.isPageComplete());
    }

    public boolean isPageComplete() {
        if (this.keyValueRadioButton != null && this.keyValueRadioButton.getSelection() && this.keyValueCombo != null && !this.keyValueCombo.getText().isEmpty() && this.cmbLocateType != null && this.cmbLocateType.getSelectionIndex() == 1) {
            this.errorMessage = Validator.errorMsg[Validator.HexadecimalLength((String)this.keyValueCombo.getText(), (boolean)false)];
        }
        if (this.keywordRadioButton == null) {
            return false;
        }
        if (this.keywordRadioButton.getSelection()) {
            boolean keywordSelected = false;
            int x = 0;
            while (x < this.keywordsGroup.getChildren().length) {
                this.keywordsGroup.getChildren()[x].setEnabled(true);
                if (this.keywordsGroup.getChildren()[x] instanceof Button) {
                    if (!keywordSelected && ((Button)this.keywordsGroup.getChildren()[x]).getSelection()) {
                        this.errorMessage = "";
                        keywordSelected = true;
                    } else if (!keywordSelected) {
                        this.errorMessage = KEYWORD_ERROR_MESSAGE;
                    }
                }
                ++x;
            }
        }
        if (this.errorMessage == null || this.errorMessage.isEmpty()) {
            this.setErrorMessage(null);
            return true;
        }
        this.setErrorMessage(this.errorMessage);
        return false;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public boolean doFinish() {
        RunGetLocateRecords getRecordsRunner;
        FMHistory.insertHistory((Combo)this.lineNumberCombo, (String)"lineNumberComboLocateCommandWizardPage");
        FMHistory.insertHistory((Combo)this.keyValueCombo, (String)"keyValueComboLocateCommandWizardPage");
        if (this.locateType.equalsIgnoreCase("Keyword")) {
            getRecordsRunner = new RunGetLocateRecords(this.server, this.uuid, this.locateType, "", this.keyworkType, this.optionsType, this.displayMode, this.hexMode);
        } else {
            String locateParm = this.text.getText();
            if (this.locateType.equalsIgnoreCase("LineNumber") && Long.parseLong(locateParm) == 0L) {
                locateParm = "1";
            }
            switch (this.cmbLocateType.getSelectionIndex()) {
                case 0: {
                    break;
                }
                case 1: {
                    locateParm = "X'" + locateParm + "'";
                }
            }
            getRecordsRunner = new RunGetLocateRecords(this.server, this.uuid, this.locateType, locateParm, "", "", this.displayMode, this.hexMode);
        }
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), (Runnable)getRecordsRunner);
        XMLRequest xmlResponse = getRecordsRunner.getXml();
        Element reqElement = xmlResponse.getRoot();
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window.getActivePage().getActivePart() instanceof EditorView) {
            EditorView view = (EditorView)window.getActivePage().getActivePart();
            IWorkbenchPage page = window.getActivePage();
            IWorkbenchPart workbenchPart = page.getActivePart();
            IWorkbenchPartSite workbenchPartSite = workbenchPart.getSite();
            String secondaryId = ((IViewSite)workbenchPartSite).getSecondaryId();
            NodeList messages = reqElement.getElementsByTagName("Message");
            view.handleMissingSession(reqElement, page, secondaryId);
            if (xmlResponse != null && xmlResponse.getRoot().getNodeName().equals("GUIResponse")) {
                if (this.displayMode.equalsIgnoreCase("C")) {
                    view.getCharMode().setLocate(true);
                    view.getCharMode().setCallMF(false);
                    if (messages.getLength() > 0) {
                        int i = 0;
                        while (i < messages.getLength()) {
                            Node msgNode = messages.item(i);
                            Element msgElement = (Element)msgNode;
                            CommonMFCalls.MESSAGE = CommonMFCalls.getTagValue((String)"Message", (Element)msgElement);
                            ++i;
                        }
                        MessageDialog.openInformation(null, (String)"Locate Error", (String)CommonMFCalls.MESSAGE);
                    }
                    view.updateCharEditViewer(xmlResponse);
                }
                if (this.displayMode.equalsIgnoreCase("M")) {
                    view.getMultiRecordFormatMode().setLocate(true);
                    view.updateMRFEditViewer(xmlResponse);
                }
                if (this.displayMode.equalsIgnoreCase("S")) {
                    view.updateSRFEditViewer(xmlResponse);
                }
            }
        }
        return true;
    }
}

