/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.editor.pricommands.wizards;

import com.ca.filemaster.common.Validator;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class EditChangeConfirmationDialog
extends TitleAreaDialog
implements ModifyListener,
SelectionListener {
    static String cacopyright = "Copyright \u00a9 2007 CA";
    public static final String CONTEXT_HELP_ID = "com.ca.filemaster.help.changeInfo";
    private IPreferenceStore store = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), "com.ca.filemaster");
    protected Composite container;
    private Composite parentComposite;
    private Combo txtpadCharactor;
    private Label lblWarnning;
    private Label padCharactor;
    private Label lblvalue;
    private Combo txtpadCharactorValue;
    private String warning = "";
    private String padCharacter = "";
    public static String pad;
    private String Padtype = "Space";
    private String value;
    private Button YesButton;
    private Button NoButton;
    private String[] types = new String[]{"Space", "Null", "Character", "Hexadecimal"};
    public static boolean chgConfirmDialogVisited;

    static {
        chgConfirmDialogVisited = false;
    }

    public EditChangeConfirmationDialog(Shell shell, String items) {
        super(shell);
        this.warning = items;
        this.setShellStyle(65650);
    }

    public void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Warning");
    }

    public Control createDialogArea(Composite parent) {
        this.container = new Composite(parent, 0);
        this.container.setLayout((Layout)new GridLayout(1, false));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, CONTEXT_HELP_ID);
        this.parentComposite = new Composite(this.container, 0);
        GridLayout gl_parentComposite = new GridLayout(1, false);
        gl_parentComposite.marginWidth = 0;
        this.parentComposite.setLayout((Layout)gl_parentComposite);
        this.parentComposite.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.lblWarnning = new Label(this.parentComposite, 64);
        this.lblWarnning.setText(this.warning);
        this.setTitle("Change Confirmation");
        Group padCharactorGrp = new Group(this.container, 0);
        padCharactorGrp.setLayout((Layout)new GridLayout(4, false));
        padCharactorGrp.setSize(padCharactorGrp.computeSize(-1, -1));
        padCharactorGrp.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.padCharactor = new Label((Composite)padCharactorGrp, 0);
        this.padCharactor.setText("Pad Character:");
        this.txtpadCharactor = new Combo((Composite)padCharactorGrp, 8);
        this.txtpadCharactor.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 1, 1));
        this.txtpadCharactor.setItems(new String[]{"Space", "Null", "Character", "Hexadecimal"});
        this.txtpadCharactor.select(0);
        this.txtpadCharactor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditChangeConfirmationDialog.this.Padtype = EditChangeConfirmationDialog.this.txtpadCharactor.getText();
                if (EditChangeConfirmationDialog.this.txtpadCharactor.getSelectionIndex() == 3) {
                    EditChangeConfirmationDialog.this.txtpadCharactorValue.setEnabled(true);
                } else if (EditChangeConfirmationDialog.this.txtpadCharactor.getSelectionIndex() == 2) {
                    EditChangeConfirmationDialog.this.txtpadCharactorValue.setEnabled(true);
                } else {
                    EditChangeConfirmationDialog.this.txtpadCharactorValue.setEnabled(false);
                }
                EditChangeConfirmationDialog.this.isPageComplete();
            }
        });
        this.lblvalue = new Label((Composite)padCharactorGrp, 0);
        this.lblvalue.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 1, 1));
        this.lblvalue.setText("Value:");
        this.txtpadCharactorValue = new Combo((Composite)padCharactorGrp, 2048);
        this.txtpadCharactorValue.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 1, 1));
        this.txtpadCharactorValue.setText(this.store.getString("PAD_CHARACTER_VALUE"));
        this.txtpadCharactorValue.setEnabled(false);
        this.txtpadCharactorValue.addSelectionListener((SelectionListener)this);
        this.txtpadCharactorValue.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EditChangeConfirmationDialog.this.value = EditChangeConfirmationDialog.this.txtpadCharactorValue.getText();
                EditChangeConfirmationDialog.this.isPageComplete();
            }
        });
        return this.container;
    }

    private boolean isPageComplete() {
        String error = "";
        this.store.setValue("PAD_CHARACTER_VALUE", this.txtpadCharactorValue.getText());
        this.store.setValue("PAD_CHARACTER_TYPE", this.txtpadCharactor.getText());
        this.value = this.txtpadCharactorValue.getText();
        boolean returnVal = true;
        if (this.txtpadCharactor.getSelectionIndex() == 2) {
            error = Validator.errorMsg[Validator.Character((String)this.txtpadCharactorValue.getText(), (boolean)false)];
        }
        if (this.txtpadCharactor.getSelectionIndex() == 3) {
            error = Validator.errorMsg[Validator.Hexadecimal((String)this.txtpadCharactorValue.getText(), (boolean)false)];
        }
        if ((this.txtpadCharactor.getSelectionIndex() == 3 || this.txtpadCharactor.getSelectionIndex() == 2) && this.txtpadCharactorValue.getText().isEmpty()) {
            returnVal = false;
        }
        if (error.length() > 0) {
            this.setErrorMessage(error);
            returnVal = false;
        } else {
            this.setErrorMessage(null);
        }
        this.YesButton.setEnabled(returnVal);
        return returnVal;
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource().equals(this.YesButton)) {
            chgConfirmDialogVisited = true;
            if (this.Padtype.equalsIgnoreCase("Space")) {
                this.padCharacter = "X'40'";
                pad = "X'40'";
            } else if (this.Padtype.equalsIgnoreCase("Null")) {
                this.padCharacter = "X'00'";
                pad = "X'00'";
            } else if (this.Padtype.equalsIgnoreCase("Character")) {
                this.padCharacter = "C'" + this.value + "'";
                pad = "C'" + this.value + "'";
            } else if (this.Padtype.equalsIgnoreCase("Hexadecimal")) {
                this.padCharacter = "X'" + this.value + "'";
                pad = "X'" + this.value + "'";
            }
        } else {
            e.getSource().equals(this.NoButton);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.YesButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.YesButton.addSelectionListener((SelectionListener)this);
        this.NoButton = this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, true);
        this.NoButton.addSelectionListener((SelectionListener)this);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void modifyText(ModifyEvent e) {
    }

    public String getPadCharacter() {
        return this.padCharacter;
    }

    public void setPadCharacter(String padCharacter) {
        this.padCharacter = padCharacter;
    }
}

