/*
 * Decompiled with CFR 0.152.
 */
package com.ca.testingtools.ui.wizards;

import com.ca.testingtools.core.Profile;
import com.ca.testingtools.core.ServerTreeModel;
import com.ca.testingtools.core.TTServer;
import com.ca.testingtools.core.TT_TreeItem;
import com.ca.testingtools.ui.wizards.ProfileWizardPage;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class ProfileWizard
extends Wizard
implements INewWizard {
    static String cacopyright = "Copyright (c) 2016 CA";
    private TTServer server = null;
    private Profile profile = null;
    private ProfileWizardPage page;
    private boolean newItem = false;
    private static final ServerTreeModel model = ServerTreeModel.getInstance();

    public boolean performFinish() {
        return this.page.doFinish();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        TT_TreeItem profileItem;
        Object object = selection.getFirstElement();
        TT_TreeItem treeItem = model.findObject(object);
        if (treeItem != null && (profileItem = treeItem.getParent(Profile.class)) != null) {
            treeItem = profileItem;
        }
        if (treeItem != null) {
            Profile value = (Profile)treeItem.getAdapter(Profile.class);
            if (value != null) {
                this.profile = value;
                this.server = treeItem.getServer();
            } else if (treeItem.getAdapter(TTServer.class) != null) {
                this.server = (TTServer)treeItem.getValue();
            }
        }
    }

    public void addPages() {
        String title = this.newItem ? "New Profile" : String.format("Update %s", this.profile.toString());
        this.page = new ProfileWizardPage(this.profile, this.server, this.newItem, title);
        this.addPage((IWizardPage)this.page);
    }

    public void setNewItem(boolean newItem) {
        this.newItem = newItem;
        if (newItem) {
            this.profile = null;
            this.setWindowTitle("New Profile Definition");
        } else {
            this.setWindowTitle("Update Profile Definition");
        }
    }

    public boolean isNewItem() {
        return this.newItem;
    }
}

