/*
 * Decompiled with CFR 0.152.
 */
package com.ca.testingtools.handlers;

import com.ca.testingtools.core.IWatchData;
import com.ca.testingtools.core.Variable;
import com.ca.testingtools.ui.views.datawatch.WatchData;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class IwatchDataPropertyTester
extends PropertyTester {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    Logger log = Logger.getLogger(((Object)((Object)this)).getClass().getName());

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        boolean result = false;
        if (receiver instanceof IWatchData) {
            IWatchData watchData = (IWatchData)receiver;
            if ("canDisplayOccurs".equals(property) && watchData instanceof Variable) {
                Variable variable = (Variable)watchData;
                return variable.isOccurs() && variable.hasBackingData();
            }
            if ("isEmpty".equals(property)) {
                return watchData.isEmpty();
            }
            if ("nullParent".equals(property)) {
                return watchData.getParent() == null;
            }
            IWorkbenchWindow watchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            IWorkbenchPage page = watchWindow.getActivePage();
            IViewPart viewPart = page.findView("com.ca.testingtools.ui.views.watchdataview");
            if (viewPart instanceof WatchData) {
                WatchData item = (WatchData)viewPart;
                if ("topWatchItem".equals(property)) {
                    return item.isTop(watchData);
                }
                if ("lastWatchItem".equals(property)) {
                    return item.isBottom(watchData);
                }
            }
        }
        this.log.log(Level.FINEST, "{0}={1}", new Object[]{property, result});
        return result;
    }
}

