/*
 * Decompiled with CFR 0.152.
 */
package com.ca.testingtools.core;

import com.ca.testingtools.common.Attribute;
import com.ca.testingtools.common.HexUtil;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.core.TreeObject;
import com.ca.testingtools.core.Variable;
import java.util.Properties;
import org.w3c.dom.Element;

public class CobolVariable
extends Variable {
    static final String cacopyright = "Copyright \u00a9 2016 CA";

    public CobolVariable(Element element) throws TTException {
        super(element);
    }

    @Override
    public String getValue() {
        this.getBackingdata();
        if (this.allChildrenAreIndex()) {
            if (this.backingdata == null) {
                return "";
            }
            return this.getValue(this.getData());
        }
        if (this.hasChildren()) {
            return "(Group Level)";
        }
        if (!this.canEditDisplay()) {
            return "(Not Displayable)";
        }
        if (this.backingdata == null) {
            return "";
        }
        return this.getValue(this.getData());
    }

    @Override
    protected void setDatatype() {
        int gt_sign = (Integer)Attribute.getValue((String)"gt_sign", (Properties)this.attributes);
        int sign = gt_sign == 0 ? 0 : gt_sign & 8;
        Variable.DataType numeric = sign == 0 ? Variable.DataType.UNSIGNED : Variable.DataType.SIGNED;
        int gt_dptyp = (Integer)Attribute.getValue((String)"gt_dptyp", (Properties)this.attributes);
        int gt_dstyp = (Integer)Attribute.getValue((String)"gt_dstyp", (Properties)this.attributes);
        int gt_usag = (Integer)Attribute.getValue((String)"gt_usag", (Properties)this.attributes);
        block0 : switch (gt_dptyp) {
            case 0: {
                switch (gt_usag) {
                    case 0: {
                        if (gt_dstyp == 240) {
                            this.datatype = Variable.DataType.INDEX;
                            this.storagetype = Variable.StorageType.BIN;
                            break block0;
                        }
                        this.datatype = Variable.DataType.GROUP;
                        this.storagetype = Variable.StorageType.CHAR;
                        break block0;
                    }
                    case 1: {
                        this.datatype = numeric;
                        if (this.datatype == Variable.DataType.UNSIGNED) {
                            this.storagetype = Variable.StorageType.DISPLAY;
                        }
                        if ((gt_sign & 1) != 0) {
                            if ((gt_sign & 4) != 0) {
                                this.storagetype = Variable.StorageType.DISPLAY_SIGNED_SEPARATE_LEFT;
                                break block0;
                            }
                            this.storagetype = Variable.StorageType.DISPLAY_SIGNED_LEFT;
                            break block0;
                        }
                        if ((gt_sign & 4) != 0) {
                            this.storagetype = Variable.StorageType.DISPLAY_SIGNED_SEPARATE;
                            break block0;
                        }
                        this.storagetype = Variable.StorageType.DISPLAY;
                        break block0;
                    }
                    case 2: 
                    case 4: {
                        this.datatype = Variable.DataType.ALPHA;
                        this.storagetype = Variable.StorageType.CHAR;
                        break block0;
                    }
                    case 3: {
                        this.datatype = numeric;
                        this.storagetype = Variable.StorageType.PACK;
                        break block0;
                    }
                    case 5: {
                        this.datatype = numeric;
                        this.storagetype = Variable.StorageType.BIN;
                        break block0;
                    }
                    case 6: {
                        this.datatype = Variable.DataType.GROUP;
                        this.storagetype = Variable.StorageType.HEX;
                        break block0;
                    }
                    case 15: {
                        if (this.getPicture().indexOf(65) < 0) break;
                        this.datatype = Variable.DataType.ALPHA;
                        this.storagetype = Variable.StorageType.CHAR;
                        break block0;
                    }
                }
                this.datatype = Variable.DataType.UNKNOWN;
                this.storagetype = Variable.StorageType.HEX;
                break;
            }
            case 96: {
                this.datatype = Variable.DataType.FLOAT;
                this.storagetype = Variable.StorageType.BIN;
                break;
            }
            case 8: {
                switch (gt_usag) {
                    case 0: {
                        this.datatype = Variable.DataType.GROUP;
                        this.storagetype = Variable.StorageType.CHAR;
                        break block0;
                    }
                    case 1: {
                        this.datatype = numeric;
                        if (this.datatype == Variable.DataType.UNSIGNED) {
                            this.storagetype = Variable.StorageType.DISPLAY;
                        }
                        if ((gt_sign & 1) != 0) {
                            if ((gt_sign & 4) != 0) {
                                this.storagetype = Variable.StorageType.DISPLAY_SIGNED_SEPARATE_LEFT;
                                break block0;
                            }
                            this.storagetype = Variable.StorageType.DISPLAY_SIGNED_LEFT;
                            break block0;
                        }
                        if ((gt_sign & 4) != 0) {
                            this.storagetype = Variable.StorageType.DISPLAY_SIGNED_SEPARATE;
                            break block0;
                        }
                        this.storagetype = Variable.StorageType.DISPLAY;
                        break block0;
                    }
                    case 2: 
                    case 4: {
                        this.datatype = Variable.DataType.ALPHA;
                        this.storagetype = Variable.StorageType.CHAR;
                        break block0;
                    }
                    case 3: {
                        this.datatype = numeric;
                        this.storagetype = Variable.StorageType.PACK;
                        break block0;
                    }
                    case 5: {
                        this.datatype = numeric;
                        this.storagetype = Variable.StorageType.BIN;
                        break block0;
                    }
                    case 6: {
                        this.datatype = Variable.DataType.GROUP;
                        this.storagetype = Variable.StorageType.HEX;
                        break block0;
                    }
                    case 15: {
                        if (this.getPicture().indexOf(65) < 0) break;
                        this.datatype = Variable.DataType.ALPHA;
                        this.storagetype = Variable.StorageType.CHAR;
                        break block0;
                    }
                }
                this.datatype = Variable.DataType.UNKNOWN;
                this.storagetype = Variable.StorageType.HEX;
                break;
            }
            case 11: {
                this.datatype = numeric;
                this.storagetype = Variable.StorageType.BIN;
                break;
            }
            case 9: {
                this.datatype = Variable.DataType.FLOAT;
                this.storagetype = Variable.StorageType.EXTERNAL;
                break;
            }
            case 12: {
                this.datatype = numeric;
                this.storagetype = Variable.StorageType.PACK;
                break;
            }
            case 10: {
                this.datatype = Variable.DataType.FLOAT;
                this.storagetype = Variable.StorageType.INTERNAL;
                break;
            }
            case 16: 
            case 64: {
                this.datatype = Variable.DataType.UNKNOWN;
                this.storagetype = Variable.StorageType.HEX;
                break;
            }
            case 6: 
            case 48: {
                this.datatype = Variable.DataType.POINTER;
                this.storagetype = Variable.StorageType.HEX;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 32: 
            case 80: {
                this.datatype = Variable.DataType.ALPHA;
                this.storagetype = Variable.StorageType.CHAR;
                break;
            }
            default: {
                this.datatype = Variable.DataType.UNKNOWN;
                this.storagetype = Variable.StorageType.HEX;
            }
        }
        int ix = 0;
        while (ix < 7) {
            String key = String.format("gt_dmax%d", ix + 1);
            String str = this.getAttribute(key);
            if (str.isEmpty()) break;
            this.levels[ix] = (Integer)Attribute.getValue((String)key, (Properties)this.attributes);
            String key2 = String.format("gt_incr%d", ix + 1);
            this.gt_incr[ix] = (Integer)Attribute.getValue((String)key2, (Properties)this.attributes);
            ++ix;
        }
    }

    @Override
    public boolean canEditDisplay() {
        if (this.hasChildren()) {
            return false;
        }
        switch (this.storagetype) {
            default: {
                return false;
            }
            case BIN: {
                return this.datatype != Variable.DataType.FLOAT;
            }
            case CHAR: 
            case PACK: 
            case DISPLAY: 
            case DISPLAY_SIGNED_LEFT: 
            case DISPLAY_SIGNED_SEPARATE: 
            case DISPLAY_SIGNED_SEPARATE_LEFT: 
        }
        return true;
    }

    @Override
    public boolean canEditHex() {
        return true;
    }

    @Override
    public int getDecimalPoint() {
        return (Integer)Attribute.getValue((String)"gt_sigfr", (Properties)this.attributes);
    }

    @Override
    public String varyCheck(String value, boolean mode) {
        return value;
    }

    public boolean allChildrenAreIndex() {
        if (this.children.size() == 0) {
            return false;
        }
        for (TreeObject child : this.children) {
            if (!(child instanceof CobolVariable) || ((CobolVariable)child).getDatatype() == Variable.DataType.INDEX) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getHexText() {
        return this.getHexValue();
    }

    @Override
    public String getHexTextTooltipText() {
        return this.getHexValue();
    }

    @Override
    public String getProperties() {
        String ix;
        String picture = this.getPicture();
        String value = "";
        Integer fsize = (Integer)Attribute.getValue((String)"length", (Properties)this.attributes);
        String sFsize = fsize > 0 ? String.format("[%d]", fsize) : "";
        Integer dptyp = (Integer)Attribute.getValue((String)"gt_dptyp", (Properties)this.attributes);
        switch (dptyp) {
            case 1: {
                value = "Fixed length group";
                break;
            }
            case 2: {
                value = "Alphabetic";
                if (picture.length() <= 0) break;
                value = "PIC " + picture + " " + value;
                sFsize = "";
                break;
            }
            case 3: {
                value = "Alphanumeric";
                if (picture.length() <= 0) break;
                value = "PIC " + picture + " " + value;
                sFsize = "";
                break;
            }
            case 4: {
                value = "Variable length group";
                break;
            }
            case 5: {
                value = "Numeric edited";
                if (picture.length() <= 0) break;
                value = "PIC " + picture + " " + value;
                sFsize = "";
                break;
            }
            case 6: {
                value = "Pointer";
                break;
            }
            case 7: {
                value = "Index";
                break;
            }
            case 8: {
                value = "PIC " + picture;
                sFsize = "";
                break;
            }
            case 9: {
                value = "External floating-point";
                break;
            }
            case 10: {
                value = "COMP-1/COMP-2";
                if (picture.length() <= 0) break;
                value = "PIC " + picture + " " + value;
                sFsize = "";
                break;
            }
            case 11: {
                value = "Binary";
                if (picture.length() <= 0) break;
                value = "PIC " + picture + " " + value;
                sFsize = "";
                break;
            }
            case 12: {
                value = "COMP-3";
                if (picture.length() <= 0) break;
                value = "PIC " + picture + " " + value;
                sFsize = "";
                break;
            }
            case 13: {
                value = "Sterling non-report";
                break;
            }
            case 14: {
                value = "Alphanumeric edited";
                if (picture.length() <= 0) break;
                value = "PIC " + picture + " " + value;
                sFsize = "";
                break;
            }
            case 15: {
                value = "Renames (Level 66)";
                break;
            }
            case 16: {
                value = "DISPLAY-1 (DCBS)";
                break;
            }
            case 17: {
                value = "COBOL Redefines";
                break;
            }
            case 32: {
                value = "Native";
                break;
            }
            case 48: {
                value = "Procedure pointer";
                break;
            }
            case 64: {
                value = "ASM";
                break;
            }
            case 80: {
                value = "Bit field";
                break;
            }
            case 96: {
                value = "Binary floating-point";
                if (picture.length() <= 0) break;
                value = "PIC " + picture + " " + value;
                sFsize = "";
            }
        }
        if (value.length() == 0 && (ix = this.getAttribute("gt_dstyp")).equals("f0")) {
            value = "Index";
            sFsize = "";
        }
        StringBuilder arrayTag = new StringBuilder(this.levels.length * 4 + 10);
        if (this.levels[0] > 0) {
            arrayTag.append("OCCURS (");
            int[] nArray = this.levels;
            int n = this.levels.length;
            int n2 = 0;
            while (n2 < n) {
                int iValue = nArray[n2];
                if (iValue > 0) {
                    arrayTag.append(String.format("%d,", iValue));
                }
                ++n2;
            }
            arrayTag.setCharAt(arrayTag.length() - 1, ')');
        }
        return HexUtil.Squeeze((String)String.format("%s %s %s", value, sFsize, arrayTag.toString()));
    }

    @Override
    public String getPropertiesTooltipText() {
        return this.getPicture();
    }

    @Override
    public String getValueTooltipText() {
        return this.getValue();
    }

    @Override
    public String getTitle() {
        return this.getName();
    }

    @Override
    public String getDataRequestName() {
        return this.getName();
    }
}

