/*
 * Decompiled with CFR 0.152.
 */
package com.ca.symdump.views.index;

import com.ca.symdump.Abend;
import com.ca.symdump.SymdumpDatset;
import com.ca.symdump.views.index.IndexColumnlabelProvider;
import com.ca.symdump.views.index.IndexViewContentProvider;
import com.ca.symdump.views.index.IndexViewerSorter;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.core.IProfileSetContent;
import com.ca.testingtools.core.NodeChild;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;

public class IndexView
extends ViewPart
implements IProfileSetContent {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    private static final String sourceClass = IndexView.class.getName();
    Logger log = Logger.getLogger(sourceClass);
    private static final String DESCRIPTION_TEXT = "Dump Index list";
    private static final String CONTEXT_HELP_ID = "com.ca.symdump.help.indexview";
    public static final String ID = "com.ca.symdump.ui.views.indexview";
    private TableViewer viewer;
    private final ArrayList<Abend> abends = new ArrayList();
    private final ArrayList<SymdumpDatset> datasets = new ArrayList();
    private static final String OPENDUMP = "com.ca.symdump.commands.opendump";
    private static final int[] columnIDs;
    private static final String[] columnNames;
    private static final int[] columnAlignments;
    private final int[] columnWidths = new int[]{110, 100, 100, 100, 100, 100, 100, 100, 110, 200};
    private final int[] columnOrder;
    private Listener sortListener;

    static {
        int[] nArray = new int[10];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        nArray[6] = 6;
        nArray[7] = 7;
        nArray[8] = 8;
        nArray[9] = 9;
        columnIDs = nArray;
        columnNames = new String[]{"JobName/Task", "Program", "Offset", "ABEND", "Date", "Time", "User ID", "Lock", "System/Region", "DSName"};
        columnAlignments = new int[]{16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384};
    }

    public IndexView() {
        int[] nArray = new int[10];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        nArray[6] = 6;
        nArray[7] = 7;
        nArray[8] = 8;
        nArray[9] = 9;
        this.columnOrder = nArray;
    }

    public void createPartControl(Composite parent) {
        this.viewer = new TableViewer(parent, 68354);
        this.viewer.setContentProvider((IContentProvider)new IndexViewContentProvider());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer, (int)2);
        Table table = this.viewer.getTable();
        this.setTitleToolTip(DESCRIPTION_TEXT);
        this.setContentDescription(DESCRIPTION_TEXT);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.viewer.getControl(), CONTEXT_HELP_ID);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.setupColumnLsitener();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.viewer.getTable().getColumnOrder();
        int i = 0;
        while (i < columnNames.length) {
            TableColumn tableColumn = new TableColumn(table, columnAlignments[i]);
            tableColumn.setText(columnNames[i]);
            tableColumn.setWidth(this.columnWidths[i]);
            tableColumn.setData((Object)columnIDs[i]);
            tableColumn.setMoveable(true);
            tableColumn.setResizable(true);
            tableColumn.addListener(13, this.sortListener);
            TableViewerColumn viewerColumn = new TableViewerColumn(this.viewer, tableColumn);
            viewerColumn.setLabelProvider((CellLabelProvider)new IndexColumnlabelProvider(i, table));
            ++i;
        }
        table.setColumnOrder(this.columnOrder);
        this.viewer.setSorter((ViewerSorter)new IndexViewerSorter());
        table.setSortColumn(table.getColumn(4));
        table.setSortDirection(1024);
        this.viewer.setInput(null);
    }

    private void setupColumnLsitener() {
        this.sortListener = new Listener(){

            public void handleEvent(Event event) {
                TableColumn column = (TableColumn)event.widget;
                Table table = IndexView.this.viewer.getTable();
                if (column.equals(table.getSortColumn())) {
                    int direction = table.getSortDirection();
                    switch (direction) {
                        case 1024: {
                            table.setSortDirection(128);
                            break;
                        }
                        default: {
                            table.setSortDirection(1024);
                            break;
                        }
                    }
                } else {
                    table.setSortColumn(column);
                    table.setSortDirection(128);
                }
                IndexView.this.viewer.refresh();
            }
        };
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.add((IContributionItem)new GroupMarker("additions"));
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IndexView.this.getSite().getPart().setFocus();
                IndexView.this.viewer.getTable().getSelectionIndex();
                IndexView.this.viewer.setSelection(event.getSelection(), true);
                IHandlerService service = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
                try {
                    service.executeCommand(IndexView.OPENDUMP, null);
                    IndexView.this.viewer.getTable().deselectAll();
                }
                catch (Exception e) {
                    IndexView.this.log.log(Level.FINE, IndexView.OPENDUMP, e);
                }
            }
        });
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
    }

    public void setContent(NodeChild[] nodes, boolean clearView) {
        this.datasets.clear();
        NodeChild[] nodeChildArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            NodeChild child = nodeChildArray[n2];
            if (child instanceof SymdumpDatset) {
                this.datasets.add((SymdumpDatset)child);
            }
            ++n2;
        }
        if (this.datasets.size() > 0) {
            if (clearView) {
                this.abends.clear();
                this.viewer.setInput((Object)new Abend[0]);
            }
            for (SymdumpDatset dataset : this.datasets) {
                dataset.requestContents(this);
            }
        }
    }

    public void addContent(Object[] elements, boolean clearList) {
        ArrayList<Abend> newList = new ArrayList<Abend>(elements.length);
        boolean changed = false;
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            if (child instanceof Abend) {
                SymdumpDatset dsn = ((Abend)child).getDataset();
                if (!this.datasets.contains((Object)dsn)) {
                    this.datasets.add(dsn);
                    changed = true;
                }
                newList.add((Abend)child);
            }
            ++n2;
        }
        if (this.mergeList(newList) || changed) {
            this.viewer.setInput((Object)this.abends.toArray(new Abend[this.abends.size()]));
            this.viewer.refresh(true);
        }
    }

    private boolean mergeList(ArrayList<Abend> newList) {
        if (newList.size() == 0) {
            return false;
        }
        boolean changed = false;
        SymdumpDatset dataset = newList.get(0).getDataset();
        ArrayList<Abend> oldList = this.getSiblings(dataset);
        Iterator<Abend> it = oldList.iterator();
        while (it.hasNext()) {
            Abend old = it.next();
            int index = newList.indexOf(old);
            if (index < 0) continue;
            old.upDate(newList.get(index));
            changed = true;
            newList.remove(index);
            it.remove();
        }
        changed = newList.size() > 0 || oldList.size() > 0 || changed;
        for (Abend item : oldList) {
            this.abends.remove(item);
        }
        for (Abend item : newList) {
            this.abends.add(item);
        }
        return changed;
    }

    private ArrayList<Abend> getSiblings(SymdumpDatset dataset) {
        ArrayList<Abend> list = new ArrayList<Abend>(this.abends.size());
        for (Abend item : this.abends) {
            if (item.getDataset() != dataset) continue;
            list.add(item);
        }
        return list;
    }

    public void removeContent(NodeChild[] elements) {
        NodeChild[] nodeChildArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            NodeChild item = nodeChildArray[n2];
            if (item instanceof SymdumpDatset) {
                ArrayList<Abend> list = this.getSiblings((SymdumpDatset)item);
                for (Abend abend : list) {
                    this.abends.remove(abend);
                }
            }
            ++n2;
        }
        this.viewer.setInput((Object)this.abends.toArray(new Abend[this.abends.size()]));
        this.viewer.refresh(true);
    }

    public SymdumpDatset[] getDatasets() {
        return this.datasets.toArray(new SymdumpDatset[this.datasets.size()]);
    }

    protected class DoubleClickListener
    implements IDoubleClickListener {
        private static final String LOADTREE = "com.ca.symdump.commands.loadtree";

        protected DoubleClickListener() {
        }

        public void doubleClick(DoubleClickEvent event) {
            IHandlerService service = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
            try {
                service.executeCommand(LOADTREE, null);
            }
            catch (Exception e) {
                IndexView.this.log.log(Level.FINE, LOADTREE, e);
            }
        }
    }

    protected class RunGetDump
    extends Job {
        private Abend abend;

        RunGetDump(Abend abend) {
            super("Getting dump for " + abend.toString());
            this.abend = abend;
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                this.abend.getDumpTree();
            }
            catch (TTException e) {
                IndexView.this.log.log(Level.INFO, ((Object)((Object)e)).getClass().getSimpleName(), e);
            }
            return Status.OK_STATUS;
        }
    }
}

