/*
 * Decompiled with CFR 0.152.
 */
package com.ca.symdump.handlers;

import com.ca.symdump.DumpTreeNode;
import com.ca.symdump.RunGetMap;
import com.ca.symdump.views.tree.DumpTreeView;
import com.ca.testingtools.core.IWatchData;
import com.ca.testingtools.ui.views.datawatch.WatchData;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class MapSysData
extends AbstractHandler {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    DumpTreeNode node = null;
    private static final String sourceClass = MapSysData.class.getName();
    Logger log = Logger.getLogger(sourceClass);
    Level baseLevel = this.log.getLevel();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
        IWatchData data = null;
        if (part instanceof DumpTreeView) {
            Object obj;
            ISelection sel = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
            if (sel instanceof IStructuredSelection && !sel.isEmpty() && (obj = ((IStructuredSelection)sel).getFirstElement()) instanceof DumpTreeNode) {
                this.node = (DumpTreeNode)obj;
                if (!this.node.isLeaf()) {
                    return this.noData(this.node);
                }
                data = this.node.getMappedData();
                if (data == null) {
                    RunGetMap runner = new RunGetMap(this.node, part);
                    BusyIndicator.showWhile((Display)part.getSite().getShell().getDisplay(), (Runnable)runner);
                    data = runner.getMapData();
                }
                if (this.node.getParent().getTitle().matches("Loaded Programs")) {
                    return null;
                }
                if (data == null || data.isEmpty()) {
                    MessageDialog.openWarning((Shell)part.getSite().getShell(), (String)"Add Mapped data to Watch View", (String)String.format("Mapped data for %s is not available.", this.node.getText()));
                } else {
                    try {
                        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        IWorkbenchPage page = window.getActivePage();
                        IViewPart viewPart = page.showView("com.ca.testingtools.ui.views.watchdataview");
                        if (viewPart instanceof WatchData) {
                            WatchData viewer = (WatchData)viewPart;
                            viewer.addContent(new IWatchData[]{data});
                        }
                        page.activate((IWorkbenchPart)viewPart);
                        page.bringToTop((IWorkbenchPart)viewPart);
                    }
                    catch (PartInitException e) {
                        this.log.log(Level.WARNING, "Unexpected failure", e);
                    }
                }
            }
            return null;
        }
        return null;
    }

    protected Object noData(DumpTreeNode node) {
        String message = node == null ? "The request to view data is not available" : String.format("The request to view data for %s is not possible", node.getTitle());
        MessageDialog.openWarning(null, (String)"Request Report", (String)message);
        return null;
    }
}

