/*
 * Decompiled with CFR 0.152.
 */
package com.ca.symdump;

import com.ca.symdump.CICSTrace;
import com.ca.symdump.DumpTreeNode;
import com.ca.symdump.RunGetTrace;
import com.ca.symdump.SymdumpDatset;
import com.ca.symdump.SymdumpHeaderMap;
import com.ca.testingtools.common.HexUtil;
import com.ca.testingtools.common.MFAddress;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.core.Data;
import com.ca.testingtools.core.Dataset;
import com.ca.testingtools.core.IMemoryManager;
import com.ca.testingtools.core.IWatchData;
import com.ca.testingtools.core.TTServer;
import com.ca.testingtools.ui.views.datawatch.WatchData;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Logger;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public abstract class Abend {
    static String cacopyright = "Copyright (c) 2016 CA";
    public static final int JOBNAME = 0;
    public static final int PROGRAM = 1;
    public static final int OFFSET = 2;
    public static final int ABEND = 3;
    public static final int DATE = 4;
    public static final int TIME = 5;
    public static final int USERID = 6;
    public static final int LOCK = 7;
    public static final int SYSREG = 8;
    public static final int DSNAME = 9;
    public static final int STEPNAME = 10;
    public static final int DISPLAY_TIME = 100;
    public static final int SYMDUMP_NAME = 101;
    public static final int SYMDUMP_SYSD = 102;
    public static final int TIMESTAMP = 103;
    public static final String UUID = "uuid";
    protected SymdumpDatset dataset = null;
    protected static final String TOSTR_FORMAT = "%s %s %s %s %s %s %s %s %s %s";
    protected static final String TOSTR_SHORT_FORMAT = "%s %s %s %s %s";
    protected String name = "";
    protected String ObjectAddr;
    protected Properties properties = new Properties();
    protected String uuid = null;
    protected TTServer server = null;
    protected DumpTreeNode dumpTreeNode = null;
    protected HashMap<String, String> column = new HashMap();
    protected ArrayList<ViewPart> views = new ArrayList();
    protected ArrayList<CICSTrace> traces = null;
    private ArrayList<Dataset> protsyms = null;
    private Document document = null;
    protected Logger log = Logger.getLogger(this.getClass().getName());
    protected IMemoryManager memoryManager = null;
    private String dsn;

    protected Abend(Element element) {
        NamedNodeMap attributes = element.getAttributes();
        int size = attributes.getLength();
        int index = 0;
        while (index < size) {
            Attr attr = (Attr)attributes.item(index);
            String key = attr.getName();
            String value = attr.getValue().trim();
            this.properties.setProperty(key, value);
            ++index;
        }
    }

    public abstract XMLRequest deleteDump() throws TTException, MalformedURLException;

    public abstract XMLRequest lockDump() throws TTException, MalformedURLException;

    public abstract XMLRequest unlockDump() throws TTException, MalformedURLException;

    public DumpTreeNode getDumpTree() throws TTException {
        return this.getDumpTree(true);
    }

    public abstract DumpTreeNode getDumpTree(boolean var1) throws TTException;

    public boolean isOpen() {
        return this.dumpTreeNode != null;
    }

    public abstract String getSysd();

    public abstract String getSymDumpName();

    public void setDSN(String dsn) {
        this.dsn = dsn;
    }

    public String getDsn() {
        String value;
        String string = value = this.dsn == null ? "" : this.dsn;
        if (value.isEmpty()) {
            return this.dataset == null ? "" : this.dataset.getName();
        }
        return value;
    }

    public void setDataset(SymdumpDatset dataset) {
        this.dataset = dataset;
    }

    public String getObjectAddr() {
        return this.ObjectAddr;
    }

    public void setObjectAddr(String objectAddr) {
        this.ObjectAddr = objectAddr;
    }

    public String getColumn(String columnID) {
        String result = this.column.get(columnID);
        return result == null ? "" : result;
    }

    public abstract String getColumn(int var1);

    public abstract Image getColumnImage(Object var1, int var2);

    protected void setValues(ArrayList<SymdumpHeaderMap> headerMap, String lineRecord) {
        for (SymdumpHeaderMap header : headerMap) {
            int beginIndex = header.beginIndex;
            int endIndex = header.endIndex;
            int count = lineRecord.length();
            String value = beginIndex < 0 ? "" : (beginIndex > count ? "" : (endIndex > count ? lineRecord.substring(beginIndex).trim() : lineRecord.substring(beginIndex, endIndex).trim()));
            this.column.put(header.columnName, value);
        }
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public TTServer getServer() {
        return this.server;
    }

    public void setServer(TTServer server) {
        this.server = server;
    }

    public abstract XMLRequest getReport(DumpTreeNode var1);

    public abstract Data getData(DumpTreeNode var1);

    public abstract Data getData(MFAddress var1);

    public abstract IWatchData getMapData(DumpTreeNode var1, IWorkbenchPart var2);

    public void addView(ViewPart viewPart) {
        if (this.views == null) {
            this.views = new ArrayList();
        }
        if (!this.views.contains(viewPart)) {
            this.views.add(viewPart);
        }
    }

    public void removeView(ViewPart viewPart) {
        if (viewPart != null && this.views != null) {
            this.views.remove(viewPart);
        }
    }

    public boolean isLocked() {
        return this.getLocked().length() > 0;
    }

    public String getLocked() {
        String locked = this.getColumn(7);
        if (locked == null) {
            return "";
        }
        return locked.replace("NONE", "");
    }

    public abstract String getKey();

    protected abstract void doClose();

    public void closeDump(boolean closeViews) {
        if (this.dumpTreeNode != null) {
            this.doClose();
        }
        this.dumpTreeNode = null;
        this.protsyms = null;
        this.memoryManager = null;
        this.document = null;
        this.traces = null;
        if (closeViews && this.views != null) {
            IViewPart viewPart;
            ViewPart[] viewPartArray = this.views.toArray(new ViewPart[this.views.size()]);
            int n = viewPartArray.length;
            int n2 = 0;
            while (n2 < n) {
                ViewPart view = viewPartArray[n2];
                try {
                    view.getViewSite().getPage().hideView((IViewPart)view);
                }
                catch (Exception exception) {}
                ++n2;
            }
            this.views = null;
            IWorkbenchWindow watchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            IWorkbenchPage page = watchWindow.getActivePage();
            if (page != null && (viewPart = page.findView("com.ca.testingtools.ui.views.watchdataview")) instanceof IPropertyChangeListener) {
                IPropertyChangeListener view = (IPropertyChangeListener)viewPart;
                PropertyChangeEvent event = new PropertyChangeEvent((Object)this, WatchData.watchID, (Object)this.hashCode(), null);
                view.propertyChange(event);
            }
        }
    }

    public SymdumpDatset getDataset() {
        return this.dataset;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Abend)) {
            return false;
        }
        Abend other = (Abend)obj;
        if (this.dataset == null ? other.dataset != null : !this.dataset.equals((Object)other.dataset)) {
            return false;
        }
        if (this.server == null ? other.server != null : !this.server.equals((Object)other.server)) {
            return false;
        }
        if (!this.ObjectAddr.equals(other.ObjectAddr)) {
            return false;
        }
        return this.getKey().equals(other.getKey());
    }

    public void upDate(Abend abend) {
        this.properties = abend.properties;
        this.column = abend.column;
        this.ObjectAddr = abend.ObjectAddr;
    }

    public String getToolTip() {
        StringBuilder string = new StringBuilder(100);
        string.append(this.getSymDumpName());
        string.append(HexUtil.LF);
        ArrayList<SymdumpHeaderMap> headerlist = this.dataset.getHeaderMap();
        for (SymdumpHeaderMap header : headerlist) {
            String key = header.getColumnName();
            String value = this.column.get(key);
            if (key.equalsIgnoreCase("date")) {
                value = this.getColumn(103);
            }
            if (value == null || value.length() == 0 || key.equalsIgnoreCase("time")) continue;
            string.append(key);
            string.append(": ");
            string.append(value);
            string.append(HexUtil.LF);
        }
        string.append("Dump DSN");
        string.append(':');
        string.append(this.getDsn());
        return string.toString();
    }

    public String toString() {
        return String.format(TOSTR_FORMAT, this.getColumn(0), this.getColumn(4), this.getColumn(100), this.getColumn(3), this.getColumn(1), this.getColumn(2), this.getColumn(6), this.getColumn(8), this.getColumn(7), this.getColumn(9));
    }

    public String toShortString() {
        return String.format(TOSTR_SHORT_FORMAT, this.getColumn(0), this.getColumn(4), this.getColumn(100), this.getColumn(3), this.getColumn(1));
    }

    public void setProtsyms(ArrayList<Dataset> datasets) {
        this.protsyms = datasets;
    }

    public ArrayList<Dataset> getProtsyms() {
        return this.protsyms;
    }

    public abstract IMemoryManager getMemoryManager();

    public Document getDocument() {
        if (this.document == null) {
            this.document = new Document();
        }
        return this.document;
    }

    public ArrayList<ViewPart> getViews() {
        return this.views;
    }

    public CICSTrace[] getCICSTraceRecords() {
        return this.traces == null ? null : this.traces.toArray(new CICSTrace[this.traces.size()]);
    }

    public void addCICSTraceRecord(CICSTrace CICStraceRecord) {
        if (this.traces == null) {
            this.traces = new ArrayList();
        }
        if (!this.traces.contains(CICStraceRecord)) {
            this.traces.add(CICStraceRecord);
        }
    }

    public String getID() {
        return String.valueOf(this.hashCode());
    }

    public abstract RunGetTrace getGetTrace(DumpTreeNode var1);

    public boolean isEnabled() {
        return true;
    }
}

