/*
 * Decompiled with CFR 0.152.
 */
package com.ca.symdump.handlers;

import com.ca.symdump.BuildDocument;
import com.ca.symdump.RunGetOptions;
import com.ca.symdump.SymDumpProfileNode;
import com.ca.symdump.views.options.OptionsView;
import com.ca.testingtools.common.XMLRequest;
import com.ca.testingtools.core.TTServer;
import com.ca.testingtools.core.TT_TreeItem;
import com.ca.testingtools.ui.dialogs.TT_ErrorDialog;
import com.ca.testingtools.ui.views.profile.ProfileView;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;

public class DisplayOptionsHandler
extends AbstractHandler {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    private static final String sourceClass = DisplayOptionsHandler.class.getName();
    Logger log = Logger.getLogger(sourceClass);
    Level baseLevel = this.log.getLevel();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object obj;
        ISelection sel;
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
        boolean done = false;
        if (part instanceof ProfileView && (sel = HandlerUtil.getCurrentSelection((ExecutionEvent)event)) instanceof IStructuredSelection && !sel.isEmpty() && (obj = ((IStructuredSelection)sel).getFirstElement()) instanceof TT_TreeItem) {
            TT_TreeItem item = (TT_TreeItem)obj;
            SymDumpProfileNode node = (SymDumpProfileNode)item.getValue();
            IWorkbenchPage page = part.getSite().getPage();
            TTServer server = item.getServer();
            String secondaryID = String.format("%d%s", server.hashCode(), item.getName());
            IViewReference viewRef = page.findViewReference("com.ca.symdump.ui.views.optionsview", secondaryID);
            IViewPart viewPart = null;
            if (viewRef != null) {
                viewPart = viewRef.getView(true);
                if (viewPart instanceof OptionsView) {
                    if (node.hasOptions()) {
                        done = true;
                    }
                } else {
                    this.log.log(Level.FINE, "view not right class");
                    done = true;
                }
            }
            if (!done) {
                RunGetOptions runner = new RunGetOptions(node);
                BusyIndicator.showWhile((Display)part.getSite().getShell().getDisplay(), (Runnable)runner);
                XMLRequest xml = runner.getXml();
                int result = xml.getErrorLevel();
                if (result != 0) {
                    String title = "Request Failed for " + server.getText();
                    if (result < 8) {
                        MessageDialog.openWarning(null, (String)title, (String)xml.getErrorMessage());
                    } else {
                        TT_ErrorDialog.openError(null, (String)title, (String)xml.getErrorMessage());
                    }
                    return null;
                }
                viewPart = this.buildView(page, xml, node, secondaryID, String.format("%s - %s Options in effect", server.getName(), item.getName().trim().toUpperCase()));
            }
            page.activate((IWorkbenchPart)viewPart);
            page.activate(part);
        }
        return null;
    }

    protected IViewPart buildView(IWorkbenchPage page, XMLRequest xml, SymDumpProfileNode node, String secondaryID, String title) {
        try {
            IViewPart viewPart = page.showView("com.ca.symdump.ui.views.optionsview", secondaryID, 1);
            if (viewPart instanceof OptionsView) {
                OptionsView viewer = (OptionsView)viewPart;
                Document document = BuildDocument.buildDocument(xml);
                node.setOptionsView(viewPart);
                viewer.setContent(document, title);
                return viewPart;
            }
        }
        catch (PartInitException e) {
            this.log.log(Level.INFO, ((Object)((Object)e)).getClass().getSimpleName(), e);
        }
        return null;
    }
}

