/*
 * Decompiled with CFR 0.152.
 */
package com.ca.testingtools.common;

import com.ca.testingtools.common.Attribute;
import com.ca.testingtools.common.IScanSource;
import com.ca.testingtools.common.scanSource;

public class scanASM
extends scanSource
implements IScanSource {
    static String cacopyright = "Copyright \u00a9 2011 CA";
    protected Integer version;
    protected String regex = "[0-9]+";

    public scanASM(String version) {
        this.version = (Integer)Attribute.getValue("gt_m_aty", version);
    }

    @Override
    public int getType() {
        return 16;
    }

    @Override
    protected void setValues() {
        this.seqStart = 34;
        this.seqEnd = this.seqStart + 5;
        this.stmtStart = 40;
        this.stmtComment = 40;
        this.stripblanks = true;
        this.lineRegex = "[\\w\\+\\-*=().]+|('[\\w\\+\\s-*=,]+')";
    }

    @Override
    public boolean isCandidate(String line) {
        if (line.length() < this.stmtStart || line.startsWith("** ASMA")) {
            return false;
        }
        if (line.trim().startsWith("General Purpose Register Cross Reference ")) {
            return false;
        }
        String stmnt = line.substring(this.seqStart, this.seqEnd);
        while (stmnt.startsWith(" ")) {
            stmnt = stmnt.substring(1);
        }
        if (stmnt.endsWith(" ")) {
            stmnt = stmnt.substring(0, stmnt.length() - 1);
        }
        if (stmnt.length() == 0) {
            return false;
        }
        boolean numeric = stmnt.matches(this.regex);
        if (!numeric) {
            return false;
        }
        String frontend = line.substring(0, this.seqStart).trim();
        if (frontend.length() == 0) {
            return true;
        }
        boolean hex = frontend.matches("[0-9A-F\\s]+");
        return hex;
    }

    @Override
    public int getStatement(String line) {
        int statement = -1;
        if (this.isCandidate(line)) {
            String number = line.substring(this.seqStart, this.seqEnd);
            while (number.startsWith(" ")) {
                number = number.substring(1);
            }
            if (number.endsWith(" ")) {
                number = number.substring(0, number.length() - 1);
            }
            if (number.length() == 0) {
                return -1;
            }
            try {
                statement = Integer.parseInt(number);
            }
            catch (NumberFormatException numberFormatException) {
                statement = -1;
            }
            if (statement != -1) {
                if (!line.startsWith("      ")) {
                    int hex = -1;
                    try {
                        hex = Integer.parseInt(number, 16);
                    }
                    catch (NumberFormatException numberFormatException) {
                        hex = -1;
                    }
                    if (hex == -1) {
                        return -1;
                    }
                }
                return statement;
            }
        }
        return -1;
    }
}

