/*
 * Decompiled with CFR 0.152.
 */
package com.ca.testingtools.common;

import com.ca.testingtools.common.HexUtil;
import com.ca.testingtools.common.TTException;
import com.ca.testingtools.common.XMLDocument;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.InputSource;

public class XMLRequest
extends XMLDocument {
    static String cacopyright = "Copyright \u00a9 2011 CA";
    public static final String FILECONTENTYPE = "filecontentype";
    public static final String FILENAME = "filename";
    public static final String FILEKEEP = "filekeep";
    public static final String LOCALFILENAME = "localfilename";
    public static final String NOAUTOLOG = "noautolog";
    public static final String VERSION = "1.0.2";
    private static final long serialVersionUID = 2810758043776215041L;

    public XMLRequest() {
        this("File");
    }

    public XMLRequest(InputStream reader) throws TTException {
        this();
        InputSource input = new InputSource(reader);
        this.buildXML(input, "Input Stream");
    }

    public XMLRequest(String service) {
        if (this.document == null) {
        }
        this.setService(service);
        this.setStatus(0, "");
    }

    public Element addAttachedfile(String localfilename, String filename, String contentType) {
        return this.addAttachedfile(localfilename, filename, contentType, false);
    }

    public Element addAttachedfile(String localfilename, String filename, String contentType, boolean keepfile) {
        assert (localfilename != null) : "Missing localfilename value";
        assert (contentType != null) : "Missing contentType value";
        Element commandElement = this.getCommand();
        Element attachment = this.createElement("attachment");
        attachment.setAttribute(LOCALFILENAME, localfilename);
        if (filename != null) {
            attachment.setAttribute(FILENAME, filename);
        }
        attachment.setAttribute(FILECONTENTYPE, contentType);
        attachment.setAttribute(FILEKEEP, Boolean.toString(keepfile));
        commandElement.appendChild(attachment);
        return attachment;
    }

    public Element buildLog(String logname, ArrayList<String> output) {
        return this.buildLog(logname, output, this.getCommand());
    }

    public Element buildLog(String logname, ArrayList<String> content, Element parentElement) {
        if (content.size() == 0) {
            return null;
        }
        Element logElement = this.createElement("log");
        logElement.setAttribute("name", logname);
        parentElement.appendChild(logElement);
        for (String item : content) {
            Element lineElement = this.createElement("line");
            String value = String.valueOf(item);
            XMLRequest.encodeAttribute(lineElement, value, "text");
            logElement.appendChild(lineElement);
        }
        return logElement;
    }

    public void clearAttached() {
        Element commandElement = this.getCommand();
        commandElement.removeAttribute("attachment");
        commandElement.removeAttribute(LOCALFILENAME);
        commandElement.removeAttribute(FILENAME);
        commandElement.removeAttribute(FILECONTENTYPE);
        NodeList list = commandElement.getElementsByTagName("attachment");
        int ix = 0;
        while (ix < list.getLength()) {
            commandElement.removeChild(list.item(ix));
            ++ix;
        }
    }

    public File getAttachedFile() {
        NodeList list = this.getAttachedFiles();
        if (list.getLength() > 0) {
            File file = null;
            Element fileitem = (Element)list.item(0);
            String filename = fileitem.getAttribute(LOCALFILENAME);
            if (!filename.isEmpty() && !(file = new File(filename)).isFile()) {
                file = null;
            }
            return file;
        }
        return null;
    }

    public boolean hasAttachedFile() {
        return this.getAttachedFiles().getLength() > 0;
    }

    public NodeList getAttachedFiles() {
        return this.getCommand().getElementsByTagName("attachment");
    }

    public Element getCommand() {
        Element service = this.getService();
        if (service != null) {
            return (Element)service.getFirstChild();
        }
        return null;
    }

    public String getCommandName() {
        Element command = this.getCommand();
        if (command == null) {
            return null;
        }
        return command.getTagName();
    }

    protected Document getDocument() {
        return this.document;
    }

    public int getErrorLevel() {
        try {
            return Integer.parseInt(this.getStatus().getAttribute("errorlevel"));
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public String getErrorMessage() {
        return HexUtil.toDisplay(XMLRequest.decodeAttribute(this.getStatus(), "msg"));
    }

    public String getErrorNumber() {
        return this.getStatus().getAttribute("errnumber");
    }

    public Element getFirstMember() {
        NodeList members = this.getMembers();
        if (members != null && members.getLength() > 0) {
            return (Element)members.item(0);
        }
        return null;
    }

    public NodeList getLogs(Element parent) {
        if (parent == null) {
            parent = this.getRoot();
        }
        return parent.getElementsByTagName("log");
    }

    public NodeList getMembers() {
        return this.getCommand().getElementsByTagName("member");
    }

    public String getReasonCode() {
        return HexUtil.toDisplay(XMLRequest.decodeAttribute(this.getStatus(), "reason"));
    }

    protected Element getService() {
        Node node = this.root.getFirstChild();
        if (node instanceof Element) {
            return (Element)node;
        }
        return this.root;
    }

    public Element getStatus() {
        return this.root;
    }

    public Calendar getTimeStamp() {
        return HexUtil.TimeStamp(this.getStatus().getAttribute("time"));
    }

    public void logException(Throwable exception) {
        StringWriter string = new StringWriter();
        PrintWriter stack = new PrintWriter(string);
        exception.printStackTrace(stack);
        ArrayList<String> messages = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new StringReader(string.toString()));
        try {
            String line = reader.readLine();
            while (line != null) {
                messages.add(line);
                line = reader.readLine();
            }
        }
        catch (IOException iOException) {}
        this.buildLog("Stack Trace", messages);
    }

    public List<String> logtoList(Element logElement) {
        NodeList lines = logElement.getElementsByTagName("line");
        int linesize = lines.getLength();
        ArrayList<String> list = new ArrayList<String>(linesize + 1);
        if (linesize > 0) {
            String name = logElement.getAttribute("name");
            String line = String.format("Log Name:%s contents:", name);
            list.add(line);
        }
        int lineix = 0;
        while (lineix < linesize) {
            String text = HexUtil.toDisplay(XMLRequest.decodeAttribute((Element)lines.item(lineix), "text"));
            list.add(text);
            ++lineix;
        }
        return list;
    }

    public String logtoString(Element logElement) {
        List<String> lines = this.logtoList(logElement);
        int linesize = lines.size();
        if (linesize == 0) {
            return "";
        }
        StringBuilder lineString = new StringBuilder(linesize * 132);
        for (String text : lines) {
            lineString.append(text);
            lineString.append(HexUtil.LF);
        }
        lineString.setLength(lineString.length() - HexUtil.LF.length());
        return lineString.toString();
    }

    @Override
    protected void newDocument() {
        super.newDocument();
        ProcessingInstruction inst = this.document.createProcessingInstruction("CA_TestingTools", "Version=1.0.2");
        this.document.appendChild(inst);
        this.setRoot();
        this.document.getDocumentElement().normalize();
    }

    public Element newMember(String name) {
        Element member = this.createElement("member");
        XMLRequest.setName(member, name);
        return (Element)this.getCommand().appendChild(member);
    }

    public Element setAttached(String localfilename, String filename, String contentType) {
        return this.setAttached(localfilename, filename, contentType, false);
    }

    public Element setAttached(String localfilename, String filename, String contentType, boolean keepfile) {
        this.clearAttached();
        Element commandElement = this.getCommand();
        commandElement.setAttribute(LOCALFILENAME, localfilename);
        commandElement.setAttribute(FILENAME, filename);
        return this.addAttachedfile(localfilename, filename, contentType, keepfile);
    }

    public Element setCommand(String cmd) {
        Element service = this.getService();
        Element command = this.getCommand();
        if (command != null) {
            service.removeChild(this.getCommand());
        }
        service.setAttribute("cmd", cmd);
        command = this.document.createElement(cmd);
        return (Element)service.appendChild(command);
    }

    @Override
    protected void setRoot() {
        NodeList list = this.document.getChildNodes();
        int size = list.getLength();
        int index = 0;
        while (index < size) {
            Node node = list.item(index);
            if (node instanceof Element) {
                this.root = (Element)node;
                break;
            }
            ++index;
        }
        if (this.root == null) {
            Element child = this.document.createElement("request");
            this.root = (Element)this.document.appendChild(child);
        }
        XMLRequest.removeEmptyTextNodes(this.root);
        String value = this.root.getAttribute("errorlevel");
        if (value.isEmpty()) {
            this.root.setAttribute("errorlevel", "0");
        }
    }

    protected Element setService(String service) {
        this.getRoot();
        Element servicenode = (Element)this.root.getFirstChild();
        if (servicenode == null) {
            servicenode = this.document.createElement(service);
            servicenode = (Element)this.root.appendChild(servicenode);
        }
        return servicenode;
    }

    public Element setStatus(int errorlevel, String errorMessage) {
        return this.setStatus(errorlevel, errorMessage, null);
    }

    public Element setStatus(int errorlevel, String errorMessage, String reasonCode) {
        return this.setStatus(errorlevel, errorMessage, reasonCode, null);
    }

    public Element setStatus(int errorlevel, String errorMessage, String reasonCode, String ErrorNumber) {
        Element status = this.getStatus();
        status.setAttribute("errorlevel", Integer.toString(errorlevel));
        if (errorMessage == null || errorMessage.isEmpty()) {
            status.removeAttribute("msg");
        } else {
            XMLRequest.encodeAttribute(status, errorMessage, "msg");
        }
        Calendar ts = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        ts.getTime();
        status.setAttribute("time", HexUtil.TimeStampString(ts));
        if (reasonCode == null || reasonCode.isEmpty()) {
            status.removeAttribute("reason");
        } else {
            XMLRequest.encodeAttribute(status, reasonCode, "reason");
        }
        if (ErrorNumber == null || ErrorNumber.isEmpty()) {
            status.removeAttribute("errnumber");
        } else {
            status.setAttribute("errnumber", ErrorNumber);
        }
        return status;
    }
}

