/*
 * Decompiled with CFR 0.152.
 */
package com.ca.testingtools.common;

import com.ca.testingtools.common.IPacketMessage;
import com.ca.testingtools.common.Numbers;
import com.ca.testingtools.common.StatusMessage;
import com.ca.testingtools.common.TTException;
import java.nio.ByteBuffer;
import java.util.Formatter;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class PacketMessage
implements IPacketMessage {
    static final String cacopyright = "Copyright \u00a9 2011 CA";
    Logger log = Logger.getLogger(this.getClass().getName());
    protected boolean disposed = false;
    protected ByteBuffer buffer = null;
    protected short messageID = 0;
    protected short submessageID = 0;
    protected int sequencenumber = 0;
    protected int vardata = 0;
    protected Object object;
    private static final String mask = " %0$02X";
    protected static final int HEADER_SIZE = 10;
    public static final String EMPTY = "";
    public static byte[] EMPTY_8BYTES = new byte[8];

    protected PacketMessage() {
        this.messageID = this._defaultID();
    }

    public PacketMessage(ByteBuffer buffer) throws Exception {
        this();
        this.extractMessage(buffer);
    }

    public PacketMessage(boolean b) {
    }

    public ByteBuffer getBuffer() throws Exception {
        this._initMessage(this._getMessageSize());
        this.buildMessage();
        this._setMessage();
        try {
            ByteBuffer byteBuffer = this.buffer;
            return byteBuffer;
        }
        finally {
            this.buffer = null;
        }
    }

    private void _initMessage(int capacity) {
        if (this.messageID == 0) {
            this.messageID = this._defaultID();
        }
        this.buffer = ByteBuffer.allocate(capacity + 10);
        this.buffer.position(0);
        this.buffer.putInt(0);
        this.buffer.putShort(Numbers.putUShort(this.sequencenumber));
        this.buffer.putShort(this.messageID);
        this.buffer.putShort(this.submessageID);
    }

    private void _setMessage() {
        int position = this.buffer.position();
        this.buffer.putInt(0, position);
        if (this.buffer.remaining() != 0) {
            byte[] tempbuff = new byte[position];
            this.buffer.position(0);
            this.buffer.get(tempbuff);
            this.buffer = ByteBuffer.wrap(tempbuff);
        }
        this.buffer.position(0);
        this.buffer.putShort(6, this.messageID);
        this.buffer.putShort(8, this.submessageID);
    }

    @Override
    public Object getObject() {
        return this.object;
    }

    @Override
    public short getMessageID() {
        return this.messageID;
    }

    public PacketMessage extractMessage(ByteBuffer newbuffer) throws Exception {
        this.buffer = (ByteBuffer)this.buffer.position(0);
        this.object = this.buffer;
        this.buffer.position(0);
        this.buffer.getInt();
        this.sequencenumber = Numbers.getUShort(this.buffer.getShort());
        this.setMessageID(this.buffer.getShort());
        this.submessageID = this.buffer.getShort();
        this.vardata = this.buffer.position();
        this._extractMessage(this.buffer);
        return this;
    }

    protected abstract void _extractMessage(ByteBuffer var1) throws Exception;

    protected abstract void buildMessage() throws Exception;

    @Override
    public short getSubmessageID() {
        return this.submessageID;
    }

    protected abstract String _toString();

    public String toString() {
        String string = this._toString();
        if (string == null) {
            if (this.buffer != null) {
                Formatter fmt = new Formatter();
                byte[] byArray = this.buffer.array();
                int n = byArray.length;
                int n2 = 0;
                while (n2 < n) {
                    byte element = byArray[n2];
                    fmt.format(mask, element);
                    ++n2;
                }
                string = fmt.toString();
            } else {
                string = EMPTY;
            }
        }
        return String.format("%s[%d:%d] %s", this.getClass().getSimpleName(), this.messageID, this.submessageID, string);
    }

    public static short getMessageID(ByteBuffer message) {
        if (message == null) {
            return -1;
        }
        return message.getShort(6);
    }

    @Override
    public int getSequencenumber() {
        return this.sequencenumber;
    }

    @Override
    public void setSequencenumber(int sequencenumber, boolean force) {
        if (this.sequencenumber == 0 || force) {
            this.sequencenumber = sequencenumber;
        }
    }

    @Override
    public void setSequencenumber(int sequencenumber) {
        this.setSequencenumber(sequencenumber, false);
    }

    @Override
    public void setSequencenumber(Object sequencenumber) {
        if (sequencenumber == null) {
            return;
        }
        if (sequencenumber instanceof Number) {
            this.setSequencenumber(((Number)sequencenumber).intValue());
        } else {
            try {
                this.setSequencenumber(Integer.parseInt(sequencenumber.toString()));
            }
            catch (NumberFormatException e) {
                this.log.log(Level.INFO, EMPTY, e);
            }
        }
    }

    protected void setMessageID(short messageID) throws TTException {
        if (!this._checkID(messageID)) {
            throw new TTException(String.valueOf(messageID) + " is invalid Message ID");
        }
        this.messageID = messageID;
    }

    protected boolean _checkID(short messageID) {
        return messageID == this._defaultID();
    }

    @Override
    public void setSubmessageID(short submessageID) throws TTException {
        this.submessageID = submessageID;
    }

    @Override
    public void setSubmessageID(Object submessageID) throws TTException {
        if (submessageID == null) {
            return;
        }
        if (submessageID instanceof Number) {
            this.setSubmessageID(((Number)submessageID).shortValue());
        } else {
            try {
                this.setSubmessageID(Short.parseShort(submessageID.toString()));
            }
            catch (NumberFormatException e) {
                this.log.log(Level.INFO, EMPTY, e);
            }
        }
    }

    @Override
    public void setObject(Object object) {
        this.object = object;
    }

    public StatusMessage statusMessage(short status, String text) {
        return this.statusMessage(status, new String[]{text});
    }

    public StatusMessage statusMessage(short status, String[] messages) {
        StatusMessage msg = new StatusMessage();
        msg.setStatus(status);
        msg.setRequestseqno(this.getSequencenumber());
        msg.setMessages(messages);
        return msg;
    }

    protected abstract int _getMessageSize();

    protected abstract short _defaultID();

    public synchronized boolean isDisposed() {
        return this.disposed;
    }

    public synchronized void setDisposed(boolean disposed) {
        this.disposed = disposed;
    }

    @Override
    public int getSize() {
        return 10 + this._getMessageSize();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.messageID;
        result = 31 * result + this.sequencenumber;
        result = 31 * result + this.submessageID;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IPacketMessage)) {
            return false;
        }
        IPacketMessage other = (IPacketMessage)obj;
        if (this.messageID != other.getMessageID()) {
            return false;
        }
        return this.submessageID == other.getSubmessageID();
    }

    protected byte[] getAvailable(ByteBuffer buffer) {
        return this.getAvailable(buffer, 20);
    }

    protected byte[] getAvailable(ByteBuffer buffer, int size) {
        byte[] result = new byte[size];
        buffer.get(result);
        return result;
    }

    protected byte[] putAvailable() {
        return this.putAvailable(20);
    }

    protected byte[] putAvailable(int size) {
        return new byte[size];
    }
}

