/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.views.pages;

import com.ca.mat.common.table.IMATTableViewer;
import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.managers.AnalysisManager;
import com.ca.mat.managers.Singletons;
import com.ca.mat.views.pages.AnalysisPageBasic;

public class VolumeStatisticsPage
extends AnalysisPageBasic {
    static final String cacopyright = "Copyright \u00a9 2015 CA";
    public static final String ID = "com.ca.mat.pages.volumestatistics";
    private final String SECTION_NAME = "Volume Statistics";
    private String VIEWER_MEMENTO_TYPE = "pages.volumestatistics.viewer";
    public static final String CONTEXT_HELP_ID = "com.ca.mat.help.volumestatistics";

    @Override
    protected void setUpViewer(IMATTableViewer viewer) {
        AnalysisManager manager = Singletons.getAnalysisManager();
        MATTableModel model = manager.getModel(this.dsn, "Volume Statistics", this.type);
        viewer.addColumn("Volume Serial", 5, "Volume Serial", 1);
        viewer.addColumn("Unit Number", 5, "Unit Number", 1);
        viewer.addColumn("Device Type", 5, "Device Type", 1);
        viewer.addColumn("Alloc Count", 3, "Alloc Count", 2);
        viewer.addColumn("Open Count", 3, "Open Count", 2);
        viewer.addColumn("Mounted for", 5, "Mounted for", 1);
        viewer.addColumn("Cache Options", 5, "Cache Options", 1);
        viewer.addColumn("Avg Resp Time", 5, "Avg Resp Time", 3);
        viewer.addColumn("Active Rate", 5, "Active Rate", 3);
        viewer.addColumn("Device Res", 5, "Device Res", 3);
        viewer.addColumn("Device Util", 5, "Device Util", 3);
        viewer.addColumn("Avg IOSQ Time", 5, "Avg IOSQ Time", 3);
        viewer.addColumn("Avg Pend Time", 5, "Avg Pend Time", 3);
        viewer.addColumn("Avg Conn Time", 5, "Avg Conn Time", 3);
        viewer.addColumn("Avg Disc Time", 5, "Avg Disc Time", 3);
        viewer.setDefaultSortColumn(0);
        viewer.setDefaultSortDirection(128);
        this.setModel(model);
    }

    @Override
    public void setType(int type) {
        super.setType(type);
        MATTableModel model = Singletons.getAnalysisManager().getModel(this.dsn, "Volume Statistics", type);
        this.setModel(model);
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String getContextHelpId() {
        return CONTEXT_HELP_ID;
    }

    @Override
    protected String getViewerMementoType() {
        return this.VIEWER_MEMENTO_TYPE;
    }
}

