/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.views.pages;

import com.ca.mat.common.table.IMATTableViewer;
import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.managers.AnalysisManager;
import com.ca.mat.managers.Singletons;
import com.ca.mat.views.pages.AnalysisPageCalculated;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.commands.Command;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;

public class DelayViewPage
extends AnalysisPageCalculated
implements IDoubleClickListener {
    static final String cacopyright = "Copyright \u00a9 2015 CA";
    private static final String sourceClass = DelayViewPage.class.getName();
    Logger log = Logger.getLogger(sourceClass);
    Level baseLevel = this.log.getLevel();
    public static final String ID = "com.ca.mat.pages.delayview";
    public static final String SECTION_NAME = "DelayViewCalculated";
    private static final String VIEWER_MEMENTO_TYPE = "pages.delayview.viewer";
    public String CONTEXT_HELP_ID = "com.ca.mat.help.delayview";
    private static final String AUTONAV = "com.ca.mat.commands.analysis.delayview.autonav";
    private static final String DELAY_LOCATIONS = "com.ca.mat.commands.analysis.delayview.delaylocations";

    @Override
    protected final void setUpViewer(IMATTableViewer viewer) {
        AnalysisManager manager = Singletons.getAnalysisManager();
        MATTableModel model = null;
        model = manager.getModel(this.dsn, SECTION_NAME, this.type);
        viewer.addColumn("Major Category", 7, "Major Category", 1, true, false);
        viewer.addColumn("Minor Category", 8, "Minor Category", 1, true, true);
        viewer.addColumn("Active %", 4, "Active %", 9, true, true);
        viewer.addColumn("Wait %", 4, "Wait %", 9, true, true);
        viewer.addColumn("Total %", 4, "Total %", 9, true, true);
        viewer.setSortColumn(4);
        viewer.setSortDirection(1024);
        Singletons.getViewerSynchronizationManager().addViewer(VIEWER_MEMENTO_TYPE, viewer);
        this.setModel(model);
    }

    @Override
    public void setType(int type) {
        super.setType(type);
        MATTableModel model = Singletons.getAnalysisManager().getModel(this.dsn, SECTION_NAME, type);
        this.setModel(model);
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String getContextHelpId() {
        return this.CONTEXT_HELP_ID;
    }

    @Override
    public void setContextHelpId(String contextHelpId) {
        this.CONTEXT_HELP_ID = contextHelpId;
    }

    @Override
    protected String getViewerMementoType() {
        return VIEWER_MEMENTO_TYPE;
    }

    @Override
    public void doubleClick(DoubleClickEvent event) {
        IHandlerService service = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        ICommandService comm = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command command = comm.getCommand(AUTONAV);
        try {
            if (command.isEnabled()) {
                service.executeCommand(AUTONAV, null);
            } else {
                service.executeCommand(DELAY_LOCATIONS, null);
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, AUTONAV, e);
        }
    }
}

