/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.testers;

import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.managers.Singletons;
import com.ca.mat.rowmodels.DB2ViewRowModel;
import com.ca.mat.rowmodels.IMSViewRowModel;
import com.ca.mat.rowmodels.MQQueueActivityRowModel;
import com.ca.mat.rowmodels.MQViewRowModel;
import com.ca.mat.rowmodels.TaskViewRowModel;
import com.ca.mat.rowmodels.TranViewRowModel;
import com.ca.mat.views.IAnalysisPagePresentation;
import com.ca.mat.views.pages.AnalysisPage;
import com.ca.mat.views.subpages.QueueActivitySubpage;
import java.util.HashMap;
import org.eclipse.core.expressions.PropertyTester;

public class CodeDetailsPropertyTester
extends PropertyTester {
    static final String cacopyright = "Copyright \u00a9 2015 CA";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        boolean result = this.testImpl(receiver, property, args, expectedValue);
        return result;
    }

    public boolean testImpl(Object receiver, String property, Object[] args, Object expectedValue) {
        String dsn = null;
        int type = -1;
        AnalysisPage page = Singletons.getAnalysisManager().getFocusedAnalysisPage();
        if (page == null) {
            return false;
        }
        IAnalysisPagePresentation presentation = page.getPresentation();
        dsn = presentation.getDSN();
        type = presentation.getAnalysisType();
        if (property.equals("hasCodeDetails")) {
            MATTableModel model = Singletons.getAnalysisManager().getModel(dsn, "TimeView", type);
            HashMap<String, Object[]> arguments = new HashMap<String, Object[]>();
            if (receiver instanceof DB2ViewRowModel) {
                DB2ViewRowModel rowModel = (DB2ViewRowModel)receiver;
                arguments = new HashMap();
                arguments.put("DDN", new Object[]{rowModel.getDbrm()});
                arguments.put("Statement", new Object[]{rowModel.getStmtNum()});
            } else if (receiver instanceof IMSViewRowModel) {
                IMSViewRowModel rowModel = (IMSViewRowModel)receiver;
                if (rowModel.getTransactionId() == null) {
                    return false;
                }
                arguments = new HashMap();
                arguments.put("Transaction", new Object[]{rowModel.getTransactionId()});
            } else if (receiver instanceof TranViewRowModel) {
                TranViewRowModel rowModel = (TranViewRowModel)receiver;
                arguments = new HashMap();
                String tranName = rowModel.getTransactionName();
                if (tranName.equals("**N/A**")) {
                    arguments.put("Transaction", new Object[]{""});
                } else {
                    arguments.put("Transaction", new Object[]{tranName});
                }
            } else if (receiver instanceof TaskViewRowModel) {
                TaskViewRowModel rowModel = (TaskViewRowModel)receiver;
                arguments = new HashMap();
                String taskId = rowModel.getTaskId();
                if (taskId.equals("**N/A**")) {
                    arguments.put("Task Id", new Object[]{""});
                } else {
                    arguments.put("Task Id", new Object[]{taskId});
                }
            } else if (receiver instanceof MQViewRowModel) {
                MQViewRowModel rowModel = (MQViewRowModel)receiver;
                arguments = new HashMap();
                arguments.put("Statement", new Object[]{rowModel.getQueueManager()});
            } else if (receiver instanceof MQQueueActivityRowModel && page instanceof QueueActivitySubpage) {
                String manager = ((QueueActivitySubpage)page).getQueueManager();
                MQQueueActivityRowModel rowModel = (MQQueueActivityRowModel)receiver;
                arguments = new HashMap();
                arguments.put("Statement", new Object[]{manager});
                arguments.put("outddn", new Object[]{rowModel.getQQNC8()});
                arguments.put("majnm", new Object[]{rowModel.getRequestType()});
            } else {
                return false;
            }
            if (model == null) {
                return false;
            }
            return model.contains(arguments);
        }
        return false;
    }
}

