/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.rowmodels;

import com.ca.mat.common.table.FilterableTableRow;
import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.common.table.MATTableRow;
import com.ca.mat.rowmodels.IXmlAttrHandler;
import com.ca.mat.utils.HexUtil;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xml.sax.Attributes;

public class PoolDatasetRowModel
extends MATTableRow
implements IXmlAttrHandler,
FilterableTableRow {
    static final String cacopyright = "Copyright \u00a9 2015 CA";
    private static final String sourceClass = PoolDatasetRowModel.class.getName();
    Logger log = Logger.getLogger(sourceClass);
    Level baseLevel = this.log.getLevel();
    public static final String FILTER_POOLKEY = "poolkey";
    private Integer pcisz = null;
    private String pcomp = "";
    private String pddn = "";
    private String pdsn = "";
    private Integer poolbfsz = null;
    private String poolgrp = "";
    private Integer poolid = null;
    private String pooltype = "";
    private String ptype = "";
    private String poolidstr = "";
    private String poolbfszstr;

    public PoolDatasetRowModel() {
        this(null);
    }

    public PoolDatasetRowModel(MATTableModel model) {
        super(model);
    }

    @Override
    public MATTableRow handleAttributes(Attributes attr, MATTableModel model, String modelName) {
        PoolDatasetRowModel result = new PoolDatasetRowModel(model);
        String value = null;
        value = attr.getValue("PCISZ");
        if (value != null) {
            result.pcisz = Integer.valueOf(value);
        }
        if ((value = attr.getValue("PCOMP")) != null) {
            result.pcomp = value.trim();
        }
        if ((value = attr.getValue("PDDN")) != null) {
            result.pddn = value.trim();
        }
        if ((value = attr.getValue("PDSN")) != null) {
            result.pdsn = value.trim();
        }
        if ((value = attr.getValue("POOLBFSZ")) != null) {
            result.poolbfsz = Integer.valueOf(value);
        }
        String s = "00000" + result.poolbfsz.toString();
        s = s.substring(s.length() - 5);
        result.poolbfszstr = s.trim();
        value = attr.getValue("POOLGRP");
        if (value != null) {
            result.poolgrp = value.trim();
        }
        if ((value = attr.getValue("POOLID")) != null) {
            result.poolid = Integer.valueOf(value);
        }
        if ((value = attr.getValue("POOLTYPE")) != null) {
            result.pooltype = HexUtil.spaceFill(value, 4);
        }
        if ((value = attr.getValue("PTYPE")) != null) {
            result.ptype = value.trim();
        }
        s = "000" + result.poolid.toString();
        s = s.substring(s.length() - 3);
        result.poolidstr = s.trim();
        return result;
    }

    @Override
    protected Object[] getArray() {
        return new Object[]{this.pddn, this.pdsn, this.ptype, this.pcomp, this.pcisz};
    }

    public String getDatasetName() {
        if (this.pcomp != null && (this.pcomp.equals("DATA") || this.pcomp.equals("INDEX"))) {
            int x = this.pdsn.lastIndexOf(46);
            return this.pdsn.substring(0, x);
        }
        return this.pdsn;
    }

    public String getDDName() {
        return this.pddn;
    }

    public String getPoolType() {
        return this.pooltype;
    }

    public String getPoolComp() {
        return this.pcomp;
    }

    @Override
    public boolean compliesWithFilter(String fieldName, Object value) {
        if (FILTER_POOLKEY.equals(fieldName)) {
            if (this.pooltype != null && this.poolgrp != null && this.poolidstr != null && this.poolbfsz != null) {
                String s = String.valueOf(this.pooltype) + this.poolgrp + this.poolidstr + this.poolbfszstr + this.pcomp.substring(0, 1);
                return s.equals(value);
            }
            return false;
        }
        throw new IllegalArgumentException(String.format("Field name unknown or null: %s", fieldName));
    }
}

