/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.rowmodels;

import com.ca.mat.common.table.FilterableTableRow;
import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.common.table.MATTableRow;
import com.ca.mat.managers.Singletons;
import com.ca.mat.rowmodels.IXmlAttrHandler;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xml.sax.Attributes;

public class DataViewRowModel
extends MATTableRow
implements IXmlAttrHandler,
FilterableTableRow {
    static final String cacopyright = "Copyright \u00a9 2015 CA";
    private static final String sourceClass = DataViewRowModel.class.getName();
    public static final String DDNAME = "ddndet";
    Logger log = Logger.getLogger(sourceClass);
    Level baseLevel = this.log.getLevel();
    private String ddndet = "";
    private String tdsn = "";
    private Double totpct = null;
    private Integer tblksi = null;
    private Integer tlrecl = null;
    private String trecfm = "";
    private Integer texcp = null;
    private Integer tconn = null;
    private String tintnt = "";
    private String tdsorg = "";
    private String tamtyp = "";
    private Integer tbufno = null;
    private Integer textno = null;
    private String talcsz = "";
    private Integer tprial = null;
    private Integer tsecal = null;
    private Integer tseqno = null;
    private String tucb = "";
    private String tvols = "";
    private Boolean hasDatasetStats;
    private String locationName;

    public DataViewRowModel() {
        this(null, "");
    }

    public DataViewRowModel(MATTableModel dataset, String locationName) {
        super(dataset);
        this.locationName = locationName;
    }

    @Override
    protected Object[] getArray() {
        return new Object[]{this.ddndet, this.tdsn, this.totpct, this.tblksi, this.tlrecl, this.trecfm, this.texcp, this.tconn, this.tintnt, this.tdsorg, this.tamtyp, this.tbufno, this.textno, this.talcsz, this.tprial, this.tsecal, this.tseqno, this.tucb, this.tvols};
    }

    @Override
    public MATTableRow handleAttributes(Attributes attr, MATTableModel dataset, String datasetName) {
        DataViewRowModel result = new DataViewRowModel(dataset, datasetName);
        String value = null;
        value = attr.getValue("DDNDET");
        if (value != null) {
            result.ddndet = value.trim();
        } else {
            value = attr.getValue("TDDN");
            if (value != null) {
                result.ddndet = value.trim();
            }
        }
        value = attr.getValue("TALCSZ");
        if (value != null) {
            result.talcsz = value.trim();
        }
        if ((value = attr.getValue("TAMTYP")) != null) {
            result.tamtyp = value.trim();
        }
        if ((value = attr.getValue("TBLKSI")) != null) {
            result.tblksi = Integer.valueOf(value);
        }
        if ((value = attr.getValue("TBUFNO")) != null) {
            result.tbufno = Integer.valueOf(value);
        }
        if ((value = attr.getValue("TCONN")) != null) {
            result.tconn = Integer.valueOf(value);
        }
        if ((value = attr.getValue("TDSN")) != null) {
            result.tdsn = value.trim();
        }
        if ((value = attr.getValue("TDSORG")) != null) {
            result.tdsorg = value.trim();
        }
        if ((value = attr.getValue("TEXCP")) != null) {
            result.texcp = Integer.valueOf(value);
        }
        if ((value = attr.getValue("TEXTNO")) != null) {
            result.textno = Integer.valueOf(value);
        }
        if ((value = attr.getValue("TINTNT")) != null) {
            result.tintnt = value.trim();
        }
        if ((value = attr.getValue("TLRECL")) != null) {
            result.tlrecl = Integer.valueOf(value);
        }
        if ((value = attr.getValue("TOTPCT")) != null) {
            result.totpct = Double.valueOf(value);
        }
        if ((value = attr.getValue("TPRIAL")) != null) {
            result.tprial = Integer.valueOf(value);
        }
        if ((value = attr.getValue("TRECFM")) != null) {
            result.trecfm = value.trim();
        }
        if ((value = attr.getValue("TSECAL")) != null) {
            result.tsecal = Integer.valueOf(value);
        }
        if ((value = attr.getValue("TSEQNO")) != null) {
            result.tseqno = Integer.valueOf(value);
        }
        if ((value = attr.getValue("TUCB")) != null) {
            result.tucb = value.trim();
        }
        if ((value = attr.getValue("TVOLS")) != null) {
            result.tvols = value.trim();
        }
        return result;
    }

    public String getDatasetName() {
        return this.tdsn;
    }

    public String getDDName() {
        return this.ddndet;
    }

    public String getDSORG() {
        return this.tdsorg;
    }

    public String getRECFM() {
        return this.trecfm;
    }

    public String[] getVolsers() {
        if (this.tvols != "") {
            return this.tvols.split(",");
        }
        return new String[0];
    }

    public boolean hasDatasetStats(String dsn, int type) {
        if (this.hasDatasetStats == null) {
            MATTableModel model = Singletons.getAnalysisManager().getModel(dsn, "Dataset Statistics", type);
            if (model == null) {
                return false;
            }
            HashMap<String, Object[]> arguments = new HashMap<String, Object[]>();
            arguments.put("dsnd", new Object[]{this.getDatasetName()});
            arguments.put("ddnd", new Object[]{this.getDDName()});
            return model.contains(arguments);
        }
        return this.hasDatasetStats;
    }

    @Override
    public boolean compliesWithFilter(String fieldName, Object value) {
        if (DDNAME.equals(fieldName)) {
            return this.ddndet != null && this.ddndet.equals(value);
        }
        throw new IllegalArgumentException(String.format("Field name unknown or null: %s", fieldName));
    }
}

