/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.managers;

import com.ca.mat.MATException;
import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.common.table.MATTableRow;
import com.ca.mat.connect.ListingServerCallback;
import com.ca.mat.connect.MATServer;
import com.ca.mat.connect.ServerCallback;
import com.ca.mat.connect.ServerProxy;
import com.ca.mat.dialogs.RegisterListingDialog;
import com.ca.mat.dialogs.StandbyDialog;
import com.ca.mat.logging.Logging;
import com.ca.mat.managers.Singletons;
import com.ca.mat.rowmodels.ListingContentRowModel;
import com.ca.mat.rowmodels.ListingMetadataRowModel;
import com.ca.mat.rowmodels.tuntables.TunListSRowModel;
import com.ca.mat.views.AnalysisPagePresentationFactory;
import com.ca.mat.views.IAnalysisPagePresentation;
import com.ca.mat.views.IAnalysisSubpagePresentation;
import com.ca.mat.views.subpages.ListingSubpage;
import com.ca.mat.xml.XMLParserUtil;
import com.ca.mat.xml.XMLRequest;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ListingManager {
    static final String cacopyright = "Copyright \u00a9 2015 CA";
    public static final String LANGUAGE_TYPE_ASSEMBLER = "ASM";
    public static final String LANGUAGE_TYPE_COBOL = "COB";
    public static final String LANGUAGE_TYPE_PL1 = "PL1";
    public static final String LANGUAGE_TYPE_PL1E = "PL1E";
    public static final String LANGUAGE_TYPE_IBMC = "IBMC";
    public static final String LANGUAGE_TYPE_NATURAL = "NAT";
    public static final String LANGUAGE_TYPE_FORTRAN = "FOR";
    public static final String LANGUAGE_TYPE_SASC = "SASC";
    public static final String LANGUAGE_TYPE_ADCYCLE = "AD/CYC";
    public static final String LANGUAGE_TYPE_IDEAL = "IDEAL";
    Logger log;
    static Map<String, Map<String, ListingMetadataRowModel>> listingMeta = new HashMap<String, Map<String, ListingMetadataRowModel>>();
    static Map<String, Map<String, MATTableModel>> listingContent = new HashMap<String, Map<String, MATTableModel>>();
    static ConcurrentMap<String, ConcurrentMap<String, Map<Display, ListingSubpage>>> listingPages = new ConcurrentHashMap<String, ConcurrentMap<String, Map<Display, ListingSubpage>>>();
    static Map<String, MATTableModel> listingVerbs = new HashMap<String, MATTableModel>();
    static Map<String, String[]> listingVerbsDescriptors = new HashMap<String, String[]>();
    private WeakReference<Display> displayWeakRef = new WeakReference<Display>(Display.getCurrent());

    public ListingManager() {
        this.log = Logging.getLogger((Display)this.displayWeakRef.get());
    }

    public void startListingRegistration(Shell shell, String module, String csect, String profile, String dsn, String language) {
        if (Singletons.getServerProxy((Display)this.displayWeakRef.get()).getConnectedServer() == null) {
            MessageDialog.openInformation((Shell)shell, (String)"No server connection", (String)"You need to be connected to a server to register a listing.");
            return;
        }
        RegisterListingDialog dialog = null;
        dialog = profile == null && dsn == null ? new RegisterListingDialog(shell) : new RegisterListingDialog(shell, module, csect, profile, dsn, language);
        dialog.open();
    }

    public void startListingRegistrationIdeal(Shell shell, String system, String program, String objectVersion, String sourceVersion, String profile, String dsn) {
        if (Singletons.getServerProxy((Display)this.displayWeakRef.get()).getConnectedServer() == null) {
            MessageDialog.openInformation((Shell)shell, (String)"No server connection", (String)"You need to be connected to a server to register a listing.");
            return;
        }
        RegisterListingDialog dialog = new RegisterListingDialog(shell, system, program, objectVersion, sourceVersion, profile, dsn);
        dialog.open();
    }

    public void showListing(IAnalysisPagePresentation view, String module, String csect, Integer statement, String dsn, Display display) {
        Map<String, MATTableModel> listingSubMap;
        ListingSubpage listingPage;
        Map pagesSubSubMap;
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        if (Singletons.getServerProxy(display).getConnectedServer() == null) {
            MessageDialog.openInformation((Shell)shell, (String)"No server connection", (String)"You need to be connected to a server to retrieve a listing.");
            return;
        }
        ConcurrentMap pagesSubMap = (ConcurrentMap)listingPages.get(dsn);
        if (pagesSubMap != null && (pagesSubSubMap = (Map)pagesSubMap.get(csect)) != null && (listingPage = (ListingSubpage)pagesSubSubMap.get(this.displayWeakRef.get())) != null && !listingPage.getControl().isDisposed()) {
            listingPage.getControl().setFocus();
            listingPage.setSelectedStatement(statement);
            return;
        }
        if (listingContent.get(dsn) != null && (listingSubMap = listingContent.get(dsn)).get(csect) != null) {
            MATTableModel model = listingSubMap.get(csect);
            IAnalysisSubpagePresentation detachedView = AnalysisPagePresentationFactory.showNewDetached(ListingSubpage.class, "", dsn, 1, view, "com.ca.mat.help.listing", model);
            detachedView.setPresentationName(String.format("Listing for CSECT %s", csect));
            if (listingMeta.get(dsn) != null && listingMeta.get(dsn).get(csect) != null) {
                ListingMetadataRowModel metadata = listingMeta.get(dsn).get(csect);
                detachedView.overrideSubtitle(String.format("Csect: %s Language: %s From: %s %s", csect, metadata.getLanguage(), metadata.getDate(), metadata.getTime()));
            } else {
                detachedView.overrideSubtitle(String.format("Listing for CSECT %s", csect));
            }
            ListingSubpage page = (ListingSubpage)detachedView.getCurrentPage();
            if (page != null && page instanceof ListingSubpage) {
                page.setCsect(csect);
                page.setSelectedStatement(statement);
            }
            return;
        }
        StandbyDialog dialog = new StandbyDialog(shell, String.format("Loading listing for csect %s", csect));
        ListingServerCallback callback = new ListingServerCallback(csect, dsn, statement, view, dialog, display);
        Job job = Singletons.getServerProxy(display).downloadListing(module, csect, callback);
        dialog.setJob(job);
        dialog.open();
        Singletons.getServerProxy(display).addDependentDialog(Singletons.getServerProxy(display).getConnectedServer(), dialog);
    }

    public void listingMetadataParsed(MATTableModel model, String dsn) {
        if (model.isEmpty()) {
            return;
        }
        MATTableRow row = model.getRows()[0];
        if (row instanceof ListingMetadataRowModel) {
            ListingMetadataRowModel metadataRow = (ListingMetadataRowModel)row;
            if (listingMeta.get(dsn) == null) {
                listingMeta.put(dsn, new HashMap());
            }
            Map<String, ListingMetadataRowModel> subMap = listingMeta.get(dsn);
            subMap.put(metadataRow.getCsect(), metadataRow);
        }
    }

    public MATTableModel createModel(String dsn, String csect, ListingMetadataRowModel metadataRow, File file) {
        MATTableModel model = new MATTableModel();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            Integer lineNum = 0;
            int loc1 = metadataRow.getLoc1();
            int loc2 = metadataRow.getLoc2();
            String lang = metadataRow.getLanguage();
            while (reader.ready()) {
                model.addRow(this.parseLine(model, lineNum, reader.readLine(), loc1, loc2, lang));
                lineNum = lineNum + 1;
            }
            reader.close();
        }
        catch (FileNotFoundException e) {
            this.log.log(Level.WARNING, "Listing file not found: " + file.getName(), e);
        }
        catch (IOException e) {
            this.log.log(Level.WARNING, "Listing file I/O error: " + file.getName(), e);
        }
        if (listingContent.get(dsn) == null) {
            listingContent.put(dsn, new HashMap());
        }
        Map<String, MATTableModel> subMap = listingContent.get(dsn);
        subMap.put(csect, model);
        Singletons.getTempFilesManager((Display)this.displayWeakRef.get()).unregisterTempFile(file);
        return model;
    }

    private ListingContentRowModel parseLine(MATTableModel model, Integer lineNum, String lineText, int loc1, int loc2, String lang) {
        Integer statement = null;
        if (lineText.length() > loc2) {
            String sub = lineText.substring(loc1, loc2);
            if (lang.equals(LANGUAGE_TYPE_PL1E)) {
                sub = !sub.isEmpty() && sub.contains(".") ? sub.split("\\.")[0] : "";
            }
            if (!sub.isEmpty()) {
                try {
                    statement = Integer.valueOf(sub.trim());
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        return new ListingContentRowModel(model, statement, lineNum, lineText);
    }

    public void addListingPage(String dsn, String csect, ListingSubpage page) {
        listingPages.putIfAbsent(dsn, new ConcurrentHashMap());
        ConcurrentMap subMap = (ConcurrentMap)listingPages.get(dsn);
        subMap.putIfAbsent(csect, new HashMap());
        Map subSubMap = (Map)subMap.get(csect);
        subSubMap.put((Display)this.displayWeakRef.get(), page);
    }

    public ListingMetadataRowModel getMetadata(String dsn, String csect) {
        if (listingMeta.get(dsn) == null) {
            return null;
        }
        return listingMeta.get(dsn).get(csect);
    }

    public void clearCache(String dsn) {
        listingContent.remove(dsn);
        listingPages.remove(dsn);
        listingMeta.remove(dsn);
    }

    public void clearCachedListing(String csect) {
        listingVerbs.remove(csect);
    }

    public void clearCacheAll() {
        listingContent.clear();
        listingPages.clear();
        listingMeta.clear();
        listingVerbs.clear();
    }

    public void listingVerbsParsed(String csect, String compileTime, String size, MATTableModel model) {
        listingVerbs.put(csect, model);
        listingVerbsDescriptors.put(csect, new String[]{compileTime, size});
    }

    public boolean hasListing(String csect) {
        MATTableModel tunlists = Singletons.getAnalysisManager((Display)this.displayWeakRef.get()).getStaticModel("TUNLISTS");
        if (tunlists == null) {
            return false;
        }
        MATTableRow[] mATTableRowArray = tunlists.getRows();
        int n = mATTableRowArray.length;
        int n2 = 0;
        while (n2 < n) {
            MATTableRow row = mATTableRowArray[n2];
            TunListSRowModel tunlistsRow = (TunListSRowModel)row;
            if (csect.equals(tunlistsRow.getCsect())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String getListingCompileDate(String csect) {
        if (listingVerbsDescriptors.containsKey(csect)) {
            return listingVerbsDescriptors.get(csect)[0];
        }
        return null;
    }

    public String getListingSize(String csect) {
        if (listingVerbsDescriptors.containsKey(csect)) {
            return listingVerbsDescriptors.get(csect)[1];
        }
        return null;
    }

    public MATTableModel getVerbs(String csect) {
        MATTableModel tunlists = Singletons.getAnalysisManager((Display)this.displayWeakRef.get()).getStaticModel("TUNLISTS");
        if (tunlists == null) {
            return null;
        }
        MATTableRow[] mATTableRowArray = tunlists.getRows();
        int n = mATTableRowArray.length;
        int n2 = 0;
        while (n2 < n) {
            MATTableRow row = mATTableRowArray[n2];
            TunListSRowModel tunlistsRow = (TunListSRowModel)row;
            if (csect.equals(tunlistsRow.getCsect())) {
                if (listingVerbs.get(csect) != null) {
                    String listingCompileTime = listingVerbsDescriptors.get(csect)[0];
                    String listingSize = listingVerbsDescriptors.get(csect)[1];
                    if (listingCompileTime.equals(tunlistsRow.getCompileDate()) && listingSize.equals(tunlistsRow.getSize())) {
                        return listingVerbs.get(csect);
                    }
                }
                this.requestListing(csect);
                if (listingVerbs.get(csect) != null) {
                    return listingVerbs.get(csect);
                }
            }
            ++n2;
        }
        return null;
    }

    public MATTableModel getVerbsIdeal(String dsn, String program) {
        MATTableModel model = Singletons.getAnalysisManager((Display)this.displayWeakRef.get()).getModel(dsn, "OFFSET STATEMENT MAP", 1);
        HashMap<String, Object[]> args = new HashMap<String, Object[]>();
        args.put("listId", new Object[]{program});
        model = model.filterBy(args);
        return model;
    }

    public void requestListing(String csect) {
        new Object();
        ServerProxy serverProxy = Singletons.getServerProxy((Display)this.displayWeakRef.get());
        ServerCallback callback = new ServerCallback(){

            @Override
            public void processReply(XMLRequest reply, MATServer server) {
                try {
                    XMLParserUtil.parseXMLAttachment(reply, server);
                }
                catch (Exception e) {
                    ListingManager.this.log.log(Level.WARNING, "Failed to read listings from server", e);
                }
            }

            @Override
            public void cancel(XMLRequest reply, MATServer server) {
                ListingManager.this.deleteTempFile(reply);
            }

            @Override
            public boolean abort(XMLRequest reply, MATException e, MATServer server) {
                ListingManager.this.deleteTempFile(reply);
                return false;
            }
        };
        serverProxy.listListing(csect, 2, callback, false, true);
    }

    private void deleteTempFile(XMLRequest reply) {
        if (reply != null && reply.hasAttachedFile()) {
            reply.getAttachedFile().delete();
            Singletons.getTempFilesManager((Display)this.displayWeakRef.get()).unregisterTempFile(reply.getAttachedFile());
        }
    }

    public void retrieveTunlists() {
        final ServerProxy serverProxy = Singletons.getServerProxy((Display)this.displayWeakRef.get());
        ServerCallback callback = new ServerCallback(){

            @Override
            public void processReply(XMLRequest reply, MATServer server) {
                try {
                    XMLParserUtil.parseXMLAttachment(reply, server);
                }
                catch (Exception e) {
                    ListingManager.this.log.log(Level.WARNING, "Failed to read listings from server", e);
                }
            }

            @Override
            public void cancel(XMLRequest reply, MATServer server) {
                serverProxy.disconnect(server);
                ListingManager.this.deleteTempFile(reply);
            }

            @Override
            public boolean abort(XMLRequest reply, MATException e, MATServer server) {
                serverProxy.disconnect(server);
                ListingManager.this.deleteTempFile(reply);
                return false;
            }
        };
        serverProxy.list(5, 2, callback, false);
    }
}

