/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.logging;

import com.ca.mat.managers.Singletons;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.osgi.framework.Bundle;

public class EclipseHandler
extends Handler
implements IPropertyChangeListener {
    static String cacopyright = "Copyright (c) 2011 CA";
    private static final String LOG_LEVEL = "loglevels";
    private ILog log;
    private Bundle bundle;

    public EclipseHandler(Bundle bundle) {
        Level level;
        this.bundle = bundle;
        this.log = Platform.getLog((Bundle)bundle);
        IPersistentPreferenceStore store = Singletons.getUserPreferenceManager().getStoreForUserId();
        String levelStr = store.getString(LOG_LEVEL);
        try {
            level = Level.parse(levelStr);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            level = Level.WARNING;
            store.setDefault(LOG_LEVEL, level.getName());
        }
        this.setLevel(level);
        store.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    @Override
    public void close() throws SecurityException {
    }

    @Override
    public void flush() {
    }

    @Override
    public void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        Level level = record.getLevel();
        if (level == Level.ALL) {
            return;
        }
        int statusInt = level == Level.SEVERE ? 4 : (level == Level.WARNING ? 2 : (level == Level.INFO ? 1 : 0));
        Throwable thrown = record.getThrown();
        record.setThrown(null);
        String message = this.getFormatter().format(record);
        record.setThrown(thrown);
        Status status = new Status(statusInt, this.bundle.getSymbolicName(), level.intValue(), message, thrown);
        record.setLevel(Level.ALL);
        this.log.log((IStatus)status);
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public void propertyChange(PropertyChangeEvent event) {
        String levelStr;
        String property = event.getProperty();
        if (LOG_LEVEL.equals(property) && (levelStr = (String)event.getNewValue()) != null) {
            try {
                Level level = Level.parse(levelStr);
                this.setLevel(level);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }
}

