/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.handlers;

import com.ca.mat.Activator;
import com.ca.mat.connect.MonitorHistoryServerCallback;
import com.ca.mat.connect.ServerProxy;
import com.ca.mat.logging.Logging;
import com.ca.mat.managers.MonitorManager;
import com.ca.mat.managers.Singletons;
import com.ca.mat.views.MonitorHistoryView;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;

public class HistoryRefreshHandler
extends AbstractHandler {
    static final String cacopyright = "Copyright \u00a9 2015 CA";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Display display = HandlerUtil.getActiveShell((ExecutionEvent)event).getDisplay();
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (part instanceof MonitorHistoryView) {
            MonitorHistoryView view = (MonitorHistoryView)part;
            this.openHistory(view.getProfile(), display);
        }
        return null;
    }

    private void openHistory(String profile, Display display) {
        try {
            Activator.plugin.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("com.ca.mat.views.monitorhistoryview", profile, 1);
            MonitorManager mManager = Singletons.getMonitorManager(display);
            if (mManager.getHistoryStatus(profile) != 2) {
                MonitorHistoryServerCallback callback = new MonitorHistoryServerCallback(profile, true);
                ServerProxy serverProxy = Singletons.getServerProxy(display);
                serverProxy.listHistory(profile, 2, callback, true);
                mManager.historyDownloadStarted(profile);
            }
        }
        catch (SWTException e) {
            if ("Device is disposed".equals(e.getMessage())) {
                return;
            }
            throw e;
        }
        catch (PartInitException e) {
            Logger log = Logging.getLogger(Activator.plugin.getWorkbench().getDisplay());
            log.log(Level.WARNING, "Failed to open monitor history view", e);
        }
    }
}

