/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.handlers;

import com.ca.mat.connect.AnalysisServerCallback;
import com.ca.mat.connect.MATServer;
import com.ca.mat.dialogs.StandbyDialog;
import com.ca.mat.logging.Logging;
import com.ca.mat.managers.AnalysisManager;
import com.ca.mat.managers.Singletons;
import com.ca.mat.rowmodels.MonitorHistoryRowModel;
import com.ca.mat.rowmodels.MonitorProfileRowModel;
import com.ca.mat.views.MonitorHistoryView;
import com.ca.mat.views.MonitorTreeView;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class AnalyzeHandler
extends AbstractHandler {
    static final String cacopyright = "Copyright \u00a9 2015 CA";
    Logger log;
    private IPersistentPreferenceStore store = Singletons.getUserPreferenceManager().getStoreForUserId();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection;
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
        IWorkbenchPartSite site = part.getSite();
        event.getCommand().getId();
        site.getShell().getDisplay();
        boolean useLocal = this.store.getBoolean("MAT_USE_LOCAL");
        if (part instanceof MonitorTreeView) {
            selection = (IStructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
            for (Object item : selection) {
                if (!(item instanceof MonitorProfileRowModel)) continue;
                MonitorProfileRowModel profile = (MonitorProfileRowModel)item;
                String profileName = profile.getProfileName();
                String lastRunDSN = profile.getLastRunDsn();
                if (lastRunDSN != null && !lastRunDSN.isEmpty()) {
                    this.analyze(profileName, lastRunDSN, 1, site.getShell(), useLocal);
                    continue;
                }
                this.analyze(profile.getProfileName(), profile.getDsn(), 1, site.getShell(), useLocal);
            }
        }
        if (part instanceof MonitorHistoryView) {
            selection = (IStructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
            for (Object item : selection) {
                MonitorHistoryRowModel history;
                if (!(item instanceof MonitorHistoryRowModel) || (history = (MonitorHistoryRowModel)item) == null) continue;
                this.analyze(history.getProfileName(), history.getDatasetName(), 1, site.getShell(), useLocal);
            }
        }
        return null;
    }

    public void analyze(String profile, String dsn, int analysisType, Shell shell, boolean allowLocal) {
        this.log = Logging.getLogger(shell.getDisplay());
        if (Singletons.getAnalysisManager(shell.getDisplay()).hasRunningJobs(dsn)) {
            MessageDialog.openInformation((Shell)shell, (String)"Analysis already downloading", (String)"Analysis data for this DSN are already being downloaded, please wait.");
            this.log.log(Level.FINE, "Analysis is already downloading " + dsn);
            return;
        }
        AnalysisManager analManager = Singletons.getAnalysisManager(shell.getDisplay());
        Integer hash = analManager.getLocalXMLFileHash(dsn, profile, analysisType);
        int analysisState = analManager.getAnalysisState(dsn, analysisType);
        if (hash != null && analysisState != 2 && allowLocal) {
            this.requestAnalysis(profile, analysisType, dsn, shell, hash);
        } else if (Singletons.getServerProxy(shell.getDisplay()).getConnectedServer() == null) {
            MessageDialog.openInformation((Shell)shell, (String)"Server connection required", (String)"You need to be connected to a CA MAT server to analyze monitor datasets");
        } else if (analysisState != 2) {
            this.requestAnalysis(profile, analysisType, dsn, shell, null);
        } else if (analysisState == 2) {
            IViewReference[] viewRefs;
            boolean openNewView = true;
            IViewReference[] iViewReferenceArray = viewRefs = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getViewReferences();
            int n = viewRefs.length;
            int n2 = 0;
            while (n2 < n) {
                IViewReference viewRef = iViewReferenceArray[n2];
                if (viewRef.getId().equals("com.ca.mat.views.analysistabbedview") && viewRef.getSecondaryId().startsWith(String.valueOf(profile) + "/" + dsn)) {
                    openNewView = MessageDialog.openQuestion((Shell)shell, (String)"Analysis already displayed", (String)"Analysis view for this DSN is already shown. Do you wish to duplicate the analysis view?");
                    break;
                }
                ++n2;
            }
            if (openNewView) {
                Long time = new Date().getTime();
                try {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("com.ca.mat.views.analysistabbedview", String.valueOf(profile) + "/" + dsn + "/" + time, 1);
                }
                catch (PartInitException e) {
                    this.log.log(Level.WARNING, "Failed to open Analysis View for " + dsn, e);
                }
            }
        } else {
            this.requestAnalysis(profile, 1, dsn, shell, null);
        }
    }

    private void requestAnalysis(String profile, int analysisType, String dsn, Shell shell, Integer hash) {
        Display display = Display.getCurrent();
        String text = String.format("Loading analysis for profile %s\nDSN: %s\n", profile, dsn);
        StandbyDialog dialog = new StandbyDialog(shell, text, dsn);
        AnalysisServerCallback callbacks = new AnalysisServerCallback(profile, dsn, analysisType, analysisType == 1, dialog, display);
        Singletons.getServerProxy(shell.getDisplay()).analyzeSingle(dsn, analysisType, callbacks, hash);
        MATServer server = Singletons.getServerProxy(shell.getDisplay()).getConnectedServer();
        Singletons.getServerProxy(shell.getDisplay()).addDependentDialog(server, dialog);
        dialog.open();
    }
}

