/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.tools;

import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.tools.IDebugMessage;
import com.ca.intertest.tools.Numbers;
import com.ca.intertest.tools.ProtsymItem;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class SynchronizeMessage
extends DebugMessage
implements IDebugMessage {
    static String cacopyright = "Copyright \u00a9 2016 CA";
    protected int sessionID;
    protected int date;
    protected int time;
    private ArrayList<SynchProtsym> protsyms = new ArrayList();

    public SynchronizeMessage() {
    }

    public SynchronizeMessage(ByteBuffer buffer) throws Exception {
        super(buffer);
    }

    public ArrayList<SynchProtsym> getProtsyms() {
        return this.protsyms;
    }

    @Override
    protected short _defaultID() {
        return 45;
    }

    @Override
    protected void _extractMessage(ByteBuffer newbuffer) throws Exception {
        this.getProgram(newbuffer);
        this.sessionID = newbuffer.getInt();
        byte[] buf = new byte[3];
        this.buffer.get(buf);
        this.date = buf[2] != 0 ? Numbers.unpack(buf).intValue() : 0;
        buf = new byte[4];
        this.buffer.get(buf);
        this.time = buf[3] != 0 ? Numbers.unpack(buf).intValue() : 0;
        int count = Numbers.getUShort(this.buffer.getShort());
        int i = 0;
        while (i < count) {
            SynchProtsym item = new SynchProtsym(newbuffer);
            if (this.date == 0) {
                item.setMessage("");
            } else {
                int compare = 0;
                if (!item.isExact()) {
                    compare = item.getDate() == this.date ? (item.getTime() == this.time ? 0 : (item.getTime() < this.time ? -1 : 1)) : (item.getDate() < this.date ? -1 : 1);
                }
                switch (compare) {
                    case -1: {
                        item.setMessage("OLDER");
                        break;
                    }
                    case 0: {
                        item.setMessage("MATCH");
                        break;
                    }
                    default: {
                        item.setMessage("LATER");
                    }
                }
            }
            this.protsyms.add(item);
            ++i;
        }
    }

    @Override
    protected int _getMessageSize() {
        int size = 10;
        for (SynchProtsym item : this.protsyms) {
            size += item.getSize();
        }
        return size;
    }

    @Override
    protected String _toString() {
        String format = "%1$s %2$s %3$s";
        String format2 = "[%1s],";
        StringBuilder string = new StringBuilder(60 * this.protsyms.size());
        int length = 0;
        for (SynchProtsym item : this.protsyms) {
            string.append(String.format(format2, item.toString()));
            length = string.length();
        }
        if (length > 0) {
            string.setLength(length - 1);
        }
        return String.format(format, this.getProgram(), HexUtil.TimeStampString(this.date, this.time), string.toString());
    }

    @Override
    protected void buildMessage() throws Exception {
        this.buffer.put(this.putProgram());
        this.buffer.putInt(this.sessionID);
        this.buffer.put(Numbers.pack(this.date, 3));
        this.buffer.put(Numbers.pack(this.time, 4));
        this.buffer.putShort((short)this.protsyms.size());
        for (SynchProtsym item : this.protsyms) {
            this.buffer.put(item.getBuffer());
        }
    }

    public Integer getSessionID() {
        return this.sessionID;
    }

    public void setSessionID(int sessionID) {
        this.sessionID = sessionID;
    }

    public int getDate() {
        return this.date;
    }

    public int getTime() {
        return this.time;
    }

    public boolean isZeroDate() {
        return this.date == 0 && this.time == 0;
    }

    public class SynchProtsym
    extends ProtsymItem {
        public static final String MATCH = "MATCH";
        public static final String LATER = "LATER";
        public static final String OLDER = "OLDER";
        private String message;
        public static final int SYNCHPROTSYM_SIZE = 60;
        private static final byte EXACT = -128;
        byte flag;

        public SynchProtsym(ByteBuffer buffer) {
            this.flag = (byte)(buffer.get() & 0xFFFFFF80);
            this.extractBuffer(buffer);
        }

        @Override
        public ByteBuffer getBuffer() {
            ByteBuffer buffer = ByteBuffer.allocate(this.getSize());
            buffer.put(this.flag);
            buffer.put(super.getBuffer());
            return (ByteBuffer)buffer.position(0);
        }

        @Override
        public int getSize() {
            return 60;
        }

        public void setExact(boolean exact) {
            this.flag = (byte)(exact ? 0 : -128);
        }

        public boolean isExact() {
            return this.flag == -128;
        }

        public String getMessage() {
            return this.message == null ? "" : this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }
    }
}

