/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.tools;

import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.tools.Logger;
import com.ca.intertest.tools.Numbers;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.TimeZone;

public class MemberInfo {
    static String cacopyright = "Copyright \u00a9 2016 CA";
    private static final byte[] ALL_ZERO = new byte[4];
    public static final int COBOL = 32;
    public static final int ASM = 16;
    public static final int PL1 = 128;
    public static final int GT_M_XA = 64;
    public static final int GT_M_DON = 0;
    public static final int GT_M_UPD = 1;
    public static final int GT_M_PUR = 2;
    public static final int GT_M_LNK = 4;
    public static final int GT_M_254 = 8;
    private static final int BUFFER_SIZE = 20;
    protected String member = null;
    protected int time = 0;
    protected int date = 0;
    protected byte langFlag = 0;
    protected byte[] version = ALL_ZERO;

    public MemberInfo() {
    }

    public MemberInfo(ByteBuffer buffer) {
        if (buffer != null) {
            try {
                byte[] buf = new byte[8];
                buffer.get(buf);
                this.member = HexUtil.rightTrim(new String(buf, "IBM1047"));
                this.langFlag = buffer.get();
                this.version = new byte[ALL_ZERO.length];
                buffer.get(this.version);
                buf = new byte[3];
                buffer.get(buf);
                if (buf[2] != 0) {
                    this.date = Numbers.unpack(buf).intValue();
                }
                buf = new byte[4];
                buffer.get(buf);
                if (buf[3] != 0) {
                    this.time = Numbers.unpack(buf).intValue();
                }
            }
            catch (Exception exception) {}
        }
    }

    public MemberInfo(HashMap<String, String> attributes) {
        String value = attributes.get("gt_m_tim");
        if (value != null) {
            try {
                this.time = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                Logger.loggit(e);
            }
        }
        if ((value = attributes.get("gt_m_jul")) != null) {
            try {
                this.date = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                Logger.loggit(e);
            }
        }
        if ((value = attributes.get("gt_m_lang")) != null) {
            try {
                this.langFlag = (byte)Integer.parseInt(value, 16);
            }
            catch (NumberFormatException e) {
                Logger.loggit(e);
            }
        }
        if ((value = attributes.get("version")) != null) {
            this.setVersion(value.getBytes());
        } else {
            value = null;
            switch (this.langFlag & 0xB0) {
                case 32: {
                    value = attributes.get("gt_m_cty");
                    break;
                }
                case 16: {
                    value = attributes.get("gt_m_avr");
                    break;
                }
                case 128: {
                    value = attributes.get("gt_m_avr");
                }
            }
            if (value != null) {
                this.setVersion(value.getBytes());
            }
        }
    }

    public int getDate() {
        return this.date;
    }

    public void setDate(int date) {
        this.date = date;
    }

    public byte getLangFlag() {
        return this.langFlag;
    }

    public void setLangFlag(byte lang) {
        this.langFlag = lang;
    }

    public String getMember() {
        return HexUtil.rightTrim(this.member);
    }

    public void setMember(String member) {
        this.member = member;
    }

    public int getTime() {
        return this.time;
    }

    public void setTime(int time) {
        this.time = time;
    }

    public byte[] getVersion() {
        return this.version;
    }

    public void setVersion(byte[] version) {
        byte[] tmp = HexUtil.sizeBytes(version, 4);
        if (Arrays.equals(tmp, this.version)) {
            this.version = tmp;
        }
    }

    public ByteBuffer getBuffer() {
        ByteBuffer buffer = ByteBuffer.allocate(20);
        if (this.version == null) {
            this.version = ALL_ZERO;
        }
        try {
            String[] items = this.member.split("_");
            if (items.length > 1) {
                buffer.put(HexUtil.spaceFill(items[1], 8).getBytes("IBM1047"));
            } else {
                buffer.put(HexUtil.spaceFill(items[0], 8).getBytes("IBM1047"));
            }
            buffer.put(this.langFlag);
            buffer.put(this.version);
            buffer.put(Numbers.pack(this.date, 3));
            buffer.put(Numbers.pack(this.time, 4));
        }
        catch (Exception exception) {}
        return (ByteBuffer)buffer.position(0);
    }

    public String getLang() {
        return Integer.toHexString(this.langFlag & 0xB0);
    }

    public boolean isUpdateMode() {
        return (this.langFlag & 1) == 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getVersionString() {
        switch (this.langFlag & 0xB0) {
            case 32: {
                return Integer.toString(this.version[0] & 0xFF);
            }
            case 16: {
                try {
                    if (!Arrays.equals(this.version, ALL_ZERO)) return new String(this.version, "IBM1047");
                    return null;
                }
                catch (UnsupportedEncodingException e) {
                    Logger.loggit(e);
                    return null;
                }
            }
            case 128: {
                if (Arrays.equals(this.version, ALL_ZERO)) {
                    return null;
                }
                byte[] ver = new byte[2];
                System.arraycopy(this.version, 0, ver, 0, 2);
                try {
                    long number = Numbers.unpack(ver).longValue();
                    return String.valueOf(Long.toString(number / 100L)) + "." + Long.toString(number % 100L);
                }
                catch (Exception e) {
                    Logger.loggit(e);
                    return null;
                }
            }
        }
        return null;
    }

    public String getXA() {
        return Integer.toHexString(this.langFlag & 0x40);
    }

    public Calendar getTimeStamp() {
        int year;
        if (this.date == 0) {
            return null;
        }
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        int thisyear = calendar.get(1) - 2000;
        year += (year = this.date / 1000) > thisyear && year > 60 ? 1900 : 2000;
        int day = this.date % 1000;
        int hour = this.time / 10000;
        int minute = this.time % 10000 / 100;
        int sec = this.time % 100;
        calendar.clear();
        calendar.set(1, year);
        calendar.set(6, day);
        calendar.set(11, hour);
        calendar.set(12, minute);
        calendar.set(13, sec);
        calendar.set(14, 0);
        return calendar;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.date;
        result = 31 * result + (this.member == null ? 0 : this.member.hashCode());
        result = 31 * result + this.time;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MemberInfo other = (MemberInfo)obj;
        if (this.date != other.date) {
            return false;
        }
        if (this.member == null ? other.member != null : !this.member.equals(other.member)) {
            return false;
        }
        return this.time == other.time;
    }

    public String toString() {
        if (this.member == null) {
            return super.toString();
        }
        return this.member;
    }

    public int getSize() {
        return 20;
    }
}

