/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.tools;

import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.FileName;
import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.tools.Numbers;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class ConvertJCLMessage
extends DebugMessage {
    static String cacopyright = "Copyright \u00a9 2016 CA";
    public static final int PROCLIB_LIMIT = 8;
    public static final int PROCLIB_SIZE = 46;
    private static final int PROCLIB_MAX = 368;
    private String DSN = null;
    private String member = null;
    private ArrayList<String> proclibs = new ArrayList(8);
    private int stepix = 0;
    private String stepname = null;
    private FileName target = null;
    private String userID = null;
    private byte type = 1;

    public String getDSN() {
        return this.DSN;
    }

    public String getMember() {
        return this.member;
    }

    public ArrayList<String> getProclibs() {
        return this.proclibs;
    }

    public int getStepix() {
        return this.stepix;
    }

    public String getStepname() {
        return this.stepname;
    }

    public FileName getTarget() {
        return this.target;
    }

    public byte getType() {
        return this.type;
    }

    public void setDSN(String dsn) {
        this.DSN = dsn;
    }

    public void setMember(String member) {
        this.member = member;
    }

    public void setProclibs(String[] proclibslist) {
        this.proclibs.clear();
        if (proclibslist == null) {
            return;
        }
        String[] stringArray = proclibslist;
        int n = proclibslist.length;
        int n2 = 0;
        while (n2 < n) {
            String additem;
            String item = stringArray[n2];
            if (item != null && this.proclibs.size() < 8 && (additem = item.trim()).length() != 0) {
                this.proclibs.add(additem);
            }
            ++n2;
        }
    }

    public void setStepix(int stepix) {
        this.stepix = stepix;
    }

    public void setStepname(String stepname) {
        this.stepname = stepname;
    }

    public void setTarget(FileName target) {
        this.target = target;
    }

    public void setType(byte type) {
        this.type = type;
    }

    @Override
    protected short _defaultID() {
        return 8;
    }

    @Override
    protected void buildMessage() throws Exception {
        this.buffer.put(this.type);
        this.buffer.put(HexUtil.spaceFill(this.DSN, 44).getBytes("IBM1047"));
        if (this.member == null) {
            this.member = " ";
        }
        this.buffer.put(HexUtil.spaceFill(this.member, 10).getBytes("IBM1047"));
        this.buffer.putShort(Numbers.putUShort(this.stepix));
        this.buffer.put(HexUtil.spaceFill(this.stepname, 8).getBytes("IBM1047"));
        StringBuilder string = new StringBuilder(368);
        for (String item : this.proclibs) {
            if (item.length() <= 0) continue;
            String name = String.format("'%s'", item);
            string.append(HexUtil.spaceFill(name, 46));
        }
        this.buffer.put(HexUtil.spaceFill(string.toString(), 368).getBytes("IBM1047"));
        this.buffer.put(HexUtil.spaceFill(this.userID, 8).getBytes("IBM1047"));
        if (this.target != null) {
            this.buffer.put(this.target.getBuffer());
        } else {
            this.buffer.put((byte)0);
            this.buffer.putShort((short)0);
        }
    }

    @Override
    protected void _extractMessage(ByteBuffer newbuffer) throws Exception {
        this.type = this.buffer.get();
        byte[] bytes = new byte[44];
        this.buffer.get(bytes);
        this.DSN = HexUtil.rightTrim(new String(bytes, "IBM1047"));
        bytes = new byte[10];
        this.buffer.get(bytes);
        this.member = HexUtil.rightTrim(new String(bytes, "IBM1047"));
        this.stepix = Numbers.getUShort(this.buffer.getShort());
        bytes = new byte[8];
        this.buffer.get(bytes);
        this.stepname = HexUtil.rightTrim(new String(bytes, "IBM1047"));
        this.proclibs.clear();
        bytes = new byte[46];
        int i = 0;
        while (i < 8) {
            this.buffer.get(bytes);
            String item = HexUtil.rightTrim(new String(bytes, "IBM1047"));
            if (item.length() > 2 && item.charAt(0) == '\'') {
                String[] items = item.split("'");
                if (items.length > 1) {
                    this.proclibs.add(items[1]);
                }
            } else if (item.length() > 0) {
                this.proclibs.add(item);
            }
            ++i;
        }
        bytes = new byte[8];
        this.buffer.get(bytes);
        this.userID = HexUtil.rightTrim(new String(bytes, "IBM1047"));
        byte type = this.buffer.get();
        int len = Numbers.getUShort(this.buffer.getShort());
        if (len > 0) {
            bytes = new byte[len];
            this.buffer.get(bytes);
            this.target = new FileName(type, HexUtil.rightTrim(new String(bytes, "IBM1047")));
        } else {
            this.target = null;
        }
    }

    @Override
    protected int _getMessageSize() {
        return 1000;
    }

    @Override
    protected String _toString() {
        return null;
    }

    public void setProclibs(String string) {
        this.setProclibs(string.split("[;]+"));
    }

    public String getUserID() {
        return this.userID;
    }

    public void setUserID(String userID) {
        this.userID = userID;
    }
}

