/*
 * Decompiled with CFR 0.152.
 */
package com.ca.intertest.tools;

import com.ca.intertest.tools.DebugMessage;
import com.ca.intertest.tools.HexUtil;
import com.ca.intertest.tools.ITException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class BacktraceLogMessage
extends DebugMessage {
    static String cacopyright = "Copyright \u00a9 2016 CA";
    public static final short CVMO_BATCH = 1;
    public static final short CVMO_CICS = 0;
    protected static final int BATCH_REC_SIZE = 25;
    protected ArrayList<TraceLogRecord> log = null;

    @Override
    protected short _defaultID() {
        return 3;
    }

    @Override
    protected void _extractMessage(ByteBuffer newbuffer) throws Exception {
        TraceLogRecord batchrecord;
        int loop;
        int size = 0;
        size = newbuffer.getInt();
        int offset = newbuffer.getInt();
        this.log = new ArrayList(size);
        if (size == 0) {
            return;
        }
        byte[] buf = new byte[26];
        ByteBuffer recordbuffer = ByteBuffer.wrap(buf);
        int baseoffset = newbuffer.position();
        try {
            newbuffer.position(baseoffset + offset + 25);
            loop = offset / 25 + 1;
            while (loop < size) {
                batchrecord = this.buildBatchRecord(recordbuffer, newbuffer);
                if (batchrecord.program.length() != 0) {
                    this.log.add(batchrecord);
                }
                ++loop;
            }
            newbuffer.position(baseoffset);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        int looplimit = offset / 25;
        try {
            loop = 0;
            while (loop <= looplimit) {
                batchrecord = this.buildBatchRecord(recordbuffer, newbuffer);
                if (batchrecord.program.length() != 0) {
                    this.log.add(batchrecord);
                }
                ++loop;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    private TraceLogRecord buildBatchRecord(ByteBuffer recordbuffer, ByteBuffer newbuffer) throws UnsupportedEncodingException {
        TraceLogRecord batchrecord = new TraceLogRecord();
        byte[] buf = recordbuffer.array();
        newbuffer.get(buf, 1, 25);
        recordbuffer.position(0);
        batchrecord.firstStatement = recordbuffer.getInt();
        batchrecord.number = recordbuffer.get();
        batchrecord.program = HexUtil.rightTrim(new String(buf, 5, 8, "IBM1047"));
        return batchrecord;
    }

    @Override
    protected int _getMessageSize() {
        return 2 + (this.log == null ? 0 : this.log.size() * 25);
    }

    @Override
    protected void buildMessage() throws Exception {
        if (this.log == null) {
            this.buffer.putShort((short)0);
            return;
        }
        this.buffer.put(this.putAvailable());
        switch (this.submessageID) {
            case 0: {
                this.buffer.putShort((short)this.log.size());
                TraceLogRecord[] traceLogRecordArray = this.log.toArray(new TraceLogRecord[this.log.size()]);
                int n = traceLogRecordArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TraceLogRecord record = traceLogRecordArray[n2];
                    if (record.program != null && record.program.trim().length() != 0) {
                        this.buffer.put(HexUtil.spaceFill(record.program.toUpperCase(), 8).getBytes("IBM1047"));
                        this.buffer.putShort((short)record.firstStatement);
                        this.buffer.putShort((short)record.lastStatement);
                    }
                    ++n2;
                }
                break;
            }
            case 1: {
                this.buffer.putInt(this.log.size());
                this.buffer.putInt(0);
                byte[] buf = new byte[26];
                ByteBuffer recordbuffer = ByteBuffer.wrap(buf);
                TraceLogRecord[] traceLogRecordArray = this.log.toArray(new TraceLogRecord[this.log.size()]);
                int n = traceLogRecordArray.length;
                int n3 = 0;
                while (n3 < n) {
                    TraceLogRecord record = traceLogRecordArray[n3];
                    recordbuffer.putInt(record.firstStatement);
                    recordbuffer.put(record.number);
                    if (record.program == null) {
                        record.program = "";
                    }
                    recordbuffer.put(HexUtil.spaceFill(record.program.toUpperCase(), 8).getBytes("IBM1047"));
                    this.buffer.put(buf, 1, 25);
                    ++n3;
                }
                break;
            }
            default: {
                throw new ITException("Invalid submessage");
            }
        }
    }

    @Override
    protected String _toString() {
        return null;
    }

    public TraceLogRecord[] getLogRecords() {
        if (this.log == null || this.log.size() == 0) {
            return new TraceLogRecord[0];
        }
        return this.log.toArray(new TraceLogRecord[this.log.size()]);
    }

    @Override
    public void setSubmessageID(short submessageID) throws ITException {
        if (submessageID != 1 && submessageID != 0) {
            throw new ITException(String.format("Invalid type for %s", this.getClass().getSimpleName()));
        }
        super.setSubmessageID(submessageID);
    }

    public class TraceLogRecord {
        public String program;
        public int firstStatement;
        public int lastStatement;
        public byte number;
        public int linenumber;
        public String text;
    }
}

