/*
 * Decompiled with CFR 0.152.
 */
package com.ca.db2.editor.ui.utils;

import com.ca.db2.editor.common.DataType;
import com.ca.db2.editor.ui.i18n.DWBundle;
import com.ca.db2.editor.ui.model.ChangeEntry;
import com.ca.db2.editor.ui.model.ColumnModel;
import com.ca.db2.editor.ui.model.ObjectIdentity;
import com.ca.db2.editor.ui.utils.CommonUtils;
import com.ca.db2.editor.ui.utils.QueryUtils;
import java.util.List;

public class SQLGenerator {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    public static String METADATA_QUALIFIER_NAME;

    public static synchronized String generateInsertQuery(ObjectIdentity identity, ColumnModel[] columns, Object[] values) {
        StringBuilder builder = new StringBuilder("INSERT INTO");
        builder.append(" " + SQLGenerator.formatCreatorAndObjectName(identity) + " ");
        builder.append("( ");
        int index = 0;
        while (index < columns.length) {
            builder.append(QueryUtils.encloseInDoubleQuotes(QueryUtils.escDoubleQuotes(columns[index].getName())));
            if (index != columns.length - 1) {
                builder.append(", ");
            }
            ++index;
        }
        builder.append(" )");
        builder.append(" VALUES ");
        builder.append("( ");
        index = 0;
        while (index < columns.length) {
            if (SQLGenerator.isNULL(columns[index], values[index])) {
                builder.append(values[index]);
            } else if (SQLGenerator.shouldEncloseInSingleQuotes(columns[index].getColType())) {
                builder.append(QueryUtils.encloseInSingleQuotes(values[index]));
            } else {
                builder.append(values[index]);
            }
            if (index != columns.length - 1) {
                builder.append(", ");
            }
            ++index;
        }
        builder.append(" )");
        return builder.toString();
    }

    public static synchronized String generateUpdateQuery(ObjectIdentity identity, ColumnModel[] columns, Object[] values, ChangeEntry[] entries) {
        StringBuilder builder = new StringBuilder("UPDATE " + SQLGenerator.formatCreatorAndObjectName(identity) + " SET ");
        int index = 0;
        while (index < entries.length) {
            ColumnModel columnModel = columns[entries[index].getColumnIndex()];
            builder.append(QueryUtils.encloseInDoubleQuotes(QueryUtils.escDoubleQuotes(columnModel.getName())));
            builder.append("=");
            if (SQLGenerator.isNULL(columnModel, entries[index].getModifiedValue())) {
                builder.append("NULL");
            } else if (SQLGenerator.shouldEncloseInSingleQuotes(columnModel.getColType())) {
                builder.append("'" + CommonUtils.escapeSpecialCharacters(entries[index].getModifiedValue().toString()) + "'");
            } else {
                builder.append(entries[index].getModifiedValue());
            }
            if (index != entries.length - 1) {
                builder.append(", ");
            }
            values[entries[index].getColumnIndex()] = entries[index].getOriginalValue();
            ++index;
        }
        builder.append(" WHERE ");
        index = 0;
        while (index < values.length) {
            builder.append(QueryUtils.encloseInDoubleQuotes(QueryUtils.escDoubleQuotes(columns[index].getName())));
            if (SQLGenerator.isNULL(columns[index], values[index])) {
                builder.append(" IS NULL");
            } else {
                builder.append("=");
                if (SQLGenerator.shouldEncloseInSingleQuotes(columns[index].getColType())) {
                    builder.append("'" + CommonUtils.escapeSpecialCharacters(values[index].toString()) + "'");
                } else {
                    builder.append(values[index]);
                }
            }
            if (index != values.length - 1) {
                builder.append(" AND ");
            }
            ++index;
        }
        return builder.toString();
    }

    public static synchronized String generateDeleteQuery(ObjectIdentity identity, ColumnModel[] columns, Object[] values, List<ChangeEntry> entries) {
        if (entries != null) {
            int index = 0;
            while (index < entries.size()) {
                values[entries.get((int)index).getColumnIndex()] = entries.get(index).getOriginalValue();
                ++index;
            }
        }
        StringBuilder builder = new StringBuilder("DELETE FROM ");
        builder.append(SQLGenerator.formatCreatorAndObjectName(identity)).append(" ");
        builder.append(" WHERE ");
        int index = 0;
        while (index < values.length) {
            builder.append(QueryUtils.encloseInDoubleQuotes(QueryUtils.escDoubleQuotes(columns[index].getName())));
            if (SQLGenerator.isNULL(columns[index], values[index])) {
                builder.append(" IS NULL");
            } else {
                builder.append("=");
                if (SQLGenerator.shouldEncloseInSingleQuotes(columns[index].getColType())) {
                    builder.append("'" + CommonUtils.escapeSpecialCharacters(values[index].toString()) + "'");
                } else {
                    builder.append(values[index]);
                }
            }
            if (index != values.length - 1) {
                builder.append(" AND ");
            }
            ++index;
        }
        return builder.toString();
    }

    private static boolean shouldEncloseInSingleQuotes(String colType) {
        DataType dataType = DataType.value(colType.trim());
        switch (dataType) {
            case CHAR: 
            case VARCHAR: 
            case DATE: 
            case TIME: 
            case TIMESTMP: 
            case TIMESTZ: {
                return true;
            }
        }
        return false;
    }

    public static boolean isInsertQuery(String SQL) {
        return SQL.startsWith("INSERT INTO");
    }

    private static String objectName(ObjectIdentity identity) {
        return CommonUtils.isSynonym(identity) ? identity.getObjectName() : identity.getSimpleName();
    }

    private static boolean isNULL(ColumnModel column, Object value) {
        return value == null || DWBundle.NULL_VALUE_TEXT.equals(value);
    }

    public static synchronized String generateSelectQuery(ObjectIdentity identity, List<ColumnModel> models) {
        StringBuffer sql = new StringBuffer();
        String completeTableName = SQLGenerator.formatCreatorAndObjectName(identity);
        if (models == null || models.isEmpty()) {
            sql.append("SELECT * FROM ");
        } else {
            sql.append("SELECT ").append(SQLGenerator.getColumnList(models)).append("FROM ");
        }
        sql.append(completeTableName);
        return sql.toString();
    }

    public static String getFormattedObjectName(ObjectIdentity identity) {
        String completeTableName = CommonUtils.isSynonym(identity) ? identity.getObjectName() : identity.getSimpleName();
        return SQLGenerator.formatCreatorAndObjectName(completeTableName);
    }

    private static String formatCreatorAndObjectName(String s) {
        return "\"" + s.replace(".", "\".\"") + "\"";
    }

    public static String formatCreatorAndObjectName(ObjectIdentity o) {
        return String.valueOf(QueryUtils.encloseInDoubleQuotes(o.getCreator())) + "." + QueryUtils.encloseInDoubleQuotes(QueryUtils.escDoubleQuotes(o.getObjectName()));
    }

    private static String getColumnList(List<ColumnModel> models) {
        String columnNames = "";
        for (ColumnModel model : models) {
            String name = model.getName();
            if (name.contains(" ")) {
                name = "\"" + name + "\"";
            }
            if (model.getColType().trim().equals(DataType.FLOAT.toString())) {
                name = "CHAR(" + name + ")" + " AS " + name + " ";
            }
            columnNames = String.valueOf(columnNames) + "\r\n\t " + name + ",";
        }
        if (!columnNames.isEmpty()) {
            columnNames = columnNames.substring(0, columnNames.length() - 1);
        }
        return String.valueOf(columnNames) + "\r\n";
    }
}

