/*
 * Decompiled with CFR 0.152.
 */
package com.ca.db2.editor.ui.utils;

import com.ca.db2.editor.common.DataType;
import com.ca.db2.editor.ui.i18n.DWBundle;
import com.ca.db2.editor.ui.model.ColumnModel;
import com.ca.db2.editor.ui.utils.DateTimeUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.viewers.ICellEditorValidator;

public class DateValidator
implements IInputValidator,
ICellEditorValidator {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    private static final Logger logger = Logger.getLogger(DateValidator.class);
    private String format;
    private Pattern pattern;

    public DateValidator(ColumnModel columnModel, DataType dataType, String format) {
        this.format = format;
        this.pattern = DateTimeUtil.getDatePatternInstance(format);
    }

    public String isValid(String value) {
        if (!value.isEmpty()) {
            return this.isValidDateFormat(value);
        }
        return null;
    }

    private String getErrMsg() {
        String pattern = DateTimeUtil.getDatePattern(this.format);
        return pattern != null ? String.valueOf(this.format) + " (" + pattern + ")" : this.format;
    }

    public String isValid(Object value) {
        return value != null ? this.isValid(value.toString().trim()) : null;
    }

    private String isValidDateFormat(String s) {
        try {
            Matcher matcher = this.pattern.matcher(s);
            if (!matcher.matches()) {
                return DWBundle.bind((String)DWBundle.ERR_MSG_INVALID_DATA_FOR_DATE, (Object)this.getErrMsg());
            }
            return this.validateRanges(matcher);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String validateRanges(Matcher matcher) {
        try {
            int year = this.getYear(matcher);
            int month = this.getMonth(matcher);
            int day = this.getDay(matcher);
            return DateTimeUtil.validateRangesForDate(year, month, day);
        }
        catch (Exception e) {
            logger.error((Object)("Exception occured while validating ranges for date : " + matcher.group()), (Throwable)e);
            return DWBundle.ERR_INVALID_DATE;
        }
    }

    private int getYear(Matcher matcher) {
        String s = null;
        s = DateTimeUtil.isISOformat(this.format) || DateTimeUtil.isJISformat(this.format) ? matcher.group(1) : matcher.group(3);
        return s.trim().length() > 4 ? -1 : Integer.parseInt(s);
    }

    private int getMonth(Matcher matcher) {
        String s = null;
        s = DateTimeUtil.isUSAformat(this.format) ? matcher.group(1) : matcher.group(2);
        return s.trim().length() > 2 ? -1 : Integer.parseInt(s);
    }

    private int getDay(Matcher matcher) {
        String s = null;
        s = DateTimeUtil.isISOformat(this.format) || DateTimeUtil.isJISformat(this.format) ? matcher.group(3) : (DateTimeUtil.isUSAformat(this.format) ? matcher.group(2) : matcher.group(1));
        return s.trim().length() > 2 ? -1 : Integer.parseInt(s);
    }
}

