/*
 * Decompiled with CFR 0.152.
 */
package com.ca.db2.editor.ui.model;

import com.ca.db2.editor.common.DataType;
import com.ca.db2.editor.ui.utils.DataTypeUtils;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement
@XmlType(propOrder={"name", "colType", "length", "scale", "nulls", "defaultValue", "default", "updates"})
public class ColumnModel {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    private static final long serialVersionUID = 7622013644113487086L;
    private String name;
    private Short colNo;
    private String colType;
    private Short length;
    private Short scale;
    private String nulls;
    private String defaultValue;
    private String foreignKey;
    private Integer dataTypeId;
    private String typename;
    private boolean nullable;
    private String default_;
    private String updates;
    private Boolean orderByAsc;
    private boolean visible;
    private int index = 0;
    private String suffix = null;
    int precision = -1;

    public ColumnModel() {
    }

    public ColumnModel(String name) {
        this.setName(name);
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setColType(String colType) {
        this.colType = colType;
    }

    public String getColType() {
        return this.colType;
    }

    public String toString() {
        return "NAME : " + this.getName().trim() + ", TYPE : " + this.colType + ", NULLS : " + this.nulls + ", UPDATES : " + this.updates;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @XmlTransient
    public Short getColNo() {
        return this.colNo;
    }

    public void setColNo(Short colno) {
        this.colNo = colno;
    }

    public Short getLength() {
        return this.length;
    }

    public void setLength(Short length) {
        this.length = length;
    }

    public Short getScale() {
        return this.scale;
    }

    public void setScale(Short scale) {
        this.scale = scale;
    }

    public String getNulls() {
        return this.nulls;
    }

    public void setNulls(String nulls) {
        this.nulls = nulls;
        this.nullable = "Y".equals(nulls.trim());
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @XmlTransient
    public String getForeignKey() {
        return this.foreignKey;
    }

    public void setForeignKey(String foreignKey) {
        this.foreignKey = foreignKey;
    }

    @XmlTransient
    public Integer getDataTypeId() {
        return this.dataTypeId;
    }

    public void setDataTypeId(Integer dataTypeId) {
        this.dataTypeId = dataTypeId;
    }

    @XmlTransient
    public String getTypename() {
        return this.typename;
    }

    public void setTypename(String typename) {
        this.typename = typename;
    }

    public String getDisplayName() {
        return String.valueOf(this.getName()) + this.getSuffix();
    }

    public String getSuffix() {
        if (this.suffix == null) {
            String limit = "";
            DataType dataType = DataType.value(this.getColType().trim());
            if (dataType != null) {
                if (DataTypeUtils.isNumericDataType(dataType) && !DataTypeUtils.isSinglePrecisionFP(dataType) && !DataTypeUtils.isDoublePrecisionFP(dataType)) {
                    limit = " (" + this.getPrecision() + "," + this.scale + ")";
                }
                if (DataTypeUtils.isCharacterStringDataType(dataType)) {
                    limit = " (" + this.getLength() + ")";
                }
                if (dataType == DataType.TIMESTMP || dataType == DataType.TIMESTZ) {
                    limit = " (" + this.scale + ")";
                }
                this.suffix = " [ " + this.getColType().trim() + limit + " ]";
            }
        }
        return this.suffix == null ? "" : this.suffix;
    }

    public Integer getPrecision() {
        DataType dataType;
        if (this.precision == -1 && (dataType = DataType.value(this.getColType().trim())) != null && DataTypeUtils.isNumericDataType(dataType)) {
            if (dataType == DataType.SMALLINT) {
                this.precision = 5;
            } else if (dataType == DataType.INTEGER || dataType == DataType.INTEGER) {
                this.precision = 10;
            } else if (dataType == DataType.BIGINT) {
                this.precision = 19;
            } else if (dataType == DataType.DECIMAL || dataType == DataType.DEC || dataType == DataType.NUMERIC) {
                this.precision = this.getLength().shortValue();
            } else if (dataType == DataType.FLOAT) {
                this.precision = this.getLength() == 8 ? 53 : 24;
            }
        }
        return this.precision;
    }

    public void setDefault(String default_) {
        this.default_ = default_;
    }

    public String getDefault() {
        return this.default_;
    }

    @XmlTransient
    public Boolean getOrderByAsc() {
        return this.orderByAsc;
    }

    public void setOrderByAsc(Boolean orderByAsc) {
        this.orderByAsc = orderByAsc;
    }

    @XmlTransient
    public String getDisplayLabel() {
        return String.valueOf(this.name) + (this.orderByAsc != null ? (this.orderByAsc.booleanValue() ? " (ASC)" : " (DESC)") : "");
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @XmlTransient
    public boolean isVisible() {
        return this.visible;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @XmlTransient
    public Integer getIndex() {
        return this.index;
    }

    public boolean isAutoGeneratedColumn() {
        return "I".equals(this.default_) || "J".equals(this.default_) || "A".equals(this.default_) || "E".equals(this.default_) || "D".equals(this.default_) || "F".equals(this.default_);
    }

    public void setUpdates(String updates) {
        this.updates = updates;
    }

    public String getUpdates() {
        return this.updates;
    }

    public boolean isUpdatable() {
        return "Y".equals(this.updates);
    }

    public boolean compareColumnModels(ColumnModel compMod) {
        if (!this.getColType().equals(compMod.getColType())) {
            return false;
        }
        if (this.getScale() != compMod.getScale()) {
            return false;
        }
        if (!this.getName().equals(compMod.getName())) {
            return false;
        }
        if (!this.getDefault().equals(compMod.getDefault())) {
            return false;
        }
        if (!this.getNulls().equals(compMod.getNulls())) {
            return false;
        }
        if (!this.getUpdates().equals(compMod.getUpdates())) {
            return false;
        }
        if (!this.getDefaultValue().equals(compMod.getDefaultValue())) {
            return false;
        }
        if (this.isVisible() != compMod.isVisible()) {
            return false;
        }
        if (this.isNullable() != compMod.isNullable()) {
            return false;
        }
        if (this.isUpdatable() != compMod.isUpdatable()) {
            return false;
        }
        return this.getLength() == compMod.getLength();
    }
}

