/*
 * Decompiled with CFR 0.152.
 */
package com.ca.db2.editor.ui.actions;

import com.ca.db2.editor.common.FMDB2Exception;
import com.ca.db2.editor.service.DSEUtils;
import com.ca.db2.editor.service.DataSourceHandlerFactory;
import com.ca.db2.editor.service.IDataSourceHandler;
import com.ca.db2.editor.ui.actions.BaseAction;
import com.ca.db2.editor.ui.i18n.DSEBundle;
import com.ca.db2.editor.ui.i18n.MsgDialogBundle;
import com.ca.db2.editor.ui.model.CreatorNode;
import com.ca.db2.editor.ui.model.DBObject;
import com.ca.db2.editor.ui.model.GroupNode;
import com.ca.db2.editor.ui.model.ITreeNode;
import com.ca.db2.editor.ui.model.SubsystemNode;
import com.ca.db2.editor.ui.utils.Images;
import com.ca.db2.editor.ui.widgets.DSEContextMenu;
import com.ca.db2.editor.ui.widgets.DSELoadObjectsDialog;
import com.ca.db2.editor.ui.widgets.DataSourceExplorer;
import com.ca.db2.editor.ui.widgets.MsgDialog;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.swt.custom.BusyIndicator;

class DSELoadObjectsAction
extends BaseAction {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    private DataSourceExplorer explorer;
    private DSELoadObjectsDialog dialog;
    private IDataSourceHandler dataSourceHandler = DataSourceHandlerFactory.getDataSourceHandler();
    private static final Logger logger = Logger.getLogger(DSELoadObjectsAction.class);

    public DSELoadObjectsAction(DataSourceExplorer explorer) {
        super(DSEBundle.LOAD_OBJECTS);
        this.explorer = explorer;
        this.setImageDescriptor(Images.LOAD_OBJECTS);
        this.setId(DSEContextMenu.ACTION.LOAD_OBJECTS.toString());
        this.setAccelerator(13);
    }

    @Override
    public void execute() {
        this.dialog = new DSELoadObjectsDialog(null, this.explorer.getSelectedObject());
        this.dialog.create();
        this.dialog.open();
        if (this.dialog.getReturnCode() == 0) {
            BusyIndicator.showWhile(null, (Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        SubsystemNode node;
                        if (DSEUtils.isSubsystem(DSELoadObjectsAction.this.explorer.getSelectedObject())) {
                            node = (SubsystemNode)DSELoadObjectsAction.this.explorer.getSelectedObject();
                            DSELoadObjectsAction.this.dataSourceHandler.loadDECPProperties(node.getName());
                        } else {
                            node = DSEUtils.isCreator(DSELoadObjectsAction.this.explorer.getSelectedObject()) ? (SubsystemNode)DSELoadObjectsAction.this.explorer.getSelectedObject().getParent() : (SubsystemNode)DSELoadObjectsAction.this.explorer.getSelectedObject().getParent().getParent();
                        }
                        String searchCondition = DSELoadObjectsAction.this.dialog.getSearchCondition();
                        if (searchCondition != null) {
                            List<DBObject> dbObjects = DSELoadObjectsAction.this.dataSourceHandler.getDBObjects(node, searchCondition, DSELoadObjectsAction.this.dialog.getSelectedObjectTypes());
                            if (dbObjects.isEmpty()) {
                                MsgDialog.showInfoDialog(null, DSEBundle.NO_RECORDS_FOUND, DSEBundle.NO_RECORDS_FOUND);
                            } else {
                                DSELoadObjectsAction.this.addObjectsToDSE(dbObjects);
                            }
                        }
                    }
                    catch (FMDB2Exception e) {
                        MsgDialog.showErrorDialog(null, MsgDialogBundle.ERROR_DIALOG_DEFAULT_TITLE, e.getMessage());
                    }
                }
            });
        }
    }

    @Override
    public void updateUI() {
        ITreeNode node = this.explorer.getSelectedObject();
        this.setEnabled(DSEUtils.isSubsystem(node) || DSEUtils.isCreator(node) || DSEUtils.isGroup(node));
    }

    private void addObjectsToDSE(List<DBObject> dbObjects) {
        ITreeNode node = this.explorer.getSelectedObject();
        if (DSEUtils.isSubsystem(node)) {
            this.explorer.addDBObjects(node, dbObjects);
        } else if (DSEUtils.isCreator(node)) {
            if (this.isCreatorModified((CreatorNode)node)) {
                this.explorer.addDBObjects(node.getParent(), dbObjects);
            } else {
                this.explorer.addDBObjects(node, dbObjects);
            }
        } else if (DSEUtils.isGroup(node)) {
            if (this.isCreatorModified((CreatorNode)node.getParent())) {
                this.explorer.addDBObjects(node.getParent().getParent(), dbObjects);
            } else if (this.isTypeModified((GroupNode)node)) {
                this.explorer.addDBObjects(node.getParent(), dbObjects);
            } else {
                this.explorer.addDBObjects(node, dbObjects);
            }
        }
    }

    private boolean isCreatorModified(CreatorNode node) {
        return !node.getName().equals(this.dialog.getCreator());
    }

    private boolean isTypeModified(GroupNode node) {
        return this.dialog.getSelectedObjectTypes().get(0) != node.getType();
    }
}

