/*
 * Decompiled with CFR 0.152.
 */
package com.ca.db2.editor.service;

import com.ca.db2.editor.ui.model.AliasNode;
import com.ca.db2.editor.ui.model.CreatorNode;
import com.ca.db2.editor.ui.model.DBObject;
import com.ca.db2.editor.ui.model.GroupNode;
import com.ca.db2.editor.ui.model.ITreeNode;
import com.ca.db2.editor.ui.model.LparNode;
import com.ca.db2.editor.ui.model.SubsystemNode;
import com.ca.db2.editor.ui.model.SynonymNode;
import com.ca.db2.editor.ui.model.TableNode;
import com.ca.db2.editor.ui.model.ViewNode;
import com.ca.db2.editor.ui.utils.CommonUtils;
import com.ca.db2.editor.ui.utils.DBObjectType;
import com.ca.db2.editor.ui.widgets.DataSourceExplorer;
import com.ca.db2.editor.views.DSEView;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.sql.rowset.CachedRowSet;

public class DSEUtils {
    static final String cacopyright = "Copyright \u00a9 2016 CA";

    public static DSEView getView() {
        return (DSEView)CommonUtils.getView("com.ca.db2.editor.views.DSEView");
    }

    public static DataSourceExplorer getDataSourceExplorer() {
        return DSEUtils.getView().getExplorer();
    }

    public static List<DBObject> prepareDBObjects(String lpar, String ssid, Map<Integer, List<String>> xNetOutput) {
        ArrayList<DBObject> objects = new ArrayList<DBObject>();
        if (xNetOutput != null && !xNetOutput.isEmpty()) {
            for (Map.Entry<Integer, List<String>> entry : xNetOutput.entrySet()) {
                if (!(entry.getValue() instanceof List)) continue;
                List<String> values = entry.getValue();
                String name = values.get(0);
                String creator = values.get(1);
                String type = values.get(2);
                String tbcreator = values.get(3);
                String tbname = values.get(4);
                String location = values.get(5);
                if (DBObjectType.TABLE.getType().equals(type)) {
                    objects.add(new TableNode(lpar, ssid, creator, name, tbcreator, tbname));
                    continue;
                }
                if (DBObjectType.VIEW.getType().equals(type)) {
                    objects.add(new ViewNode(lpar, ssid, creator, name, tbcreator, tbname));
                    continue;
                }
                if (DBObjectType.ALIAS.getType().equals(type)) {
                    if (!location.isEmpty() && !location.startsWith(ssid)) continue;
                    objects.add(new AliasNode(lpar, ssid, creator, name, tbcreator, tbname));
                    continue;
                }
                if (!DBObjectType.SYNONYM.getType().equals(type)) continue;
                objects.add(new SynonymNode(lpar, ssid, creator, name, tbcreator, tbname));
            }
        }
        return objects;
    }

    public static List<DBObject> prepareDBObjects(String lpar, String ssid, CachedRowSet rs) {
        ArrayList<DBObject> objects = new ArrayList<DBObject>();
        try {
            if (rs != null) {
                while (rs.next()) {
                    String name = rs.getString(1);
                    String creator = rs.getString(2);
                    String type = rs.getString(3);
                    String tbcreator = rs.getString(4);
                    String tbname = rs.getString(5);
                    String location = rs.getString(6);
                    if (DBObjectType.TABLE.getType().equals(type)) {
                        objects.add(new TableNode(lpar, ssid, creator, name, tbcreator, tbname));
                        continue;
                    }
                    if (DBObjectType.VIEW.getType().equals(type)) {
                        objects.add(new ViewNode(lpar, ssid, creator, name, tbcreator, tbname));
                        continue;
                    }
                    if (DBObjectType.ALIAS.getType().equals(type)) {
                        if (!location.isEmpty() && !location.startsWith(ssid)) continue;
                        objects.add(new AliasNode(lpar, ssid, creator, name, tbcreator, tbname));
                        continue;
                    }
                    if (!DBObjectType.SYNONYM.getType().equals(type)) continue;
                    objects.add(new SynonymNode(lpar, ssid, creator, name, tbcreator, tbname));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return objects;
    }

    public static Map<String, List<DBObject>> categorizeByCreator(List<? extends DBObject> dbObjects) {
        LinkedHashMap<String, List<DBObject>> map = new LinkedHashMap<String, List<DBObject>>();
        for (DBObject dBObject : dbObjects) {
            String creator = dBObject.getCreator().toUpperCase().trim();
            ArrayList<DBObject> objects = (ArrayList<DBObject>)map.get(creator);
            if (objects == null) {
                objects = new ArrayList<DBObject>();
                map.put(creator, objects);
            }
            objects.add(dBObject);
        }
        return map;
    }

    public static void refreshDSE(LparNode node, List<SubsystemNode> subsystemNodes) {
        DSEUtils.getDataSourceExplorer().refreshOnProfileLoad(node, subsystemNodes);
    }

    public static boolean isLpar(ITreeNode node) {
        return node instanceof LparNode;
    }

    public static boolean isSubsystem(ITreeNode node) {
        return node instanceof SubsystemNode;
    }

    public static boolean isCreator(ITreeNode node) {
        return node instanceof CreatorNode;
    }

    public static boolean isGroup(ITreeNode node) {
        return node instanceof GroupNode;
    }

    public static boolean isTable(ITreeNode node) {
        return node instanceof TableNode;
    }

    public static boolean isView(ITreeNode node) {
        return node instanceof ViewNode;
    }

    public static boolean isAlias(ITreeNode node) {
        return node instanceof AliasNode;
    }

    public static boolean isSynonym(ITreeNode node) {
        return node instanceof SynonymNode;
    }
}

