/*
 * Decompiled with CFR 0.152.
 */
package com.ca.db2.editor;

import Xnet.Xnet;
import Xnet.XnetField;
import Xnet.XnetHeader;
import Xnet.XnetQuery;
import Xnet.XnetRowset;
import Xnet.XnetRowsetColumn;
import Xnet.XnetRowsetSegment;
import com.ca.db2.editor.common.Context;
import com.ca.db2.editor.ui.utils.CommonUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class XnetHandler {
    static final String cacopyright = "Copyright \u00a9 2016 CA";
    private static final Logger logger = Logger.getLogger(XnetHandler.class);
    private Xnet xnet;
    private XnetHeader xHeader;
    private XnetField xField;
    private XnetField cField;
    private XnetQuery xQuery;
    private XnetRowset xRowset;
    private int sequenceNumber;
    private String ipAddress;
    private int connectionPort;
    public static int DEFAULT_QUERY_SEGMENT_INDEX = 0;
    public static int MAX_FETCH_COUNT = 50;
    public static int QueryID = 0;

    private void connect() throws Exception {
        this.xnet = new Xnet(this.ipAddress, this.connectionPort);
    }

    public void disconnect() throws Exception {
        try {
            this.xHeader.addLength(0);
            this.xHeader.setMessageID(XnetHeader.DIR_STOP);
            this.xHeader.setSequenceNumber(++this.sequenceNumber);
            if (this.xnet == null) {
                return;
            }
            this.xnet.writeBytes(this.xHeader, null, null);
            this.xField.setDataLength(0);
            this.xnet.readBytes(this.xHeader, this.xField);
        }
        catch (Exception exception) {
            logger.debug((Object)"Unable to send DIR-STOP");
        }
        this.xnet.closeConnection();
    }

    public XnetHandler(String ip, int port) throws Exception {
        this.ipAddress = ip;
        this.connectionPort = port;
        this.connect();
    }

    public int initializeCommunicationWithDefaultValues(String agentID, String DID) throws Exception {
        if (this.xnet == null) {
            this.connect();
        }
        int returnCode = this.initializeCommunication(agentID, DID);
        this.xField.setFieldType(XnetField.XNF_TYPE_DATA);
        this.xRowset = null;
        return returnCode;
    }

    public int terminateCommunication() {
        int returnCode = 0;
        if (this.sequenceNumber > 1) {
            try {
                if (this.xnet != null) {
                    this.xnet.closeConnection();
                }
            }
            catch (Exception exception) {}
            this.xnet = null;
        }
        return returnCode;
    }

    public int initializeAuthorizedCommunication(String AID, String DID, String uName, String password) throws Exception {
        int returnCode = 0;
        char[] userName = new char[8];
        char[] pass = new char[8];
        int i = 0;
        while (i < 8) {
            try {
                userName[i] = uName.charAt(i);
            }
            catch (Exception exception) {
                userName[i] = '\u0000';
            }
            try {
                pass[i] = password.charAt(i);
            }
            catch (Exception exception) {
                pass[i] = '\u0000';
            }
            ++i;
        }
        if (this.xnet == null) {
            this.connect();
        }
        do {
            this.sequenceNumber = 1;
            this.xHeader = new XnetHeader(this.xnet);
            this.xField = new XnetField(this.xnet);
            this.cField = new XnetField(this.xnet);
            this.xHeader.setAgentID(AID);
            this.xHeader.setMessageID(XnetHeader.DIR_START);
            this.xHeader.setSequenceNumber(this.sequenceNumber);
            this.xHeader.setDirectorID(DID);
            this.cField.setFieldType(XnetField.XNF_TYPE_CREDENTIALS);
            this.cField.setCredentials(userName, pass, 16);
            this.xHeader.addLength(this.cField.getLength());
            this.xnet.writeBytes(this.xHeader, this.cField, null);
            this.xField.setDataLength(0);
            this.xnet.readBytes(this.xHeader, this.xField);
            returnCode = this.xHeader.getReason();
            if (returnCode != 0) {
                this.disconnect();
                break;
            }
            if (!this.xHeader.getMessageID().equals(XnetHeader.R_DIR_STOP)) continue;
            this.disconnect();
            this.connect();
        } while (!this.xHeader.getMessageID().equals(XnetHeader.R_DIR_START));
        this.xRowset = null;
        return returnCode;
    }

    public int initializeCommunication(String agentID, String DID) throws Exception {
        int returnCode = 0;
        if (this.xnet == null) {
            this.connect();
        }
        do {
            this.sequenceNumber = 1;
            this.xHeader = new XnetHeader(this.xnet);
            this.xField = new XnetField(this.xnet);
            this.xHeader.setAgentID(agentID);
            this.xHeader.setMessageID(XnetHeader.DIR_START);
            this.xHeader.setSequenceNumber(this.sequenceNumber);
            this.xHeader.setDirectorID(DID);
            this.xnet.writeBytes(this.xHeader, null, null);
            this.xnet.readBytes(this.xHeader, this.xField);
            returnCode = this.xHeader.getReason();
            if (returnCode != 0 && this.xHeader.getMessageID().equals(XnetHeader.R_DIR_START)) break;
            if (!this.xHeader.getMessageID().equals(XnetHeader.R_DIR_STOP)) continue;
            this.disconnect();
            this.connect();
        } while (!this.xHeader.getMessageID().equals(XnetHeader.R_DIR_START));
        return returnCode;
    }

    public void setFieldType(char type) {
        this.xField.setFieldType(type);
    }

    public void initializeQuery() throws Exception {
        this.xQuery = new XnetQuery(this.xnet);
        this.xQuery.setCCSID(XnetQuery.CCSID_UTF8);
        this.xQuery.setSegmentCount((short)(DEFAULT_QUERY_SEGMENT_INDEX + 1));
        this.xQuery.setStartRow(0, 0);
        this.xQuery.setTotalRows(0, MAX_FETCH_COUNT);
        if (QueryID == 9999) {
            QueryID = 0;
        }
        this.xQuery.setQueryID(++QueryID);
    }

    public void initializeQuery(int fetchCount) throws Exception {
        this.initializeQuery();
        if (fetchCount > 0) {
            this.xQuery.setTotalRows(0, fetchCount);
        }
    }

    public void setParameterCount(int count) {
        this.xQuery.setParameterCount(DEFAULT_QUERY_SEGMENT_INDEX, count);
    }

    public void addParameter(int index, String name, String value) {
        this.xQuery.addParameter(DEFAULT_QUERY_SEGMENT_INDEX, index, name, value);
    }

    public void setSegmentCount(short count) throws Exception {
        this.xQuery.setSegmentCount(count);
    }

    public byte[] getFieldData() {
        byte[] dataArea = null;
        if (this.xField.getLength() > XnetField.XNF_STANDARD_LENGTH) {
            dataArea = this.xField.getData();
        }
        return dataArea;
    }

    public void sendData() throws Exception {
        this.xHeader.setSequenceNumber(++this.sequenceNumber);
        this.xHeader.setMessageID(XnetHeader.DIR_SEND);
        this.xField.setDataLength(this.xQuery.getPacketLength());
        this.xHeader.addLength(this.xField.getLength());
        this.xnet.writeBytes(this.xHeader, this.xField, this.xQuery);
    }

    public void sendDataWithCredentials() throws Exception {
        this.xHeader.setMessageID(XnetHeader.DIR_SEND);
        this.xHeader.setSequenceNumber(++this.sequenceNumber);
        this.xField.setFieldType(XnetField.XNF_TYPE_DATA);
        this.xField.setDataLength(this.xQuery.getPacketLength());
        this.xHeader.addLength(this.xField.getLength() + this.cField.getLength());
        XnetField[] tempField = new XnetField[]{this.xField, this.cField};
        this.xnet.writeMBytes(this.xHeader, tempField, this.xQuery);
    }

    public int recevieData() throws Exception {
        if (this.xRowset == null) {
            this.xRowset = new XnetRowset();
        }
        this.xField.setDataLength(0);
        this.xnet.readBytes(this.xHeader, this.xField, this.xRowset);
        return this.xHeader.getReason();
    }

    public int getStatusErrorCode() {
        return this.xRowset.getStatus().getErrorCode();
    }

    public String getStatusMessage() {
        char[] message = this.xRowset.getStatus().getMessage();
        String str = "";
        int i = 0;
        while (i < message.length) {
            str = message[i] != '\u00c2' ? String.valueOf(str) + message[i] : String.valueOf(str) + "\r\n";
            ++i;
        }
        return str;
    }

    public HashMap<Integer, List<Object>> getProcessedData() throws Exception {
        if (this.xRowset.getSegment(DEFAULT_QUERY_SEGMENT_INDEX).getTotalRows() > 0) {
            return this.xRowset.getSegment(DEFAULT_QUERY_SEGMENT_INDEX).processData();
        }
        return null;
    }

    public String[] getColumnDataAsString(String columnName) throws Exception {
        String[] values = this.xRowset.getValuesForColumnAsString(columnName);
        return values;
    }

    public String[] getAsStringColumnDataWhere(String columnName, String wColumnName, String wColumnData) throws Exception {
        String[] returnValues = this.xRowset.getAsStringColumnDataWhere(columnName, wColumnName, wColumnData);
        return returnValues;
    }

    public XnetQuery getQuery() {
        return this.xQuery;
    }

    public void setTotalRows(int rows) {
        this.xQuery.setTotalRows(DEFAULT_QUERY_SEGMENT_INDEX, rows);
    }

    public List<String> getColumnNames() {
        ArrayList<String> columns = null;
        if (this.xRowset.getSegment(DEFAULT_QUERY_SEGMENT_INDEX).getColumnCount() > 0) {
            columns = new ArrayList<String>();
            XnetRowsetSegment segment = this.xRowset.getSegment(DEFAULT_QUERY_SEGMENT_INDEX);
            int i = 0;
            while (i < segment.getColumnCountSansNullIndicator()) {
                if (segment.getColumnFromNoNullList(i).getName() != null) {
                    columns.add(segment.getColumnFromNoNullList(i).getName());
                }
                ++i;
            }
        }
        return columns;
    }

    public boolean reachedLimit() {
        boolean limit = false;
        if (this.getStatusReasonCode() != 100 && this.xRowset.getSegment(DEFAULT_QUERY_SEGMENT_INDEX).getTotalRows() >= CommonUtils.getPaginatioCount()) {
            limit = true;
        }
        return limit;
    }

    public boolean reachedLimit(int fetchCount) {
        logger.debug((Object)("reachedLimit():Custom fetchCount:" + fetchCount));
        boolean limit = false;
        if (this.getStatusReasonCode() != 100 && this.xRowset.getSegment(DEFAULT_QUERY_SEGMENT_INDEX).getTotalRows() >= fetchCount) {
            limit = true;
        }
        logger.debug((Object)("reachedLimit(): status code from Rowset:" + this.getStatusReasonCode()));
        logger.debug((Object)("reachedLimit(): last obtained row count:" + this.xRowset.getSegment(DEFAULT_QUERY_SEGMENT_INDEX).getTotalRows()));
        logger.debug((Object)("reachedLimit():" + limit));
        return limit;
    }

    public XnetRowsetColumn[] getColumns() {
        XnetRowsetColumn[] columnList = null;
        this.xRowset.getSegment(DEFAULT_QUERY_SEGMENT_INDEX).getColumnCount();
        columnList = this.xRowset.getSegment(DEFAULT_QUERY_SEGMENT_INDEX).getColumnWithNoNull();
        return columnList;
    }

    void dumpRowset() {
        this.xHeader.dumpData();
        this.xRowset.dumpData();
    }

    public int getSegmentCount() {
        return this.xRowset.getSegmentCount();
    }

    public int getStatusReasonCode() {
        return this.xRowset.getStatus().getReasonCode();
    }

    public void setXnetParameters(String system, String ssid, String sql, String sqlid) {
        this.setParameterCount(6);
        this.addParameter(0, "dsSystem", system);
        this.addParameter(1, "dsSSID", ssid);
        this.addParameter(2, "dsFunction", "BPA:EXECSQL");
        this.addParameter(3, "bpaSQL", sql);
        this.addParameter(4, "bpaBPUserId", Context.getInstance().getUserId());
        this.addParameter(5, "dsSQLID", sqlid);
    }
}

