/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.SimpleTimeZone;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.continuations.ContinuationProvider;
import org.apache.cxf.continuations.SuspendedInvocationException;
import org.apache.cxf.interceptor.OneWayProcessorInterceptor;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.AbstractConduit;
import org.apache.cxf.transport.AbstractMultiplexDestination;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.transport.jms.JCATransactionalMessageListenerContainer;
import org.apache.cxf.transport.jms.JMSConfiguration;
import org.apache.cxf.transport.jms.JMSExchangeSender;
import org.apache.cxf.transport.jms.JMSFactory;
import org.apache.cxf.transport.jms.JMSMessageHeadersType;
import org.apache.cxf.transport.jms.JMSOutputStream;
import org.apache.cxf.transport.jms.JMSUtils;
import org.apache.cxf.transport.jms.continuations.JMSContinuation;
import org.apache.cxf.transport.jms.continuations.JMSContinuationProvider;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.wsdl.EndpointReferenceUtils;
import org.springframework.jms.connection.JmsResourceHolder;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;
import org.springframework.jms.core.SessionCallback;
import org.springframework.jms.listener.AbstractMessageListenerContainer;
import org.springframework.jms.listener.SessionAwareMessageListener;
import org.springframework.jms.support.JmsUtils;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class JMSDestination
extends AbstractMultiplexDestination
implements SessionAwareMessageListener,
MessageListener,
JMSExchangeSender {
    private static final Logger LOG = LogUtils.getL7dLogger(JMSDestination.class);
    private JMSConfiguration jmsConfig;
    private Bus bus;
    private EndpointInfo ei;
    private AbstractMessageListenerContainer jmsListener;
    private Collection<JMSContinuation> continuations = new ConcurrentLinkedQueue<JMSContinuation>();

    public JMSDestination(Bus b, EndpointInfo info, JMSConfiguration jmsConfig) {
        super(b, JMSDestination.getTargetReference(info, b), info);
        this.bus = b;
        this.ei = info;
        this.jmsConfig = jmsConfig;
        info.setProperty(OneWayProcessorInterceptor.USE_ORIGINAL_THREAD, Boolean.TRUE);
    }

    protected Conduit getInbuiltBackChannel(org.apache.cxf.message.Message inMessage) {
        EndpointReferenceType anon = EndpointReferenceUtils.getAnonymousEndpointReference();
        return new BackChannelConduit(this, anon, inMessage);
    }

    public void activate() {
        this.getLogger().log(Level.FINE, "JMSDestination activate().... ");
        String name = this.endpointInfo.getName().toString() + ".jms-destination";
        org.apache.cxf.common.i18n.Message msg = new org.apache.cxf.common.i18n.Message("INSUFFICIENT_CONFIGURATION_DESTINATION", LOG, name);
        this.jmsConfig.ensureProperlyConfigured(msg);
        this.jmsListener = JMSFactory.createJmsListener(this.ei, this.jmsConfig, this, this.jmsConfig.getTargetDestination());
    }

    public void deactivate() {
        if (this.jmsListener != null) {
            this.jmsListener.shutdown();
            this.jmsConfig.destroyWrappedConnectionFactory();
        }
    }

    public void shutdown() {
        this.getLogger().log(Level.FINE, "JMSDestination shutdown()");
        this.deactivate();
    }

    private Destination resolveDestinationName(final JmsTemplate jmsTemplate, final String name) {
        SessionCallback sc = new SessionCallback(){

            public Object doInJms(Session session) throws JMSException {
                DestinationResolver resolv = jmsTemplate.getDestinationResolver();
                return resolv.resolveDestinationName(session, name, JMSDestination.this.jmsConfig.isPubSubDomain());
            }
        };
        return (Destination)jmsTemplate.execute(sc);
    }

    public Destination getReplyToDestination(JmsTemplate jmsTemplate, org.apache.cxf.message.Message inMessage) throws JMSException {
        Message message = (Message)inMessage.get("org.apache.cxf.jms.request.message");
        String replyToName = (String)inMessage.get("org.apache.cxf.jms.server.replyto");
        if (replyToName != null) {
            return this.resolveDestinationName(jmsTemplate, replyToName);
        }
        if (message.getJMSReplyTo() != null) {
            return message.getJMSReplyTo();
        }
        if (!StringUtils.isEmpty(this.jmsConfig.getReplyDestination())) {
            return this.resolveDestinationName(jmsTemplate, this.jmsConfig.getReplyDestination());
        }
        throw new RuntimeException("No replyTo destination set on request message or cxf message");
    }

    public String determineCorrelationID(Message request) throws JMSException {
        String correlationID = request.getJMSCorrelationID();
        if (correlationID == null || "".equals(correlationID)) {
            correlationID = request.getJMSMessageID();
        }
        return correlationID;
    }

    public void onMessage(Message message) {
        this.onMessage(message, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message, Session session) {
        try {
            PlatformTransactionManager m;
            this.getLogger().log(Level.FINE, "server received request: ", message);
            org.apache.cxf.message.Message inMessage = new MessageImpl();
            JMSUtils.populateIncomingContext(message, inMessage, "org.apache.cxf.jms.server.request.headers", this.jmsConfig);
            JMSUtils.retrieveAndSetPayload(inMessage, message, (String)inMessage.get(org.apache.cxf.message.Message.ENCODING));
            inMessage.put("org.apache.cxf.jms.server.response.headers", new JMSMessageHeadersType());
            inMessage.put("org.apache.cxf.jms.request.message", message);
            ((MessageImpl)inMessage).setDestination(this);
            if (this.jmsConfig.getMaxSuspendedContinuations() != 0) {
                inMessage.put(ContinuationProvider.class.getName(), new JMSContinuationProvider(this.bus, inMessage, this.incomingObserver, this.continuations, this.jmsListener, this.jmsConfig));
            }
            BusFactory.setThreadDefaultBus(this.bus);
            Map<Class<?>, ?> mp = JCATransactionalMessageListenerContainer.ENDPOINT_LOCAL.get();
            if (mp != null) {
                for (Map.Entry<Class<?>, ?> ent : mp.entrySet()) {
                    inMessage.setContent(ent.getKey(), ent.getValue());
                }
                JCATransactionalMessageListenerContainer.ENDPOINT_LOCAL.remove();
            }
            this.incomingObserver.onMessage(inMessage);
            if (inMessage.getExchange() != null && inMessage.getExchange().getInMessage() != null) {
                inMessage = inMessage.getExchange().getInMessage();
            }
            if (inMessage.getContent(Exception.class) != null && session != null && (m = this.jmsConfig.getTransactionManager()) != null) {
                boolean trans;
                TransactionStatus status = m.getTransaction(null);
                JmsResourceHolder resourceHolder = (JmsResourceHolder)TransactionSynchronizationManager.getResource((Object)this.jmsConfig.getConnectionFactory());
                boolean bl = trans = resourceHolder == null || !resourceHolder.containsSession(session);
                if (status != null && !status.isCompleted() && trans) {
                    Exception ex = inMessage.getContent(Exception.class);
                    if (ex.getCause() instanceof RuntimeException) {
                        throw (RuntimeException)ex.getCause();
                    }
                    throw new RuntimeException(ex);
                }
            }
        }
        catch (SuspendedInvocationException ex) {
            this.getLogger().log(Level.FINE, "Request message has been suspended");
        }
        catch (UnsupportedEncodingException ex) {
            this.getLogger().log(Level.WARNING, "can't get the right encoding information. " + ex);
        }
        finally {
            BusFactory.setThreadDefaultBus(null);
        }
    }

    public void sendExchange(Exchange exchange, final Object replyObj) {
        if (exchange.isOneWay()) {
            return;
        }
        org.apache.cxf.message.Message inMessage = exchange.getInMessage();
        final org.apache.cxf.message.Message outMessage = exchange.getOutMessage();
        if (this.jmsConfig.isPubSubDomain()) {
            this.getLogger().log(Level.WARNING, "discarding reply for non-oneway invocation ", "with 'topic' destinationStyle");
            return;
        }
        try {
            final JMSMessageHeadersType messageProperties = (JMSMessageHeadersType)outMessage.get("org.apache.cxf.jms.server.response.headers");
            JMSMessageHeadersType inMessageProperties = (JMSMessageHeadersType)inMessage.get("org.apache.cxf.jms.server.request.headers");
            JMSUtils.initResponseMessageProperties(messageProperties, inMessageProperties);
            JmsTemplate jmsTemplate = JMSFactory.createJmsTemplate(this.jmsConfig, messageProperties);
            final Message request = (Message)inMessage.get("org.apache.cxf.jms.request.message");
            final String msgType = request instanceof TextMessage ? "text" : (request instanceof BytesMessage ? "byte" : "binary");
            Destination replyTo = this.getReplyToDestination(jmsTemplate, inMessage);
            if (request.getJMSExpiration() > 0L) {
                SimpleTimeZone tz = new SimpleTimeZone(0, "GMT");
                GregorianCalendar cal = new GregorianCalendar(tz);
                long timeToLive = request.getJMSExpiration() - cal.getTimeInMillis();
                if (timeToLive < 0L) {
                    this.getLogger().log(Level.INFO, "Message time to live is already expired skipping response.");
                    return;
                }
            }
            this.getLogger().log(Level.FINE, "send out the message!");
            jmsTemplate.send(replyTo, new MessageCreator(){

                public Message createMessage(Session session) throws JMSException {
                    Message reply = JMSUtils.createAndSetPayload(replyObj, session, msgType);
                    reply.setJMSCorrelationID(JMSDestination.this.determineCorrelationID(request));
                    JMSUtils.prepareJMSProperties(messageProperties, outMessage, JMSDestination.this.jmsConfig);
                    JMSUtils.setJMSProperties(reply, messageProperties);
                    LOG.log(Level.FINE, "server sending reply: ", reply);
                    return reply;
                }
            });
        }
        catch (JMSException ex) {
            JmsUtils.convertJmsAccessException((JMSException)ex);
        }
    }

    protected Logger getLogger() {
        return LOG;
    }

    public JMSConfiguration getJmsConfig() {
        return this.jmsConfig;
    }

    public void setJmsConfig(JMSConfiguration jmsConfig) {
        this.jmsConfig = jmsConfig;
    }

    protected class BackChannelConduit
    extends AbstractConduit {
        protected org.apache.cxf.message.Message inMessage;
        private JMSExchangeSender sender;

        BackChannelConduit(JMSExchangeSender sender, EndpointReferenceType ref, org.apache.cxf.message.Message message) {
            super(ref);
            this.inMessage = message;
            this.sender = sender;
        }

        public void setMessageObserver(MessageObserver observer) {
        }

        public void prepare(org.apache.cxf.message.Message message) throws IOException {
            Message jmsMessage = (Message)this.inMessage.get("org.apache.cxf.jms.request.message");
            message.put("org.apache.cxf.jms.request.message", jmsMessage);
            if (!message.containsKey("org.apache.cxf.jms.server.response.headers") && this.inMessage.containsKey("org.apache.cxf.jms.server.response.headers")) {
                message.put("org.apache.cxf.jms.server.response.headers", this.inMessage.get("org.apache.cxf.jms.server.response.headers"));
            }
            Exchange exchange = this.inMessage.getExchange();
            exchange.setOutMessage(message);
            message.setContent(OutputStream.class, new JMSOutputStream(this.sender, exchange, jmsMessage instanceof TextMessage));
        }

        protected Logger getLogger() {
            return LOG;
        }
    }
}

