/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.views;

import com.ca.mat.common.table.IMATTableViewer;
import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.common.table.MATTableViewerFactory;
import com.ca.mat.connect.MATServer;
import com.ca.mat.logging.Logging;
import com.ca.mat.managers.Singletons;
import com.ca.mat.rowmodels.LogViewRowModel;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;

public class LogView
extends ViewPart
implements IDoubleClickListener {
    public static final String ID = "com.ca.mat.views.logview";
    public static final String CONTEXT_HELP_ID = "...";
    public static final String VIEWER_MEMENTO_TYPE = "com.ca.mat.logview.viewer";
    static final String DETAIL = "com.ca.mat.commands.logdetail";
    IMATTableViewer viewer;
    MATTableModel logRecords;
    String currentUser;

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        this.viewer = MATTableViewerFactory.createNew(parent);
        this.viewer.addColumn("Severity", 5, null, 1);
        this.viewer.addColumn("Message", 9, null, 1);
        this.viewer.addColumn("Time", 7, null, 5);
        this.viewer.setSortColumn(2);
        this.viewer.setSortDirection(1024);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.viewer.getControl(), CONTEXT_HELP_ID);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        Singletons.getViewerSynchronizationManager().addViewer(VIEWER_MEMENTO_TYPE, this.viewer);
        this.viewer.refresh();
        MenuManager menuMgr = new MenuManager();
        menuMgr.add((IContributionItem)new GroupMarker("additions"));
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
        Control control = this.viewer.getControl();
        Menu menu = menuMgr.createContextMenu(control);
        menuMgr.setRemoveAllWhenShown(true);
        control.setMenu(menu);
        this.logRecords = new MATTableModel();
        this.viewer.setCATableModel(this.logRecords);
        this.viewer.addDoubleClickListener(this);
        MATServer server = Singletons.getServerProxy().getConnectedServer();
        if (server != null) {
            this.currentUser = server.getUser();
            Logging.addLogView(this, this.currentUser);
        }
    }

    public void dispose() {
        Logging.removeLogView(this, this.currentUser);
    }

    public void setFocus() {
    }

    public void displayLogRecords(List<LogRecord> records) {
        this.logRecords.clearRows();
        for (LogRecord record : records) {
            int n;
            int n2;
            Object[] objectArray;
            ArrayList<String> detail = new ArrayList<String>();
            if (record.getThrown() != null) {
                objectArray = record.getThrown().getStackTrace();
                n2 = objectArray.length;
                n = 0;
                while (n < n2) {
                    Object element = objectArray[n];
                    detail.add(((StackTraceElement)element).toString());
                    ++n;
                }
                detail.add("");
            }
            if (record.getParameters() != null) {
                objectArray = record.getParameters();
                n2 = objectArray.length;
                n = 0;
                while (n < n2) {
                    Object param = objectArray[n];
                    if (param != null) {
                        detail.add(param.toString());
                    }
                    ++n;
                }
            }
            LogViewRowModel row = new LogViewRowModel(this.logRecords, record.getLevel().getName(), record.getMessage(), new Date(record.getMillis()), detail);
            this.logRecords.addRow(row);
        }
        this.viewer.getTable().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                LogView.this.viewer.setCATableModel(LogView.this.logRecords);
            }
        });
    }

    public void displayLogRecord(LogRecord record) {
        int n;
        int n2;
        Object[] objectArray;
        ArrayList<String> detail = new ArrayList<String>();
        if (record.getThrown() != null) {
            objectArray = record.getThrown().getStackTrace();
            n2 = objectArray.length;
            n = 0;
            while (n < n2) {
                Object element = objectArray[n];
                detail.add(((StackTraceElement)element).toString());
                ++n;
            }
            detail.add("");
        }
        if (record.getParameters() != null) {
            objectArray = record.getParameters();
            n2 = objectArray.length;
            n = 0;
            while (n < n2) {
                Object param = objectArray[n];
                if (param != null) {
                    detail.add(param.toString());
                }
                ++n;
            }
        }
        final LogViewRowModel row = new LogViewRowModel(this.logRecords, record.getLevel().getName(), record.getMessage(), new Date(record.getMillis()), detail);
        if (!this.viewer.getTable().isDisposed()) {
            this.viewer.getTable().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    LogView.this.logRecords.addRow(row);
                    LogView.this.viewer.setCATableModel(LogView.this.logRecords);
                }
            });
        }
    }

    public void doubleClick(DoubleClickEvent event) {
        IHandlerService service = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        try {
            service.executeCommand(DETAIL, null);
        }
        catch (Exception e) {
            Logger log = Logging.getLogger(Display.getCurrent());
            log.log(Level.FINE, "Autonavigation failed", e);
        }
    }

    public LogViewRowModel getPrevious() {
        Table table = this.viewer.getTable();
        int index = table.getSelectionIndex();
        if (index == -1) {
            return null;
        }
        if (index > 0) {
            --index;
        }
        table.select(index);
        if (this.viewer.getSelectedRows() != null && this.viewer.getSelectedRows().length > 0) {
            return (LogViewRowModel)this.viewer.getSelectedRows()[0];
        }
        return null;
    }

    public LogViewRowModel getNext() {
        Table table = this.viewer.getTable();
        int index = table.getSelectionIndex();
        if (index == -1) {
            return null;
        }
        if (index < table.getItemCount() - 1) {
            ++index;
        }
        table.select(index);
        if (this.viewer.getSelectedRows() != null && this.viewer.getSelectedRows().length > 0) {
            return (LogViewRowModel)this.viewer.getSelectedRows()[0];
        }
        return null;
    }

    public void clear() {
        this.logRecords.clearRows();
        this.viewer.setCATableModel(this.logRecords);
    }

    public boolean hasRecords() {
        return !this.logRecords.isEmpty();
    }
}

