/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.utils;

import com.ca.mat.utils.HexUtil;
import com.ca.mat.xml.XMLDocument;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class TTSimpleFormatter
extends Formatter {
    static final String cacopyright = "Copyright \u00a9 2011 CA";
    protected static final String FULL_TIME_FORMAT = "yyyy'/'MM'/'dd HH:mm:ss";
    protected static final DateFormat dflocaltime = new SimpleDateFormat("yyyy'/'MM'/'dd HH:mm:ss");
    protected static final String LF = System.getProperty("line.separator");
    protected static final String SOURCE = "><";
    protected static final String REPLACEMENT = ">" + LF + "<";
    protected static final String padding;
    private static final int MAXMSG;

    static {
        char[] fill = new char[80];
        Arrays.fill(fill, ' ');
        padding = new String(fill);
        Integer value = Integer.getInteger("com.ca.testingtools.common.formatter.maxmsglength");
        MAXMSG = value == null ? 2048 : (value == 0 ? Integer.MAX_VALUE : value);
    }

    @Override
    public String format(LogRecord record) {
        StringBuilder message = new StringBuilder();
        message.append(dflocaltime.format(record.getMillis()));
        message.append(' ');
        String msg = this.formatMessage(record);
        message.append(record.getLevel().getLocalizedName().charAt(0));
        message.append(": ");
        message.append(msg);
        int size = message.length();
        if (size < 79) {
            message.append(padding.substring(0, 79 - size));
        }
        message.append(" <=");
        if (record.getSourceClassName() != null) {
            message.append(record.getSourceClassName());
        } else {
            message.append(record.getLoggerName());
        }
        if (record.getSourceMethodName() != null) {
            message.append(' ');
            message.append(record.getSourceMethodName());
        }
        message.append(LF);
        if (record.getThrown() != null) {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                record.getThrown().printStackTrace(pw);
                pw.close();
                message.append(sw.toString());
            }
            catch (Exception exception) {}
        }
        return message.toString();
    }

    @Override
    public synchronized String formatMessage(LogRecord record) {
        Object[] parms = record.getParameters();
        if (parms != null && parms.length == 1) {
            if (parms[0] instanceof byte[]) {
                return this.formatBytes(record);
            }
            if (parms[0] instanceof XMLDocument) {
                return this.formatXML(record);
            }
        }
        return super.formatMessage(record);
    }

    private String formatXML(LogRecord record) {
        StringWriter writer = new StringWriter(4096);
        String msg = record.getMessage();
        if (msg.trim().length() != 0) {
            writer.append(msg);
            writer.append(LF);
        }
        XMLDocument xml = (XMLDocument)record.getParameters()[0];
        try {
            File file = File.createTempFile("CAVH", ".xml");
            xml.toFile(file.getAbsolutePath(), true);
            long length = file.length();
            int size = (int)Math.min(length, (long)MAXMSG);
            String oversizemsg = (long)size < length ? String.format("\nText truncated to %d characters\n", MAXMSG) : "";
            byte[] buf = new byte[size];
            FileInputStream is = new FileInputStream(file);
            ((InputStream)is).read(buf);
            ((InputStream)is).close();
            file.delete();
            writer.append(new String(buf));
            writer.append(oversizemsg);
        }
        catch (Exception e) {
            writer.append(HexUtil.getErrorText(e));
        }
        return writer.toString();
    }

    private String formatBytes(LogRecord record) {
        byte[] bytes = (byte[])record.getParameters()[0];
        return HexUtil.toHexDump(bytes, record.getMessage(), 32, MAXMSG);
    }
}

