/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.testers;

import com.ca.mat.managers.Singletons;
import com.ca.mat.rowmodels.MonitorHistoryRowModel;
import com.ca.mat.rowmodels.MonitorProfileRowModel;
import com.ca.mat.views.MonitorHistoryView;
import com.ca.mat.views.MonitorTreeView;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.part.ViewPart;

public class TreePropertyTester
extends PropertyTester {
    static final String cacopyright = "Copyright \u00a9 2015 CA";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        Object selected;
        IStructuredSelection s;
        ViewPart view;
        if (receiver instanceof MonitorTreeView) {
            view = (MonitorTreeView)receiver;
            if (property.equals("isTunprofReady")) {
                return Singletons.getMonitorManager().getTunProfile() != null;
            }
            if (property.equals("isServerSelected")) {
                return view.getSelectedServer() != null;
            }
            if (property.equals("isServerConnected")) {
                if (view.getSelectedServer() == null) {
                    return false;
                }
                return view.getSelectedServer() == Singletons.getServerProxy().getConnectedServer();
            }
            if (property.equals("isAnyServerConnected")) {
                return Singletons.getServerProxy().getConnectedServer() != null;
            }
        }
        if (receiver instanceof MonitorHistoryView) {
            view = (MonitorHistoryView)receiver;
            if (!(view.getSelection() instanceof IStructuredSelection) || view.getSelection().isEmpty()) {
                return false;
            }
            IStructuredSelection s2 = (IStructuredSelection)view.getSelection();
            Object selected2 = s2.getFirstElement();
            if (selected2 instanceof MonitorHistoryRowModel) {
                if (property.equals("hasHistory")) {
                    return true;
                }
                if (property.equals("monitorDsnExists")) {
                    MonitorHistoryRowModel history = (MonitorHistoryRowModel)selected2;
                    return history.getExists() != null && !history.getExists().equals("NO");
                }
            }
        }
        if (receiver instanceof IStructuredSelection && (s = (IStructuredSelection)receiver) != null && s.getFirstElement() != null && (selected = s.getFirstElement()) instanceof MonitorProfileRowModel) {
            if (property.equals("hasHistory")) {
                MonitorProfileRowModel profile = (MonitorProfileRowModel)selected;
                return profile.getRuns() > 0;
            }
            if (property.equals("monitorDsnExists")) {
                return true;
            }
        }
        return false;
    }
}

