/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.rowmodels;

import com.ca.mat.common.table.FilterableTableRow;
import com.ca.mat.common.table.MATTableModel;
import com.ca.mat.common.table.MATTableRow;
import com.ca.mat.managers.Singletons;
import com.ca.mat.rowmodels.IXmlAttrHandler;
import com.ca.mat.rowmodels.LongNameTableRowModel;
import com.ca.mat.rowmodels.WASViewRowModel;
import com.ca.mat.utils.HexUtil;
import java.util.HashMap;
import java.util.logging.Logger;
import org.xml.sax.Attributes;

public class WASTranDelayRowModel
extends MATTableRow
implements IXmlAttrHandler,
Cloneable,
FilterableTableRow {
    static final String cacopyright = "Copyright \u00a9 2015 CA";
    Logger log = Logger.getLogger(this.getClass().getName());
    public static final String DATA_MODE_VIA = "data_mode_via";
    public static final String DATA_MODE_CURRENT = "data_mode_current";
    public static final String DATA_MODE_APPLICATION = "data_mode_application";
    public static final String FILTER_TRANURL = "tranurl";
    public static final String FILTER_WASMETH_APPLICATION = "wasmetha";
    public static final String FILTER_WASCLASS_APPLICATION = "wasclssa";
    public static final String FILTER_WASMETH_CURRENT = "wasmethc";
    public static final String FILTER_WASCLASS_CURRENT = "wasclssc";
    public static final String FILTER_WASMETH_VIA = "wasmethv";
    public static final String FILTER_WASCLASS_VIA = "wasclssv";
    public static final String FILTER_LN_APPLICATION = "waslinea";
    public static final String FILTER_LN_CURRENT = "waslinec";
    public static final String FILTER_LN_VIA = "waslinev";
    public static final String FILTER_TRANSQL = "transql";
    public static final String GROUP_BY_CLAMETHLIN = "group_by_class_method_line";
    public static final String GROUP_BY_TRAN = "group_by_tran";
    public static final String GROUP_BY_DELAY = "group_by_delay";
    public static final String DISPLAY_MODE_CLASS = "display_mode_class";
    public static final String DISPLAY_MODE_DELAY = "display_mode_delay";
    public static final String DISPLAY_MODE_TRAN = "display_mode_tran";
    private String dataMode = null;
    private String displayMode = null;
    private Double exepct = null;
    private Double invpct = null;
    private String sqlshort = "";
    private Double totpct = null;
    private String tranurl = "";
    private Double volpct = null;
    private String wasclssa = "";
    private String wasclssc = "";
    private String wasclssv = "";
    private String wasdelay = "";
    private String waslinea = "";
    private String waslinec = "";
    private String waslinev = "";
    private String wasmetha = "";
    private String wasmethc = "";
    private String wasmethv = "";
    private String WASMethodFinal;
    private String WASClassFinal;
    private String tranFinal;

    public WASTranDelayRowModel(MATTableModel model) {
        super(model);
    }

    public WASTranDelayRowModel() {
        this(null);
    }

    @Override
    public MATTableRow handleAttributes(Attributes attr, MATTableModel model, String modelName) {
        WASTranDelayRowModel result = new WASTranDelayRowModel(model);
        String value = attr.getValue("EXEPCT");
        if (value != null) {
            result.exepct = Double.valueOf(value);
        }
        if ((value = attr.getValue("INVPCT")) != null) {
            result.invpct = Double.valueOf(value);
        }
        if ((value = attr.getValue("SQLSHORT")) != null) {
            result.sqlshort = value.trim();
        }
        if ((value = attr.getValue("TOTPCT")) != null) {
            result.totpct = Double.valueOf(value);
        }
        if ((value = attr.getValue("TRANURL")) != null) {
            result.tranurl = value.trim();
        }
        if ((value = attr.getValue("VOLPCT")) != null) {
            result.volpct = Double.valueOf(value);
        }
        if ((value = attr.getValue("WASCLSSA")) != null) {
            result.wasclssa = value.trim();
        }
        if ((value = attr.getValue("WASCLSSC")) != null) {
            result.wasclssc = value.trim();
        }
        if ((value = attr.getValue("WASCLSSV")) != null) {
            result.wasclssv = value.trim();
        }
        if ((value = attr.getValue("WASDELAY")) != null) {
            result.wasdelay = value.trim();
        }
        if ((value = attr.getValue("WASLINEA")) != null) {
            result.waslinea = value.trim();
        }
        if ((value = attr.getValue("WASLINEC")) != null) {
            result.waslinec = value.trim();
        }
        if ((value = attr.getValue("WASLINEV")) != null) {
            result.waslinev = value.trim();
        }
        if ((value = attr.getValue("WASMETHA")) != null) {
            result.wasmetha = value.trim();
        }
        if ((value = attr.getValue("WASMETHC")) != null) {
            result.wasmethc = value.trim();
        }
        if ((value = attr.getValue("WASMETHV")) != null) {
            result.wasmethv = value.trim();
        }
        return result;
    }

    @Override
    protected Object[] getArray() {
        if (this.displayMode == null) {
            throw new RuntimeException(String.format("%s: display mode is not set in getArray()", this.getClass().toString()));
        }
        if (this.displayMode.equals(DISPLAY_MODE_CLASS)) {
            return new Object[]{this.getClassNameTranslated(), this.getMethodNameTranslated(), this.getLine(), this.exepct, this.invpct, this.volpct, this.totpct};
        }
        if (this.displayMode.equals(DISPLAY_MODE_DELAY)) {
            return new Object[]{this.wasdelay, this.exepct, this.invpct, this.volpct, this.totpct};
        }
        if (this.displayMode.equals(DISPLAY_MODE_TRAN)) {
            int totCount = 0;
            double totResp = 0.0;
            double avgResp = 0.0;
            double maxResp = 0.0;
            double minResp = 0.0;
            String translatedUrl = "";
            MATTableModel statsModel = Singletons.getAnalysisManager().getModel(this.model.getDsn(), "WAS Tran Stats", this.model.getType());
            MATTableRow[] mATTableRowArray = statsModel.getRows();
            int n = mATTableRowArray.length;
            int n2 = 0;
            while (n2 < n) {
                MATTableRow row = mATTableRowArray[n2];
                WASViewRowModel tranStatsRow = (WASViewRowModel)row;
                if (tranStatsRow.getTranURL().equals(this.tranurl)) {
                    translatedUrl = tranStatsRow.getURLNameTranslated();
                    totCount = tranStatsRow.getTotCount();
                    totResp = tranStatsRow.getTotResp();
                    avgResp = tranStatsRow.getAvgResp();
                    maxResp = tranStatsRow.getMaxResp();
                    minResp = tranStatsRow.getMinResp();
                    break;
                }
                ++n2;
            }
            return new Object[]{translatedUrl, this.exepct, this.invpct, this.volpct, this.totpct, totCount, totResp, avgResp, maxResp, minResp};
        }
        throw new RuntimeException(String.format("%1$s: Display mode invalid (%2$s)", this.getClass().toString(), this.displayMode));
    }

    @Override
    public boolean compliesWithFilter(String fieldName, Object value) {
        if (FILTER_TRANURL.equals(fieldName)) {
            return this.tranurl != null && this.tranurl.equals(value);
        }
        if (FILTER_WASMETH_APPLICATION.equals(fieldName)) {
            return this.wasmetha != null && this.wasmetha.equals(value);
        }
        if (FILTER_WASMETH_CURRENT.equals(fieldName)) {
            return this.wasmethc != null && this.wasmethc.equals(value);
        }
        if (FILTER_WASMETH_VIA.equals(fieldName)) {
            return this.wasmethv != null && this.wasmethv.equals(value);
        }
        if (FILTER_WASCLASS_APPLICATION.equals(fieldName)) {
            return this.wasclssa != null && this.wasclssa.equals(value);
        }
        if (FILTER_WASCLASS_CURRENT.equals(fieldName)) {
            return this.wasclssc != null && this.wasclssc.equals(value);
        }
        if (FILTER_WASCLASS_VIA.equals(fieldName)) {
            return this.wasclssv != null && this.wasclssv.equals(value);
        }
        if (FILTER_LN_APPLICATION.equals(fieldName)) {
            String tmp = this.waslinea.trim();
            if (tmp != null && tmp.equals("NotAvail")) {
                tmp = "";
            }
            return tmp != null && tmp.equals(value);
        }
        if (FILTER_LN_CURRENT.equals(fieldName)) {
            String tmp = this.waslinec.trim();
            if (tmp != null && tmp.equals("NotAvail")) {
                tmp = "";
            }
            return tmp != null && tmp.equals(value);
        }
        if (FILTER_LN_VIA.equals(fieldName)) {
            String tmp = this.waslinev.trim();
            if (tmp != null && tmp.equals("NotAvail")) {
                tmp = "";
            }
            return tmp != null && tmp.equals(value);
        }
        if (FILTER_TRANSQL.equals(fieldName)) {
            return this.sqlshort != null && this.sqlshort.equals(value);
        }
        throw new IllegalArgumentException(String.format("Field name unknown or null: %s", fieldName));
    }

    public WASTranDelayRowModel clone() {
        WASTranDelayRowModel result = new WASTranDelayRowModel(this.model);
        result.exepct = this.exepct;
        result.invpct = this.invpct;
        result.sqlshort = this.sqlshort;
        result.totpct = this.totpct;
        result.tranurl = this.tranurl;
        result.volpct = this.volpct;
        result.wasclssa = this.wasclssa;
        result.wasclssc = this.wasclssc;
        result.wasclssv = this.wasclssv;
        result.wasdelay = this.wasdelay;
        result.waslinea = this.waslinea;
        result.waslinec = this.waslinec;
        result.waslinev = this.waslinev;
        result.wasmetha = this.wasmetha;
        result.wasmethc = this.wasmethc;
        result.wasmethv = this.wasmethv;
        return result;
    }

    public String getMethodNameTranslated() {
        if (this.WASMethodFinal == null) {
            String input = null;
            if (this.dataMode.equals(DATA_MODE_APPLICATION)) {
                input = this.wasmetha;
            } else if (this.dataMode.equals(DATA_MODE_CURRENT)) {
                input = this.wasmethc;
            } else if (this.dataMode.equals(DATA_MODE_VIA)) {
                input = this.wasmethv;
            } else {
                throw new RuntimeException(String.format("%1$s: invalid dataMode (%2$s)", this.getClass().toString(), this.dataMode));
            }
            if (input != null && input.trim().equals("")) {
                this.WASMethodFinal = "**No Calls**";
            } else {
                String value = null;
                MATTableModel longNames = Singletons.getAnalysisManager().getModel(this.model.getDsn(), "Long Name Table", 1);
                HashMap<String, Object[]> arguments = new HashMap<String, Object[]>();
                arguments.put("LongName", new Object[]{"WAS"});
                arguments.put("ShrtName", new Object[]{input});
                if (longNames != null) {
                    longNames = longNames.filterBy(arguments);
                }
                if (longNames != null && longNames.getRows().length > 0) {
                    value = ((LongNameTableRowModel)longNames.getRows()[0]).getLongName();
                }
                if (value != null) {
                    this.WASMethodFinal = value;
                }
            }
        }
        return this.WASMethodFinal;
    }

    public String getClassNameTranslated() {
        if (this.WASClassFinal == null) {
            String input = null;
            if (this.dataMode.equals(DATA_MODE_APPLICATION)) {
                input = this.wasclssa;
            } else if (this.dataMode.equals(DATA_MODE_CURRENT)) {
                input = this.wasclssc;
            } else if (this.dataMode.equals(DATA_MODE_VIA)) {
                input = this.wasclssv;
            } else {
                throw new RuntimeException(String.format("getClassMethod: invalid dataMode (%1$s)", this.dataMode));
            }
            input = input.trim();
            if (input != null && input.trim().equals("")) {
                this.WASClassFinal = "** No Calls **";
            } else {
                String value = null;
                MATTableModel longNames = Singletons.getAnalysisManager().getModel(this.model.getDsn(), "Long Name Table", 1);
                HashMap<String, Object[]> arguments = new HashMap<String, Object[]>();
                arguments.put("LongName", new Object[]{"WAS"});
                arguments.put("SubType", new Object[]{"CLASS"});
                arguments.put("ShrtName", new Object[]{input});
                if (longNames != null) {
                    longNames = longNames.filterBy(arguments);
                }
                if (longNames != null && longNames.getRows().length > 0) {
                    value = ((LongNameTableRowModel)longNames.getRows()[0]).getLongName();
                }
                if (value != null) {
                    this.WASClassFinal = value;
                }
            }
        }
        return this.WASClassFinal;
    }

    public void setDataMode(String dataMode) {
        this.dataMode = dataMode;
    }

    public String getLine() {
        String val;
        if (this.dataMode.equals(DATA_MODE_APPLICATION)) {
            val = this.waslinea;
        } else if (this.dataMode.equals(DATA_MODE_CURRENT)) {
            val = this.waslinec;
        } else if (this.dataMode.equals(DATA_MODE_VIA)) {
            val = this.waslinev;
        } else {
            throw new RuntimeException(String.format("getLine: invalid dataMode (%s)", this.dataMode));
        }
        if (val.trim().equals("NotAvail")) {
            return "";
        }
        return HexUtil.leftTrim(val);
    }

    public Double getExepct() {
        return this.exepct;
    }

    public Double getInvpct() {
        return this.invpct;
    }

    public Double getVolpct() {
        return this.volpct;
    }

    public Double getTotpct() {
        return this.totpct;
    }

    public String getTran() {
        return this.tranurl;
    }

    public String getTranTranslated() {
        if (this.tranFinal == null) {
            String value = null;
            MATTableModel longNames = Singletons.getAnalysisManager().getModel(this.model.getDsn(), "Long Name Table", 1);
            HashMap<String, Object[]> arguments = new HashMap<String, Object[]>();
            arguments.put("LongName", new Object[]{"WAS"});
            arguments.put("SubType", new Object[]{"TRANURL"});
            arguments.put("ShrtName", new Object[]{this.tranurl});
            if (longNames != null) {
                longNames = longNames.filterBy(arguments);
            }
            if (longNames != null && longNames.getRows().length > 0) {
                value = ((LongNameTableRowModel)longNames.getRows()[0]).getLongName();
            }
            if (value != null) {
                this.tranFinal = value;
            }
        }
        return this.tranFinal;
    }

    public void addRow(WASTranDelayRowModel wasRow) {
        this.exepct = this.exepct + wasRow.exepct;
        this.invpct = this.invpct + wasRow.invpct;
        this.volpct = this.volpct + wasRow.volpct;
        this.totpct = this.totpct + wasRow.totpct;
    }

    public String getDataMode() {
        return this.dataMode;
    }

    public String getDelay() {
        return this.wasdelay;
    }

    public void setDisplayMode(String displayMode) {
        this.displayMode = displayMode;
    }

    public String getClassName() {
        if (this.dataMode.equals(DATA_MODE_APPLICATION)) {
            return this.wasclssa;
        }
        if (this.dataMode.equals(DATA_MODE_CURRENT)) {
            return this.wasclssc;
        }
        if (this.dataMode.equals(DATA_MODE_VIA)) {
            return this.wasclssv;
        }
        return null;
    }

    public String getMethodName() {
        if (this.dataMode.equals(DATA_MODE_APPLICATION)) {
            return this.wasmetha;
        }
        if (this.dataMode.equals(DATA_MODE_CURRENT)) {
            return this.wasmethc;
        }
        if (this.dataMode.equals(DATA_MODE_VIA)) {
            return this.wasmethv;
        }
        return null;
    }

    public String getSqlshort() {
        return this.sqlshort;
    }
}

