/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.logging;

import com.ca.mat.utils.TTSimpleFormatter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.LogRecord;

public class EclipseFormatter
extends TTSimpleFormatter {
    static final String cacopyright = "Copyright \u00a9 2011 CA";

    @Override
    public String format(LogRecord record) {
        StringWriter message = new StringWriter(500);
        message.append(this.formatMessage(record));
        if (record.getSourceClassName() != null) {
            message.append(' ');
            message.append(LF);
            message.append(record.getSourceClassName());
            if (record.getSourceMethodName() != null) {
                message.append(' ');
                message.append(record.getSourceMethodName());
            }
        }
        if (record.getThrown() != null) {
            try {
                message.append(LF);
                PrintWriter pw = new PrintWriter(message);
                record.getThrown().printStackTrace(pw);
            }
            catch (Exception exception) {}
        }
        StringBuffer buffer = message.getBuffer();
        int size = buffer.length();
        int index = 0;
        while (index < size) {
            char thisone = buffer.charAt(index);
            if (thisone > '\u007f') {
                buffer.setCharAt(index, '.');
            } else if (thisone < ' ') {
                switch (thisone) {
                    case '\n': 
                    case '\r': {
                        if (index < 2) break;
                        buffer.setCharAt(index, thisone);
                        break;
                    }
                    case '\t': {
                        buffer.setCharAt(index, ' ');
                        break;
                    }
                    default: {
                        buffer.setCharAt(index, '.');
                    }
                }
            }
            ++index;
        }
        return buffer.toString();
    }
}

