/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat.connect;

import com.ca.mat.connect.MATServer;
import com.ca.mat.connect.ServerConnect;
import com.ca.mat.utils.HexUtil;
import com.ca.mat.xml.XMLRequest;
import java.util.ArrayList;
import java.util.HashMap;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ValidateCredentials {
    static String cacopyright = "Copyright (c) 2011 CA";
    private String userId;
    private String ePassword;
    private MATServer server;
    private String errorMessage;
    private int errorLevel;
    private int errorCount;
    private ArrayList<Element> errorElements = new ArrayList();
    private String errorCause;
    private static final String SERVICE = "testingtools/validate";

    public ValidateCredentials(MATServer server) {
        this.server = server;
        this.userId = server.getUser();
        this.ePassword = server.getEPassword();
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public int getErrorLevel() {
        return this.errorLevel;
    }

    public int run(boolean credentials) {
        this.errorElements.clear();
        ServerConnect connect = new ServerConnect(this.server, SERVICE);
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        this.errorCount = 0;
        if (credentials) {
            map.put("user", this.userId);
            map.put("epassw", this.ePassword);
        }
        try {
            this.errorCause = "";
            XMLRequest xml = connect.connect("check", map, false);
            Element command = xml.getCommand();
            if (credentials) {
                this.checkError(command.getElementsByTagName("Signon"), false);
            }
            this.checkError(command.getElementsByTagName("DSN"), true);
        }
        catch (Exception e) {
            this.errorLevel = credentials ? -1 : 32;
            this.errorMessage = HexUtil.getErrorText(e);
            this.errorCause = "Error attempting to connect to server";
        }
        return this.errorLevel;
    }

    private void checkError(NodeList elements, boolean isDSN) {
        int index = 0;
        while (index < elements.getLength()) {
            Element element = (Element)elements.item(index);
            String value = element.getAttribute("errorlevel");
            int error = 0;
            try {
                error = Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {}
            if (error > 0) {
                if (error > this.errorLevel) {
                    this.errorLevel = error;
                    this.errorMessage = element.getAttribute("msg");
                }
                this.errorElements.add(element);
                if (isDSN) {
                    element.getAttribute("name");
                }
            }
            ++index;
        }
    }

    public ValidateCredentials(MATServer server, String userId, String password) {
        this(server);
        this.userId = userId;
        this.ePassword = password;
    }

    public void setServer(MATServer server) {
        this.server = server;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public ArrayList<Element> getErrorElements() {
        return this.errorElements;
    }

    public String getErrorCause() {
        return this.errorCause;
    }
}

