/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mat;

import com.ca.mat.IMATFragmentActivator;
import com.ca.mat.MATException;
import com.ca.mat.connect.MATFamily;
import com.ca.mat.logging.Logging;
import com.ca.mat.managers.Singletons;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.cheatsheets.OpenCheatSheetAction;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.UIJob;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin
implements IWorkbenchListener,
IPerspectiveListener {
    static final String cacopyright = "Copyright \u00a9 2015 CA";
    public static final String PLUGIN_ID = "com.ca.mat";
    private static final String CHEATSHEET = "com.ca.mat.cheatsheet.tutorial";
    private static final String EXAMPLE_COMMAND = "com.ca.mat.commands.analyzebundle";
    private static final String MAT_FRAGMENT_ACTIVATOR_INSTANCE_CLASS = "com.ca.mat.MATFragmentActivator";
    private static final boolean forceCheatsheet = Boolean.getBoolean("com.ca.mat.forcecheatsheet");
    private static final boolean forceExample = Boolean.getBoolean("com.ca.mat.forceexample");
    public boolean closing = false;
    private IMATFragmentActivator fragmentActivator;
    public static Activator plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.checkForFragments();
        if (Display.getCurrent() != null) {
            Logging.setLogging(this.getBundle(), true);
            IPersistentPreferenceStore store = Singletons.getUserPreferenceManager().getStoreForUserId();
            plugin.checkForImproperClose(Display.getCurrent(), (IPreferenceStore)store);
            plugin.getWorkbench().addWorkbenchListener((IWorkbenchListener)this);
            this.addWorkbenchListener();
        }
        this.getFragmentActivator().start(context);
    }

    private void addWorkbenchListener() {
        UIJob job = new UIJob("Add Perspective listener"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                plugin.getWorkbench().getActiveWorkbenchWindow().addPerspectiveListener((IPerspectiveListener)Activator.this);
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    public void afterWorkspaceCreate(boolean isRAP) {
        if (isRAP) {
            this.getFragmentActivator().login();
        } else {
            Logging.setLogging(this.getBundle(), true);
            IPersistentPreferenceStore store = Singletons.getUserPreferenceManager().getStoreForUserId();
            plugin.checkForImproperClose(Display.getCurrent(), (IPreferenceStore)store);
            plugin.setCheatSheet(Display.getCurrent(), (IPreferenceStore)store);
            plugin.setDisplayExample(Display.getCurrent(), (IPreferenceStore)store);
            this.addWorkbenchListener();
        }
    }

    public void checkForImproperClose(Display display, IPreferenceStore store) {
        if (store.getBoolean("mat_eclipse_proper_close") && display != null) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    boolean doReset;
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    String currentPerspective = page.getPerspective().getId();
                    if ("com.ca.mat.perspective".equals(currentPerspective) && (doReset = MessageDialog.openQuestion(null, (String)"Perspective reset recommended", (String)"The CA Mainframe Application Tuner GUI was not properly closed the last time, perspective reset is recommended to prevent problems with showing of new views. Do you wish to reset the CA Mainframe Application Tuner perspective now?"))) {
                        page.resetPerspective();
                    }
                }
            });
        }
        store.setValue("mat_eclipse_proper_close", true);
        try {
            ((IPersistentPreferenceStore)store).save();
        }
        catch (IOException iOException) {
            Logging.getLogger(display).fine("Failed to save PREFERENCE_ECLIPSE_IMPROPERLY_CLOSED flag to properties file for user " + Singletons.getUserPreferenceManager().getUserId());
        }
    }

    public void setDisplayExample(Display display, IPreferenceStore store) {
        String example = store.getString("mat_initial_display_example");
        if (!"mat_initial_display_example".equals(example) || forceExample) {
            if (display != null) {
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        IHandlerService service = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
                        try {
                            service.executeCommand(Activator.EXAMPLE_COMMAND, null);
                        }
                        catch (Exception exception) {}
                    }
                });
            }
            store.setValue("mat_initial_display_example", "mat_initial_display_example");
            try {
                ((IPersistentPreferenceStore)store).save();
            }
            catch (IOException iOException) {
                Logging.getLogger(display).fine("Failed to save INITIAL_EXAMPLE flag to properties file for user " + Singletons.getUserPreferenceManager().getUserId());
            }
        }
    }

    public void setCheatSheet(Display display, IPreferenceStore store) {
        String cheatsheet = store.getString("mat_initial_cheatsheet");
        if (!CHEATSHEET.equals(cheatsheet) || forceCheatsheet) {
            if (display != null) {
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        OpenCheatSheetAction action = new OpenCheatSheetAction(Activator.CHEATSHEET);
                        action.run();
                    }
                });
            }
            store.setValue("mat_initial_cheatsheet", CHEATSHEET);
            try {
                ((IPersistentPreferenceStore)this.getPreferenceStore()).save();
            }
            catch (IOException iOException) {
                Logging.getLogger(display).fine("Failed to save INITIAL_CHEATSHEET flag to properties file for user " + Singletons.getUserPreferenceManager().getUserId());
            }
        }
    }

    private void checkForFragments() {
        if (this.hasRAPFragment()) {
            if (this.hasEclipseFragment()) {
                throw new MATException("Duplicate fragment: Only one of the following fragments should be included: com.ca.mat.eclipsefragment, com.ca.mat.rapfragment");
            }
        } else if (!this.hasEclipseFragment()) {
            throw new MATException("Missing fragment: com.ca.mat needs one of the following fragments to be included: com.ca.mat.eclipsefragment, com.ca.mat.rapfragment");
        }
    }

    public boolean hasRAPFragment() {
        Bundle rapBundle = Platform.getBundle((String)"com.ca.mat.rapfragment");
        return rapBundle != null && rapBundle.getState() != 1;
    }

    public boolean hasEclipseFragment() {
        Bundle eclipseBundle = Platform.getBundle((String)"com.ca.mat.eclipsefragment");
        return eclipseBundle != null && eclipseBundle.getState() != 1;
    }

    public void afterWorkspaceDispose() {
        Singletons.getServerList(Display.getCurrent()).saveAll();
        Singletons.getViewerSynchronizationManager(Display.getCurrent()).persistAll();
        Singletons.getPersistenceManager(Display.getCurrent()).saveAll();
        Singletons.getTempFilesManager(Display.getCurrent()).deleteRemainingTempFiles();
        Singletons.disposeSingletons(Display.getCurrent());
        MATFamily family = new MATFamily(Display.getCurrent(), 0);
        Job.getJobManager().cancel((Object)family);
    }

    public void stop(BundleContext context) throws Exception {
        if (Display.getCurrent() != null) {
            this.afterWorkspaceDispose();
        }
        ThreadGroup group = Thread.currentThread().getThreadGroup();
        while (group.getParent() != null) {
            group = group.getParent();
        }
        int activeCount = group.activeCount();
        Thread[] activeThreads = new Thread[activeCount * 2];
        int actualCount = group.enumerate(activeThreads);
        int i = 0;
        while (i < actualCount) {
            if ("Server Watch".equals(activeThreads[i].getName())) {
                activeThreads[i].interrupt();
            }
            ++i;
        }
        this.getFragmentActivator().stop(context);
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public IMATFragmentActivator getFragmentActivator() {
        if (this.fragmentActivator == null) {
            try {
                Class<?> clazz = Class.forName(MAT_FRAGMENT_ACTIVATOR_INSTANCE_CLASS);
                Constructor<?> cons = clazz.getConstructor(new Class[0]);
                this.fragmentActivator = (IMATFragmentActivator)cons.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new MATException("Reflection failed to instantiate class com.ca.mat.MATFragmentActivator", e);
            }
        }
        return this.fragmentActivator;
    }

    public void initializeImageRegistry(ImageRegistry registry) {
        Bundle bundle = plugin.getBundle();
        Path path = new Path("icons/filter_16_option2.png");
        URL url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("com.ca.mat.filter", desc);
        path = new Path("icons/server_running_16.png");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("com.ca.mat.serverrunning", desc);
        path = new Path("icons/add_server_16.png");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("com.ca.mat.addserver", desc);
        path = new Path("icons/server_failed_16.png");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("com.ca.mat.serverfailed", desc);
        path = new Path("icons/disconnected_16.png");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("com.ca.mat.serverdisconnected", desc);
        path = new Path("icons/connected_16.png");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("com.ca.mat.serverconnected", desc);
        path = new Path("icons/help.png");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("com.ca.mat.help", desc);
        path = new Path("icons/NextNode.png");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("com.ca.mat.nextnode", desc);
        path = new Path("icons/refresh.png");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("com.ca.mat.refresh", desc);
        path = new Path("icons/menuArrow.png");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("com.ca.mat.menu", desc);
        path = new Path("icons/error_st_obj.gif");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("com.ca.mat.statusError", desc);
        path = new Path("icons/warning_st_obj.gif");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("com.ca.mat.statusWarning", desc);
        path = new Path("icons/info_st_obj.gif");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("com.ca.mat.statusInfo", desc);
        path = new Path("icons/ok_st_obj.gif");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("com.ca.mat.statusOk", desc);
        path = new Path("icons/prev_arrow.gif");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("com.ca.mat.prev", desc);
        path = new Path("icons/next_arrow.gif");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("com.ca.mat.next", desc);
        path = new Path("icons/right_arrow.gif");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("com.ca.mat.right", desc);
        path = new Path("icons/left_arrow.gif");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("com.ca.mat.left", desc);
        path = new Path("splash.bmp");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("com.ca.mat.splash", desc);
        path = new Path("icons/clear_text.gif");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("com.ca.mat.clear", desc);
        path = new Path("icons/fold_dropdown.gif");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("com.ca.mat.fold", desc);
        path = new Path("icons/unfold_dropdown.gif");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("com.ca.mat.dropDown", desc);
        path = new Path("icons/schedule_16.png");
        url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        desc = ImageDescriptor.createFromURL((URL)url);
        registry.put("com.ca.mat.schedules", desc);
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public void setClosing(boolean b) {
        this.closing = b;
    }

    public boolean preShutdown(IWorkbench workbench, boolean forced) {
        this.closing = true;
        this.afterWorkspaceDispose();
        return true;
    }

    public void postShutdown(IWorkbench workbench) {
    }

    public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
    }

    public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
        if (changeId.equalsIgnoreCase("reset")) {
            Singletons.getPersistenceManager(Display.getCurrent()).clearAll();
        }
    }
}

