/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.editor.ui.wizards;

import com.ca.filemaster.common.FMHistory;
import com.ca.filemaster.common.FMServerTreeModel;
import com.ca.filemaster.common.FileMasterDataset;
import com.ca.filemaster.common.FileMasterMember;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.common.FileMasterWizard;
import com.ca.filemaster.common.Validator;
import com.ca.filemaster.editor.ui.wizards.EditorWizardPageTwo;
import com.ca.filemaster.ui.wizards.MemberWizard;
import com.ca.filemaster.ui.wizards.MemberWizardPage;
import com.ca.filemaster.views.directorylist.DirectoryListView;
import com.ca.testingtools.core.TT_TreeItem;
import com.ca.testingtools.ui.TextUtil;
import com.ca.testingtools.ui.verifyNumber;
import com.ca.testingtools.ui.verifytoUpperCase;
import com.ca.testingtools.ui.wizards.TestingToolsWizardDialog;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.w3c.dom.Element;

public class EditorWizardPageOne
extends FileMasterWizard
implements ModifyListener,
FocusListener {
    private Label serverNameLabel;
    private String serverName;
    private Text serverNameText;
    private Combo datasetInEditorCombo;
    private Label memberNameLabel;
    private Combo memberNameCombo;
    private Button memberSelectButton;
    private String memberName = "";
    private String fileType;
    private Label volumeLabel;
    private Combo volumeCombo;
    private String volumeSerial;
    private Button editOption;
    private Button viewOption;
    private Button ChangLog;
    static int returnDDCM;
    public static String newDatasetName;
    public static String oldDatasetName;
    private static IPreferenceStore store;
    private static Boolean ShowDialog;
    private static boolean pendingMessage;
    private static boolean msgDisplayed;
    public static FileMasterServer server;
    private boolean isGenericOpen;
    private Button DirListInsert;
    private FMServerTreeModel model = FMServerTreeModel.getInstance();
    public static FileMasterDataset dataSet;
    public static FileMasterMember member;
    private Label PrimaryAllocLabel;
    private Label SecondaryAllocLabel;
    private Button VolumeSerialRadio;
    private Button GenericUnitRadio;
    private Text VolumeSerialText;
    private Text GenericUnitText;
    private Text PrimaryAllocText;
    private Text SecondaryAllocText;
    private int CLOGNUM = 0;
    private String CLOGPOPT = "";
    public String storageName = "";
    public String storageValue = "";
    private Group grpChangeLogOption;
    private final Logger logger = Logger.getLogger(EditorWizardPageOne.class.getName());
    private final String CONTEXT_HELP_ID = "com.ca.filemaster.help.OpenFile";
    private Text dataSetText;

    static {
        store = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), "com.ca.filemaster");
        ShowDialog = false;
        pendingMessage = false;
    }

    public EditorWizardPageOne(boolean isGenericOpen, String titlePageOne, FileMasterServer server, FileMasterDataset dataSet, FileMasterMember member, String fileType) {
        super(titlePageOne, dataSet.getName(), server);
        this.setTitle(titlePageOne);
        this.isGenericOpen = isGenericOpen;
        if (member != null) {
            this.memberName = member.getName();
        }
        this.serverName = server.getName();
        this.fileType = fileType;
        oldDatasetName = this.dataSetName;
        EditorWizardPageOne.server = server;
        EditorWizardPageOne.dataSet = dataSet;
        EditorWizardPageOne.member = member;
    }

    public void createControl(Composite parent) {
        GridData data = new GridData(4, 0, true, true, 1, 1);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ca.filemaster.help.OpenFile");
        super.createControl(parent);
        if (!this.isGenericOpen) {
            this.serverNameLabel = new Label(this.dataSetComposite, 0);
            this.serverNameLabel.setText("Se&rver:");
            this.serverNameText = new Text(this.dataSetComposite, 2056);
            this.serverNameText.setLayoutData((Object)data);
            this.serverNameText.setText(server.getText());
            new Label(this.dataSetComposite, 0);
            new Label(this.dataSetComposite, 0);
        }
        this.createDataSet();
        this.dataSetText.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (!msgDisplayed) {
                    oldDatasetName = EditorWizardPageOne.this.dataSetText.getText();
                }
                msgDisplayed = false;
            }

            public void focusLost(FocusEvent e) {
            }
        });
        this.dataSetText.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EditorWizardPageOne.this.validateDataSet();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.dataSetText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EditorWizardPageOne.this.validateDataSet();
            }
        });
        this.dataSetText.setText(dataSet.getName());
        this.createMember();
        this.createVolumeSerial();
        Group grpOptionMode = new Group(this.container, 0);
        grpOptionMode.setLayout((Layout)new GridLayout(2, false));
        grpOptionMode.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        grpOptionMode.setText("Open mode");
        this.editOption = new Button((Composite)grpOptionMode, 16);
        this.editOption.setText("Edi&t");
        this.editOption.setSelection(false);
        this.editOption.notifyListeners(13, new Event());
        this.editOption.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EditorWizardPageOne.this.editOption.setEnabled(true);
                EditorWizardPageOne.this.ChangLog.setEnabled(true);
                if (server.getFmpPreferences().getFmChangeLogPrefs().isChangeLogForced()) {
                    EditorWizardPageOne.this.ChangLog.setEnabled(false);
                    EditorWizardPageOne.this.ChangLog.setSelection(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.viewOption = new Button((Composite)grpOptionMode, 16);
        this.viewOption.setText("V&iew");
        this.viewOption.setSelection(true);
        this.viewOption.notifyListeners(13, new Event());
        this.viewOption.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EditorWizardPageOne.this.viewOption.setEnabled(true);
                EditorWizardPageOne.this.ChangLog.setSelection(false);
                EditorWizardPageOne.this.ChangLog.setEnabled(false);
                EditorWizardPageOne.this.VolumeSerialText.setEnabled(false);
                EditorWizardPageOne.this.VolumeSerialRadio.setEnabled(false);
                EditorWizardPageOne.this.GenericUnitText.setEnabled(false);
                EditorWizardPageOne.this.GenericUnitRadio.setEnabled(false);
                EditorWizardPageOne.this.PrimaryAllocText.setEnabled(false);
                EditorWizardPageOne.this.PrimaryAllocLabel.setEnabled(false);
                EditorWizardPageOne.this.SecondaryAllocText.setEnabled(false);
                EditorWizardPageOne.this.SecondaryAllocLabel.setEnabled(false);
                EditorWizardPageOne.this.setPageComplete(EditorWizardPageOne.this.isPageComplete());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.grpChangeLogOption = new Group(this.container, 0);
        this.grpChangeLogOption.notifyListeners(26, new Event());
        this.grpChangeLogOption.setLayout((Layout)new GridLayout(2, false));
        this.grpChangeLogOption.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.grpChangeLogOption.setText("Change log options");
        Group StorageGrp = new Group((Composite)this.grpChangeLogOption, 0);
        StorageGrp.setText("Storage");
        StorageGrp.setLayout((Layout)new GridLayout(2, false));
        StorageGrp.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.VolumeSerialRadio = new Button((Composite)StorageGrp, 16);
        this.VolumeSerialRadio.setText("&Volume serial:");
        this.VolumeSerialRadio.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EditorWizardPageOne.this.buttonPressed(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.VolumeSerialText = new Text((Composite)StorageGrp, 2048);
        GridData gd_VolumeSerialText = new GridData(16384, 0x1000000, true, false, 1, 1);
        this.VolumeSerialText.setLayoutData((Object)gd_VolumeSerialText);
        TextUtil.setWidth((Text)this.VolumeSerialText, (int)8);
        this.VolumeSerialText.setTextLimit(6);
        this.VolumeSerialText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                Pattern p = Pattern.compile("[0-9A-Z#@$]+");
                if (e.doit && e.text.length() > 0) {
                    e.text = e.text.toUpperCase();
                }
                if (!e.doit) {
                    return;
                }
                if (e.text.length() == 0) {
                    return;
                }
                e.text = e.text.toUpperCase();
                Matcher m = p.matcher(e.text);
                e.doit = m.matches();
            }
        });
        this.VolumeSerialText.addVerifyListener((VerifyListener)new verifytoUpperCase());
        this.VolumeSerialText.addModifyListener((ModifyListener)this);
        this.GenericUnitRadio = new Button((Composite)StorageGrp, 16);
        this.GenericUnitRadio.setText("&Generic unit:");
        this.GenericUnitRadio.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EditorWizardPageOne.this.buttonPressed(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.GenericUnitRadio.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EditorWizardPageOne.this.setPageComplete(EditorWizardPageOne.this.isPageComplete());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.GenericUnitText = new Text((Composite)StorageGrp, 2048);
        this.GenericUnitText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                Pattern p = Pattern.compile("[0-9A-Z#@$]+");
                if (e.doit && e.text.length() > 0) {
                    e.text = e.text.toUpperCase();
                }
                if (!e.doit) {
                    return;
                }
                if (e.text.length() == 0) {
                    return;
                }
                e.text = e.text.toUpperCase();
                Matcher m = p.matcher(e.text);
                e.doit = m.matches();
            }
        });
        this.GenericUnitText.addModifyListener((ModifyListener)this);
        GridData gd_GenericUnitText = new GridData(16384, 0x1000000, true, false, 1, 1);
        this.GenericUnitText.setLayoutData((Object)gd_GenericUnitText);
        TextUtil.setWidth((Text)this.GenericUnitText, (int)8);
        this.GenericUnitText.setTextLimit(8);
        this.VolumeSerialText.setEnabled(false);
        this.VolumeSerialRadio.setEnabled(false);
        this.GenericUnitText.setEnabled(false);
        this.GenericUnitRadio.setEnabled(false);
        Group AllocationGrp = new Group((Composite)this.grpChangeLogOption, 0);
        AllocationGrp.setText("Space allocation parms");
        AllocationGrp.setLayout((Layout)new GridLayout(2, false));
        AllocationGrp.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.PrimaryAllocLabel = new Label((Composite)AllocationGrp, 0);
        this.PrimaryAllocLabel.setText("&Primary allocation (in cylinders):");
        this.PrimaryAllocText = new Text((Composite)AllocationGrp, 133120);
        GridData gd_PrimaryAllocText = new GridData(16384, 0x1000000, true, false, 1, 1);
        this.PrimaryAllocText.setLayoutData((Object)gd_PrimaryAllocText);
        TextUtil.setWidth((Text)this.PrimaryAllocText, (int)8);
        this.PrimaryAllocText.setTextLimit(8);
        this.PrimaryAllocText.addVerifyListener((VerifyListener)new verifyNumber(false));
        this.PrimaryAllocText.addModifyListener((ModifyListener)this);
        this.PrimaryAllocText.setText(Integer.toString(server.getFmpPreferences().getFmChangeLogPrefs().getPrimaryAlloc()));
        this.SecondaryAllocLabel = new Label((Composite)AllocationGrp, 0);
        this.SecondaryAllocLabel.setText("&Secondary allocation (in cylinders):");
        this.SecondaryAllocText = new Text((Composite)AllocationGrp, 133120);
        GridData gd_SecondaryAllocText = new GridData(16384, 0x1000000, true, false, 1, 1);
        this.SecondaryAllocText.setLayoutData((Object)gd_SecondaryAllocText);
        TextUtil.setWidth((Text)this.SecondaryAllocText, (int)8);
        this.SecondaryAllocText.setTextLimit(8);
        this.SecondaryAllocText.addVerifyListener((VerifyListener)new verifyNumber(false));
        this.SecondaryAllocText.setText(Integer.toString(server.getFmpPreferences().getFmChangeLogPrefs().getSecondaryAlloc()));
        this.PrimaryAllocText.setEnabled(false);
        this.PrimaryAllocLabel.setEnabled(false);
        this.SecondaryAllocText.setEnabled(false);
        this.SecondaryAllocLabel.setEnabled(false);
        new Label((Composite)this.grpChangeLogOption, 0);
        new Label((Composite)this.grpChangeLogOption, 0);
        this.ChangLog = new Button((Composite)this.grpChangeLogOption, 32);
        this.ChangLog.setText("Enable &change log");
        this.ChangLog.setEnabled(false);
        this.ChangLog.notifyListeners(13, new Event());
        this.ChangLog.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 128) {
                    e.doit = false;
                }
            }
        });
        this.ChangLog.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (EditorWizardPageOne.this.ChangLog.getSelection()) {
                    EditorWizardPageOne.this.grpChangeLogOption.setEnabled(true);
                    if (server.getFmpPreferences().getFmChangeLogPrefs().isUseVolSer()) {
                        EditorWizardPageOne.this.VolumeSerialText.setEnabled(true);
                        EditorWizardPageOne.this.GenericUnitText.setEnabled(false);
                    } else {
                        EditorWizardPageOne.this.VolumeSerialText.setEnabled(false);
                        EditorWizardPageOne.this.GenericUnitText.setEnabled(true);
                    }
                    EditorWizardPageOne.this.volumeLabel.setEnabled(true);
                    EditorWizardPageOne.this.VolumeSerialRadio.setEnabled(true);
                    EditorWizardPageOne.this.GenericUnitRadio.setEnabled(true);
                    EditorWizardPageOne.this.PrimaryAllocText.setEnabled(true);
                    EditorWizardPageOne.this.PrimaryAllocLabel.setEnabled(true);
                    EditorWizardPageOne.this.SecondaryAllocText.setEnabled(true);
                    EditorWizardPageOne.this.SecondaryAllocLabel.setEnabled(true);
                } else {
                    EditorWizardPageOne.this.VolumeSerialText.setEnabled(false);
                    EditorWizardPageOne.this.volumeLabel.setEnabled(false);
                    EditorWizardPageOne.this.VolumeSerialRadio.setEnabled(false);
                    EditorWizardPageOne.this.GenericUnitText.setEnabled(false);
                    EditorWizardPageOne.this.GenericUnitRadio.setEnabled(false);
                    EditorWizardPageOne.this.PrimaryAllocText.setEnabled(false);
                    EditorWizardPageOne.this.PrimaryAllocLabel.setEnabled(false);
                    EditorWizardPageOne.this.SecondaryAllocText.setEnabled(false);
                    EditorWizardPageOne.this.SecondaryAllocLabel.setEnabled(false);
                }
                EditorWizardPageOne.this.setPageComplete(EditorWizardPageOne.this.isPageComplete());
                EditorWizardPageOne.this.ChangLog.setFocus();
            }
        });
        new Label((Composite)this.grpChangeLogOption, 0);
        if (server.getFmpPreferences().getFmChangeLogPrefs().isUseVolSer()) {
            if (this.ChangLog.getSelection()) {
                this.VolumeSerialText.setEnabled(true);
                this.GenericUnitText.setEnabled(false);
            }
            this.VolumeSerialText.setText(server.getFmpPreferences().getFmChangeLogPrefs().getVolume_Serial());
            this.VolumeSerialRadio.setSelection(true);
            this.storageName = "ChangeLogVolser";
            this.storageValue = this.VolumeSerialText.getText();
        } else {
            this.GenericUnitText.setText(server.getFmpPreferences().getFmChangeLogPrefs().getGeneric_Unit());
            this.GenericUnitRadio.setSelection(true);
            this.storageName = "ChangeLogUnit";
            this.storageValue = this.GenericUnitText.getText();
            if (this.ChangLog.getSelection()) {
                this.GenericUnitText.setEnabled(true);
                this.VolumeSerialText.setEnabled(false);
            }
        }
        if (this.isGenericOpen) {
            this.DirListInsert = new Button(this.container, 32);
            this.DirListInsert.setText("&Add to Directory List view");
            if (this.dataSetDSNListBtn != null) {
                this.dataSetDSNListBtn.setEnabled(false);
            }
        }
        if (this.fileType.equalsIgnoreCase("VSAM") || this.fileType.equalsIgnoreCase("PS") || this.fileType.equalsIgnoreCase("PSL") || this.fileType.equalsIgnoreCase("Sequential") || this.fileType.equalsIgnoreCase("DA") || this.fileType.equalsIgnoreCase("Direct Access")) {
            this.memberNameCombo.setEnabled(false);
            this.memberSelectButton.setEnabled(false);
            this.dataSetText.setFocus();
        } else {
            this.memberNameCombo.setFocus();
        }
        this.setControl((Control)this.container);
        Point size = this.getShell().computeSize(-1, -1);
        this.getShell().setSize(size);
        this.setControl((Control)this.container);
    }

    public Text getVolumeSerialText() {
        return this.VolumeSerialText;
    }

    public void setVolumeSerialText(Text volumeSerialText) {
        this.VolumeSerialText = volumeSerialText;
    }

    public String getGenericUnitText() {
        return this.GenericUnitText.getText();
    }

    public void setGenericUnitText(Text genericUnitText) {
        this.GenericUnitText = genericUnitText;
    }

    public String getPrimaryAllocText() {
        return this.PrimaryAllocText.getText();
    }

    public void setPrimaryAllocText(Text primaryAllocText) {
        this.PrimaryAllocText = primaryAllocText;
    }

    public String getSecondaryAllocText() {
        return this.SecondaryAllocText.getText();
    }

    public void setSecondaryAllocText(Text secondaryAllocText) {
        this.SecondaryAllocText = secondaryAllocText;
    }

    public String getStorageValue() {
        return this.storageValue;
    }

    public void setStorageValue(String storageValue) {
        this.storageValue = storageValue;
    }

    private void buttonPressed(SelectionEvent e) {
        Widget source = e.widget;
        if (source instanceof Button) {
            if (((Button)source).getText().equalsIgnoreCase("&Volume serial:")) {
                this.storageName = "ChangeLogVolser";
                this.storageValue = this.VolumeSerialText.getText();
                if (this.ChangLog.getSelection()) {
                    this.VolumeSerialText.setEnabled(true);
                    this.GenericUnitText.setEnabled(false);
                }
            }
            if (((Button)source).getText().equalsIgnoreCase("&Generic unit:")) {
                this.storageName = "ChangeLogUnit";
                this.storageValue = this.GenericUnitText.getText();
                if (this.ChangLog.getSelection()) {
                    this.VolumeSerialText.setEnabled(false);
                    this.GenericUnitText.setEnabled(true);
                }
            }
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.fileType.equalsIgnoreCase("VSAM") || this.fileType.equalsIgnoreCase("PS") || this.fileType.equalsIgnoreCase("PSL") || this.fileType.equalsIgnoreCase("Sequential")) {
            this.dataSetText.setFocus();
        } else {
            this.memberNameCombo.setFocus();
        }
        if (this.isGenericOpen) {
            this.dataSetText.setFocus();
        }
        if (this.volumeSerial != null) {
            this.volumeCombo.setText(this.volumeSerial);
        }
    }

    public void createDataSet() {
        this.dataSetLabel = new Label(this.dataSetComposite, 0);
        this.dataSetLabel.setText("&Data set name:");
        this.dataSetText = new Text(this.dataSetComposite, 2056);
        this.data = new GridData();
        this.data.horizontalAlignment = 4;
        this.data.verticalAlignment = 0;
        this.data.grabExcessHorizontalSpace = true;
        this.data.grabExcessVerticalSpace = true;
        this.data.horizontalSpan = 1;
        this.data.verticalSpan = 1;
        this.dataSetText.setLayoutData((Object)new GridData(4, 0, true, true, 1, 1));
        TextUtil.setWidth((Text)this.dataSetText, (int)37);
        this.dataSetText.setTextLimit(44);
        this.memberNameLabel = new Label(this.dataSetComposite, 0);
        this.memberNameLabel = new Label(this.dataSetComposite, 0);
    }

    private void createMember() {
        this.memberNameLabel = new Label(this.dataSetComposite, 0);
        this.memberNameLabel.setText("&Member name:");
        this.memberNameCombo = new Combo(this.dataSetComposite, 0);
        this.memberNameCombo.setLayoutData((Object)this.data);
        this.memberNameCombo.setTextLimit(8);
        TextUtil.setWidth((Combo)this.memberNameCombo, (int)37);
        FMHistory.intializeComboBoxes((Combo)this.memberNameCombo, (String)"MemberOpenFileWizardPage1");
        this.memberNameCombo.setText(this.memberName);
        this.memberNameCombo.addVerifyListener((VerifyListener)new verifytoUpperCase());
        this.memberNameCombo.addModifyListener((ModifyListener)this);
        this.memberSelectButton = new Button(this.dataSetComposite, 0);
        this.memberSelectButton.setText("S&elect...");
        this.memberSelectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                returnDDCM = EditorWizardPageOne.this.displayDatasetChangedMsg();
                if (returnDDCM == 2 || returnDDCM == -1) {
                    member = new FileMasterMember(null);
                    member.setName(EditorWizardPageOne.this.memberNameCombo.getText());
                    MemberWizard wizard = new MemberWizard(member, dataSet, server, true);
                    EditorWizardPageOne.this.dialog = new TestingToolsWizardDialog(EditorWizardPageOne.this.getShell(), (IWizard)wizard);
                    EditorWizardPageOne.this.dialog.create();
                    MemberWizardPage.memValue.addSelectionListener(new SelectionListener(){

                        public void widgetSelected(SelectionEvent e) {
                            String memberName = MemberWizardPage.getSelectedMember();
                            EditorWizardPageOne.this.memberNameCombo.setText(memberName);
                        }

                        public void widgetDefaultSelected(SelectionEvent e) {
                        }
                    });
                    EditorWizardPageOne.this.dialog.open();
                } else if (returnDDCM == 3) {
                    EditorWizardPageOne.this.dataSetText.setFocus();
                }
                EditorWizardPageOne.this.setPageComplete(EditorWizardPageOne.this.isPageComplete());
            }
        });
        new Label(this.dataSetComposite, 0);
    }

    private void createVolumeSerial() {
        this.volumeLabel = new Label(this.dataSetComposite, 0);
        this.volumeLabel.setText("&Volume serial:");
        this.volumeCombo = new Combo(this.dataSetComposite, 0);
        this.volumeCombo.setLayoutData((Object)this.data);
        TextUtil.setWidth((Combo)this.volumeCombo, (int)37);
        this.volumeCombo.setTextLimit(6);
        this.volumeCombo.addVerifyListener((VerifyListener)new verifytoUpperCase());
        this.volumeCombo.addModifyListener((ModifyListener)this);
        FMHistory.intializeComboBoxes((Combo)this.volumeCombo, (String)"OpenFileWizardPage1Volume");
        new Label(this.dataSetComposite, 0);
        new Label(this.dataSetComposite, 0);
    }

    public void modifyText(ModifyEvent e) {
        Widget source = e.widget;
        if (source instanceof Text) {
            if (this.VolumeSerialRadio.getSelection()) {
                this.storageValue = this.VolumeSerialText.getText();
            } else if (this.GenericUnitRadio.getSelection()) {
                this.storageValue = this.GenericUnitText.getText();
            }
        }
        this.setPageComplete(this.isPageComplete());
    }

    private void validateDataSet() {
        boolean datasetError;
        newDatasetName = this.dataSetText.getText().trim();
        ShowDialog = !store.getBoolean("CLOSE_VALUE");
        boolean bl = datasetError = Validator.dataset((String)this.dataSetText.getText(), (boolean)true) != 0 && Validator.dataset((String)this.dataSetText.getText(), (boolean)true) != 3 && Validator.dataset((String)this.dataSetText.getText(), (boolean)true) != 1;
        if (ShowDialog.booleanValue() && !datasetError && (this.memberNameCombo != null && !this.memberNameCombo.getText().isEmpty() || this.volumeCombo != null && !this.volumeCombo.getText().isEmpty()) && !oldDatasetName.equalsIgnoreCase(newDatasetName)) {
            pendingMessage = true;
        } else {
            pendingMessage = false;
            if (!oldDatasetName.equalsIgnoreCase(newDatasetName)) {
                oldDatasetName = newDatasetName;
                dataSet.setName(oldDatasetName);
                this.memberNameCombo.setText("");
            }
        }
        this.displayDatasetChangedMsg();
    }

    private int displayDatasetChangedMsg() {
        msgDisplayed = true;
        int returncode = -1;
        boolean remove = false;
        if (pendingMessage) {
            pendingMessage = false;
            if (!newDatasetName.equals(oldDatasetName)) {
                String question = "Are you sure you want to change the data set? Clicking Yes will reset all fields on this dialog. ";
                String toggleMessage = "Do not ask me again";
                MessageDialogWithToggle result = MessageDialogWithToggle.openYesNoQuestion(null, (String)"Confirm Change Data Set", (String)question, (String)toggleMessage, (boolean)false, (IPreferenceStore)store, (String)"CLOSE_VALUE");
                returncode = result.getReturnCode();
                if (returncode == 2) {
                    remove = true;
                }
                if (remove) {
                    oldDatasetName = newDatasetName;
                    store.setValue("CLOSE_VALUE", result.getToggleState());
                    if (result.getToggleState()) {
                        ShowDialog = false;
                    }
                    this.memberNameCombo.setText("");
                    this.volumeCombo.setText("");
                } else {
                    if (result.getToggleState()) {
                        ShowDialog = false;
                    }
                    this.dataSetText.setText(oldDatasetName);
                    newDatasetName = oldDatasetName;
                }
            }
        }
        return returncode;
    }

    public void focusGained(FocusEvent e) {
        returnDDCM = this.displayDatasetChangedMsg();
        if (returnDDCM == 3) {
            this.dataSetText.setFocus();
        }
    }

    public void focusLost(FocusEvent e) {
    }

    public boolean doFinish() {
        this.logger.log(Level.INFO, "Setting history info");
        FMHistory.insertHistory((Combo)this.memberNameCombo, (String)"MemberOpenFileWizardPage1");
        FMHistory.insertHistory((Combo)this.volumeCombo, (String)"VolumeOpenFileWizardPage1");
        String error = ((EditorWizardPageTwo)this.getWizard().getPage((String)"Options")).returnCode;
        if (error.isEmpty()) {
            return true;
        }
        if (Integer.parseInt(error) == 32 || Integer.parseInt(error) == 16) {
            return true;
        }
        return Integer.parseInt(error) <= 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean isPageComplete() {
        boolean prevError;
        boolean bl = prevError = !super.isPageComplete();
        if (this.fileType.equalsIgnoreCase("VSAM") || this.fileType.equalsIgnoreCase("PS") || this.fileType.equalsIgnoreCase("PSL") || this.fileType.equalsIgnoreCase("Sequential") || this.fileType.equalsIgnoreCase("DA") || this.fileType.equalsIgnoreCase("Direct Access")) {
            this.memberNameCombo.setEnabled(false);
            this.memberSelectButton.setEnabled(false);
        } else {
            this.memberNameCombo.setEnabled(true);
        }
        if (this.memberNameCombo != null && this.memberNameCombo.isEnabled()) {
            switch (Validator.member((String)this.memberNameCombo.getText(), (boolean)true)) {
                case 5: {
                    this.error = String.valueOf(this.error) + Validator.errorMsg[Validator.member((String)this.memberNameCombo.getText(), (boolean)true)] + "\n ";
                    this.memberSelectButton.setEnabled(true);
                    break;
                }
                case 7: {
                    if (!(this.fileType.equalsIgnoreCase("VSAM") || this.fileType.equalsIgnoreCase("PS") || this.fileType.equalsIgnoreCase("PSL") || this.fileType.equalsIgnoreCase("Sequential"))) {
                        this.memberSelectButton.setEnabled(true);
                    }
                    if (!this.memberNameCombo.getText().contains("*") && !this.memberNameCombo.getText().contains("%")) break;
                    this.error = String.valueOf(this.error) + Validator.errorMsg[Validator.member((String)this.memberNameCombo.getText(), (boolean)true)] + "\n";
                    break;
                }
                case 6: {
                    this.error = String.valueOf(this.error) + Validator.errorMsg[Validator.member((String)this.memberNameCombo.getText(), (boolean)false)] + "\n ";
                    this.memberSelectButton.setEnabled(false);
                    break;
                }
                case 0: {
                    this.memberSelectButton.setEnabled(false);
                    break;
                }
            }
            if (!(this.memberNameCombo.getText().trim().length() != 0 || this.fileType.equalsIgnoreCase("VSAM") || this.fileType.equalsIgnoreCase("PS") || this.fileType.equalsIgnoreCase("PSL") || this.fileType.equalsIgnoreCase("Sequential"))) {
                this.memberSelectButton.setEnabled(true);
            }
        }
        if (this.volumeCombo != null) {
            switch (Validator.volume((String)this.volumeCombo.getText(), (boolean)false)) {
                case 9: {
                    this.error = String.valueOf(this.error) + Validator.errorMsg[Validator.volume((String)this.volumeCombo.getText(), (boolean)false)] + "\n ";
                    break;
                }
            }
        }
        if (this.ChangLog != null && this.ChangLog.getSelection() && this.editOption.getSelection()) {
            this.error = String.valueOf(this.error) + Validator.errorMsg[Validator.Changelog((String)this.PrimaryAllocText.getText(), (boolean)false)];
        }
        if (this.VolumeSerialRadio != null && this.editOption.getSelection() && this.VolumeSerialRadio.getSelection()) {
            this.error = String.valueOf(this.error) + Validator.errorMsg[Validator.volume((String)this.VolumeSerialText.getText(), (boolean)true)];
        }
        if (this.error.length() <= 0) {
            if (prevError) return false;
            this.setErrorMessage(null);
            return true;
        }
        if (this.getErrorMessage() == null) {
            this.setErrorMessage(this.error);
            this.error = new String();
            return false;
        }
        if (!this.getErrorMessage().equalsIgnoreCase(this.error)) {
            this.setErrorMessage(this.error);
            this.error = new String();
            return false;
        }
        this.error = new String();
        return false;
    }

    public String getModeOption() {
        if (this.editOption.getSelection()) {
            return "edit";
        }
        return "view";
    }

    public Boolean getViewOption() {
        return this.viewOption.getEnabled();
    }

    public Boolean isChangeLog() {
        return this.ChangLog.getSelection();
    }

    public Combo getDatasetInEditorCombo() {
        return this.datasetInEditorCombo;
    }

    public Combo getMemberNameCombo() {
        return this.memberNameCombo;
    }

    public Combo getVolCombo() {
        return this.volumeCombo;
    }

    public void insertMemberToField(String membersName) {
        this.memberNameCombo.setText(membersName);
    }

    public String getStorageName() {
        return this.storageName;
    }

    public void setStorageName(String storageName) {
        this.storageName = storageName;
    }

    public int getCLOGNUM() {
        return this.CLOGNUM;
    }

    public void setCLOGNUM(int cLOGNUM) {
        this.CLOGNUM = cLOGNUM;
    }

    public String getCLOGPOPT() {
        return this.CLOGPOPT;
    }

    public void setCLOGPOPT(String cLOGPOPT) {
        this.CLOGPOPT = cLOGPOPT;
    }

    public FileMasterServer getServer() {
        return server;
    }

    public void updateDataSet(FileMasterDataset FMPDataset) {
        dataSet = FMPDataset;
    }

    public void insertIntoDirecotryList() {
        boolean isDuplicatedMember = false;
        if (this.DirListInsert.getSelection()) {
            FileMasterDataset fmdataset = new FileMasterDataset(null);
            fmdataset.setName(this.dataSetText.getText());
            fmdataset.setDsOrg(this.fileType);
            TT_TreeItem dsItem = null;
            int index = 0;
            int i = 0;
            while (i < this.model.getServers().length) {
                if (this.model.getServers()[i].getName().equals(this.serverName)) {
                    index = i;
                    break;
                }
                ++i;
            }
            dsItem = this.model.findObjectInTree((Object)fmdataset, this.model.getServers()[index]);
            if (dsItem == null) {
                Element dsElement = this.model.addDataset(server.getElement(), fmdataset.getName(), "", "", "", fmdataset.getDsOrg());
                dsItem = this.model.insertDataset(this.model.getServers()[index], dsElement);
            }
            FileMasterMember fmmember = new FileMasterMember(null);
            if (this.memberNameCombo.getText().trim().length() != 0) {
                fmmember.setName(this.memberNameCombo.getText().trim());
                fmmember.setType("MEMBER");
                if (this.model.findObjectInTree((Object)fmmember, dsItem) != null) {
                    isDuplicatedMember = true;
                }
                if (!isDuplicatedMember) {
                    Element memItem = this.model.addMember(dsItem.getElement(), fmmember.getName(), fmmember.getType());
                    this.model.insertMember(dsItem, memItem);
                    this.model.save();
                }
            }
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            IWorkbenchPage page = window.getActivePage();
            try {
                DirectoryListView DirectoryView = (DirectoryListView)page.findView("com.ca.filemaster.views.directorylist");
                TreeViewer viewer = DirectoryView.getViewer();
                viewer.refresh();
            }
            catch (Exception exception) {}
        }
    }

    public Text getDataSetText() {
        return this.dataSetText;
    }

    public static FileMasterDataset getDataSet() {
        return dataSet;
    }

    public static FileMasterMember getMember() {
        return member;
    }

    public void setDataSet(FileMasterDataset dataSet) {
        EditorWizardPageOne.dataSet = dataSet;
        this.dataSetText.setText(dataSet.getName());
    }

    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
        if (fileType.equalsIgnoreCase("VSAM") || fileType.equalsIgnoreCase("PS") || fileType.equalsIgnoreCase("PSL") || fileType.equalsIgnoreCase("Sequential") || fileType.equalsIgnoreCase("DA") || fileType.equalsIgnoreCase("Direct Access")) {
            this.memberNameCombo.setText("");
        }
    }

    public void setOpenVolume(String volume) {
        this.volumeSerial = volume;
    }

    public void SetFocus() {
        this.dataSetText.setFocus();
    }
}

