/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.editor.handlers;

import com.ca.filemaster.common.CommonMFCalls;
import com.ca.filemaster.common.FileMasterDataset;
import com.ca.filemaster.common.FileMasterServer;
import com.ca.filemaster.editor.FMEditorProfile;
import com.ca.filemaster.editor.RunGetGetRecords;
import com.ca.filemaster.editor.RunGetStartEdit;
import com.ca.filemaster.editor.virtualtableviews.CharFormatMode;
import com.ca.filemaster.editor.virtualtableviews.EditorView;
import com.ca.filemaster.views.report.ReportView;
import com.ca.testingtools.common.XMLRequest;
import java.util.UUID;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SyslistHandler
extends AbstractHandler {
    private IWorkbenchPage page;
    private IViewPart view;
    private FileMasterServer server;
    private FMEditorProfile profile;
    private int recordCount = 0;
    public String returnCode = "";
    private String uuid = "";
    public FileMasterDataset dataset;
    private String secondaryID = "";
    private String reportViewID = "";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String message = "";
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
        this.page = win.getActivePage();
        IWorkbenchPart workbenchPart = this.page.getActivePart();
        this.reportViewID = ((IViewSite)workbenchPart.getSite()).getSecondaryId();
        if (workbenchPart instanceof ReportView) {
            this.dataset = ((ReportView)workbenchPart).getDataset();
            this.server = ((ReportView)workbenchPart).getServer();
            RunGetStartEdit runner = new RunGetStartEdit(this.server, this.dataset.getName(), "V", "C");
            BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), (Runnable)runner);
            XMLRequest xml = runner.getXml();
            Element element = xml.getRoot();
            if (xml != null && xml.getRoot().getNodeName().equals("GUIResponse")) {
                Node rcNode;
                element = xml.getRoot();
                this.uuid = element.getAttribute("GUIsession");
                NodeList messages = element.getElementsByTagName("Message");
                NodeList retCode = element.getElementsByTagName("ReturnCode");
                message = "";
                if (retCode != null && (rcNode = retCode.item(0)) != null) {
                    Element rcElement = (Element)rcNode;
                    this.returnCode = SyslistHandler.getTagValue("ReturnCode", rcElement);
                }
                int i = 0;
                while (i < messages.getLength()) {
                    Node msgNode = messages.item(i);
                    Element msgElement = (Element)msgNode;
                    message = String.valueOf(message) + SyslistHandler.getTagValue("Message", msgElement);
                    ++i;
                }
                if (!this.returnCode.equals("0")) {
                    MessageDialog.openError(null, (String)"Syslist error", (String)message);
                } else {
                    Node startEditRes = element.getElementsByTagName("EstimatedRecordCount").item(0);
                    if (startEditRes != null) {
                        this.recordCount = Integer.parseInt(CommonMFCalls.getTagValue((String)"EstimatedRecordCount", (Element)((Element)startEditRes)));
                    }
                    if (this.recordCount == 0) {
                        this.recordCount = this.getRecordCount(this.server);
                    }
                    this.setFMEditorProfile(element);
                    CharFormatMode.PAGE_SIZE = this.recordCount;
                    CharFormatMode.COUNT = CharFormatMode.PAGE_SIZE < CharFormatMode.GUI_PAGESIZE ? CharFormatMode.PAGE_SIZE : CharFormatMode.GUI_PAGESIZE;
                    RunGetGetRecords run = new RunGetGetRecords(this.server, this.uuid, 1, 50, "C", "N");
                    BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), (Runnable)run);
                    XMLRequest recordsXML = run.getXml();
                    if (recordsXML != null) {
                        this.updateEditView(recordsXML, this.uuid, this.server);
                        ((ReportView)workbenchPart).setEditorId(this.secondaryID);
                        ((ReportView)workbenchPart).setUUID(this.uuid);
                    }
                }
            }
        }
        return null;
    }

    private int getRecordCount(FileMasterServer server) {
        int i;
        RunGetGetRecords runner = new RunGetGetRecords(server, this.uuid, -1, 1, "C", "N");
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), (Runnable)runner);
        XMLRequest xmlResponse = runner.getXml();
        Element element = xmlResponse.getRoot();
        NodeList nodeListRecord = element.getElementsByTagName("Record");
        if (nodeListRecord.getLength() > 0 && (i = 0) < nodeListRecord.getLength()) {
            return Integer.parseInt(((Element)nodeListRecord.item(i)).getAttribute("number"));
        }
        return 0;
    }

    private void setFMEditorProfile(Element element) {
        if (this.returnCode.equals("0")) {
            Node profileNode = element.getElementsByTagName("Profile").item(0);
            Node recordLengthLimitsNode = element.getElementsByTagName("RecordLengthLimits").item(0);
            ((Element)profileNode).getAttribute("");
            this.profile = new FMEditorProfile(((Element)profileNode).getAttribute("autosave"), ((Element)profileNode).getAttribute("caps"), ((Element)profileNode).getAttribute("findlim"), ((Element)profileNode).getAttribute("hex"), ((Element)profileNode).getAttribute("hilite"), ((Element)profileNode).getAttribute("nulls"), ((Element)profileNode).getAttribute("numext"), ((Element)profileNode).getAttribute("pdschg"), ((Element)profileNode).getAttribute("stats"), Integer.valueOf(((Element)recordLengthLimitsNode).getAttribute("minimum")), Integer.valueOf(((Element)recordLengthLimitsNode).getAttribute("maximum")));
        }
    }

    public void updateEditView(XMLRequest xml, String uuid, FileMasterServer server) {
        FileMasterDataset[] datasets = new FileMasterDataset[]{this.dataset, new FileMasterDataset(null)};
        this.secondaryID = UUID.randomUUID().toString();
        try {
            this.view = this.page.showView("com.ca.filemaster.editor.virtualtableviews.EditorView", this.secondaryID, 1);
            ((EditorView)this.view).addSession(server, uuid, datasets, null, this.recordCount, this.secondaryID, "C", "N", "V", this.reportViewID);
            ((EditorView)this.view).setPartName(String.valueOf(this.dataset.getName()) + "[Read-only]");
            ((EditorView)this.view).setProfile(this.profile);
            if (this.view instanceof EditorView) {
                ((EditorView)this.view).updateCharEditViewer(xml);
                ((EditorView)this.view).setToCharFMode(this.secondaryID, "N", xml);
                ((EditorView)this.view).getCharMode().updateDisplay = true;
                ((EditorView)this.view).getCharMode().setCallMF(false);
                ((EditorView)this.view).updateToolBar();
            }
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }

    private static String getTagValue(String sTag, Element eElement) {
        NodeList nlList = eElement.getChildNodes();
        Node nValue = nlList.item(0);
        if (nValue == null) {
            return "";
        }
        return nValue.getNodeValue();
    }
}

