/*
 * Decompiled with CFR 0.152.
 */
package com.ca.filemaster.editor.handlers;

import com.ca.filemaster.editor.virtualtableviews.CharFormatMode;
import com.ca.filemaster.editor.virtualtableviews.EditorView;
import com.ca.filemaster.editor.virtualtableviews.MultiRecordFormatMode;
import com.ca.filemaster.editor.virtualtableviews.SingleRecordFormatMode;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public class HexFormatHandler
extends AbstractHandler {
    private Logger log = Logger.getLogger(HexFormatHandler.class.getName());

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.log.log(Level.INFO, "hex toggle invoked");
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        if (((Event)event.getTrigger()).widget instanceof ToolItem) {
            ToolItem toolItem = (ToolItem)((Event)event.getTrigger()).widget;
            toolItem.setToolTipText("Hexadecimal");
        }
        IWorkbenchPage page = window.getActivePage();
        if (window.getActivePage().getActivePart() instanceof EditorView) {
            String secondaryID = ((IViewSite)window.getActivePage().getActivePart().getSite()).getSecondaryId();
            EditorView editorView = (EditorView)page.getActivePart();
            String displayMode = editorView.getDisplayMode(secondaryID);
            if (displayMode.equals("S")) {
                SingleRecordFormatMode singleRecordFormatMode = editorView.getSingleRecordFormatMode();
                singleRecordFormatMode.getSrfValueEditingSupport().focusLost(null);
            } else if (displayMode.equals("M")) {
                MultiRecordFormatMode multiRecordFormatMode = editorView.getMultiRecordFormatMode();
                multiRecordFormatMode.getMultiRecordDataCharEditingSupport().focusLost(null);
            } else if (displayMode.equals("C")) {
                CharFormatMode charFormatMode = editorView.getCharMode();
                charFormatMode.bypassFocusLost = true;
                charFormatMode.getCharacterDataEditingSupport().focusLost(null);
            } else {
                this.log.log(Level.WARNING, "unknown display mode: " + displayMode);
            }
            editorView.setToHexMode(secondaryID);
        }
        return null;
    }
}

